/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.listingpanel;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.DockingUtils;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.options.OptionsService;
import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.internal.FieldPanelCoordinator;
import docking.widgets.fieldpanel.listener.FieldLocationListener;
import docking.widgets.fieldpanel.support.BackgroundColorModel;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.ViewerPosition;
import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import ghidra.GhidraOptions;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.codebrowser.MarkerServiceBackgroundColorModel;
import ghidra.app.plugin.core.codebrowser.hover.DataTypeListingHover;
import ghidra.app.plugin.core.codebrowser.hover.FunctionNameListingHover;
import ghidra.app.plugin.core.codebrowser.hover.ReferenceListingHover;
import ghidra.app.plugin.core.codebrowser.hover.TruncatedTextListingHover;
import ghidra.app.plugin.core.marker.MarkerManager;
import ghidra.app.plugin.core.marker.MarkerMarginProvider;
import ghidra.app.services.ButtonPressedListener;
import ghidra.app.services.CodeFormatService;
import ghidra.app.services.GoToService;
import ghidra.app.services.MarkerSet;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.SymbolPath;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FieldHeaderComp;
import ghidra.app.util.viewer.format.FieldHeaderLocation;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.format.FormatModelListener;
import ghidra.app.util.viewer.listingpanel.ApplyFunctionSignatureAction;
import ghidra.app.util.viewer.listingpanel.DualListingActionContext;
import ghidra.app.util.viewer.listingpanel.DualListingNavigator;
import ghidra.app.util.viewer.listingpanel.DualListingServiceProvider;
import ghidra.app.util.viewer.listingpanel.ListingCodeComparisonOptions;
import ghidra.app.util.viewer.listingpanel.ListingComparisonFieldPanelCoordinator;
import ghidra.app.util.viewer.listingpanel.ListingDiffActionManager;
import ghidra.app.util.viewer.listingpanel.ListingDiffChangeListener;
import ghidra.app.util.viewer.listingpanel.ListingDiffHighlightProvider;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.listingpanel.MarginProvider;
import ghidra.app.util.viewer.listingpanel.OverviewProvider;
import ghidra.app.util.viewer.listingpanel.ProgramLocationListener;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.app.util.viewer.util.CodeComparisonPanel;
import ghidra.app.util.viewer.util.CodeComparisonPanelActionContext;
import ghidra.app.util.viewer.util.FieldNavigator;
import ghidra.app.util.viewer.util.TitledPanel;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderDecorator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.correlate.HashedFunctionAddressCorrelation;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.FunctionAddressCorrelation;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ListingAddressCorrelation;
import ghidra.program.util.ListingDiff;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.MultiAddressRangeIterator;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ListingCodeComparisonPanel
extends CodeComparisonPanel<ListingComparisonFieldPanelCoordinator>
implements FormatModelListener,
CodeFormatService,
ListingDiffChangeListener,
OptionsChangeListener {
    private static final Color FG_COLOR_TITLE = GThemeDefaults.Colors.Palette.DARK_GRAY;
    private static final String DUAL_LISTING_HEADER_SHOWING = "DUAL_LISTING_HEADER_SHOWING";
    private static final String DUAL_LISTING_SIDE_BY_SIDE = "DUAL_LISTING_SIDE_BY_SIDE";
    public static final String NAME = "DualListing";
    public static final String TITLE = "Listing View";
    protected static final HelpService help = Help.getHelpService();
    private static final String DUAL_LISTING_HELP_TOPIC = "FunctionComparison";
    private static final String DUAL_LISTING_ACTION_GROUP = "DualListing";
    private static final String DIFF_NAVIGATE_GROUP = "A2_DiffNavigate";
    private static final String HOVER_GROUP = "A5_Hovers";
    private static final String PROPERTIES_GROUP = "B1_Properties";
    private static final Icon NEXT_DIFF_ICON = new GIcon("icon.base.util.listingcompare.diff.next");
    private static final Icon PREVIOUS_DIFF_ICON = new GIcon("icon.base.util.listingcompare.previous.next");
    private static final Icon BOTH_VIEWS_ICON = new GIcon("icon.base.util.listingcompare.area.markers.all");
    private static final Icon UNMATCHED_ICON = new GIcon("icon.base.util.listingcompare.area.markers.unmatched");
    private static final Icon DIFF_ICON = new GIcon("icon.base.util.listingcompare.area.markers.diff");
    private static final Icon CURSOR_LOC_ICON = new GIcon("icon.base.util.listingcompare.cursor");
    private static final Icon HOVER_ON_ICON = new GIcon("icon.base.util.listingcompare.hover.on");
    private static final Icon HOVER_OFF_ICON = new GIcon("icon.base.util.listingcompare.hover.off");
    private static final String ALL_AREA_MARKERS = "All Area Markers";
    private static final String UNMATCHED_AREA_MARKERS = "Unmatched Area Markers";
    private static final String DIFF_AREA_MARKERS = "Diff Area Markers";
    private String nextPreviousAreaType;
    private ListingPanel[] listingPanels = new ListingPanel[2];
    private ListingDiff listingDiff;
    private ListingDiffActionManager diffActionManager;
    private DualListingServiceProvider[] dualListingServiceProviders = new DualListingServiceProvider[2];
    private DualListingNavigator[] navigatables = new DualListingNavigator[2];
    private FieldNavigator[] fieldNavigators = new FieldNavigator[2];
    private AddressIndexMap[] indexMaps = new AddressIndexMap[2];
    private AddressSetView[] addressSets = new AddressSetView[]{EMPTY_ADDRESS_SET, EMPTY_ADDRESS_SET};
    private MarkerManager[] markerManagers = new MarkerManager[2];
    private MarkerSet[] unmatchedCodeMarkers = new MarkerSet[2];
    private MarkerSet[] diffMarkers = new MarkerSet[2];
    private MarkerSet[] currentCursorMarkers = new MarkerSet[2];
    private static final Color CURSOR_LINE_COLOR = GhidraOptions.DEFAULT_CURSOR_LINE_COLOR;
    private Color cursorHighlightColor;
    private boolean isShowingEntireListing;
    private boolean isSideBySide = true;
    private boolean fieldLocationChanging = false;
    private LeftLocationListener leftLocationListener;
    private RightLocationListener rightLocationListener;
    private ToggleHeaderAction toggleHeaderAction;
    private ToggleOrientationAction toggleOrientationAction;
    private ToggleHoverAction toggleHoverAction;
    private NextPreviousAreaMarkerAction nextPreviousAreaMarkerAction;
    private NextDiffAction nextDiffAction;
    private PreviousDiffAction previousDiffAction;
    private ListingCodeComparisonOptionsAction optionsAction;
    private DockingAction[] diffActions;
    private ApplyFunctionSignatureAction applyFunctionSignatureAction;
    private JSplitPane splitPane;
    private ListingDiffHighlightProvider leftDiffHighlightProvider;
    private ListingDiffHighlightProvider rightDiffHighlightProvider;
    private FunctionAddressCorrelation correlator;
    private boolean adjustingLeftLocation = false;
    private boolean adjustingRightLocation = false;
    ReferenceListingHover referenceHoverService;
    DataTypeListingHover dataTypeHoverService;
    TruncatedTextListingHover truncatedTextHoverService;
    FunctionNameListingHover functionNameHoverService;
    private String leftTitle;
    private String rightTitle;
    private ListingCodeComparisonOptions comparisonOptions;
    private Address[] coordinatorLockedAddresses;

    public ListingCodeComparisonPanel(String owner, PluginTool tool) {
        super(owner, tool);
        this.initialize();
    }

    private void initialize() {
        this.listingDiff = new ListingDiff();
        this.diffActionManager = new ListingDiffActionManager(this.listingDiff);
        this.initializeGoToServiceProviders();
        this.buildPanel();
        this.initializeListingFieldPanels();
        this.initializeListingFieldNavigation();
        this.initializeListingHoverService();
        this.setupMarkerManagers();
        this.createActions();
        this.listingDiff.addListingDiffChangeListener(this);
        this.setScrollingSyncState(true);
        help.registerHelp((Object)this, new HelpLocation(DUAL_LISTING_HELP_TOPIC, "Dual Listing"));
        this.comparisonOptions = new ListingCodeComparisonOptions();
        this.initializeOptions();
    }

    private void initializeOptions() {
        ToolOptions options = this.tool.getOptions("Listing Code Comparison");
        options.addOptionsChangeListener((OptionsChangeListener)this);
        this.comparisonOptions.initializeOptions(options);
        this.comparisonOptions.loadOptions(options);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        this.comparisonOptions.loadOptions(options);
        this.repaint();
        if (this.programs[0] == null) {
            return;
        }
        Color unmatchedCodeUnitsBackgroundColor = this.comparisonOptions.getUnmatchedCodeUnitsBackgroundColor();
        this.unmatchedCodeMarkers[0].setMarkerColor(unmatchedCodeUnitsBackgroundColor);
        this.unmatchedCodeMarkers[1].setMarkerColor(unmatchedCodeUnitsBackgroundColor);
        Color diffCodeUnitsBackgroundColor = this.comparisonOptions.getDiffCodeUnitsBackgroundColor();
        this.diffMarkers[0].setMarkerColor(diffCodeUnitsBackgroundColor);
        this.diffMarkers[1].setMarkerColor(diffCodeUnitsBackgroundColor);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.updateActionEnablement();
    }

    private FormatManager createFormatManager(int leftOrRight) {
        ToolOptions displayOptions = this.tool.getOptions("Listing Display");
        ToolOptions fieldOptions = this.tool.getOptions("Listing Fields");
        FormatManager formatManager = new FormatManager(displayOptions, fieldOptions);
        ServiceProviderDecorator sp = ServiceProviderDecorator.createEmptyDecorator();
        sp.overrideService(GoToService.class, (Object)this.dualListingServiceProviders[leftOrRight].getService(GoToService.class));
        formatManager.setServiceProvider((ServiceProvider)sp);
        this.cursorHighlightColor = fieldOptions.isRegistered("Cursor.Highlight Cursor Line Color") ? fieldOptions.getColor("Cursor.Highlight Cursor Line Color", CURSOR_LINE_COLOR) : CURSOR_LINE_COLOR;
        return formatManager;
    }

    private void initializeGoToServiceProviders() {
        this.dualListingServiceProviders[0] = new DualListingServiceProvider((ServiceProvider)this.tool, this, true);
        this.dualListingServiceProviders[1] = new DualListingServiceProvider((ServiceProvider)this.tool, this, false);
    }

    private void initializeListingFieldPanels() {
        FieldPanel[] fieldPanels = new FieldPanel[2];
        for (int i = 0; i < 2; ++i) {
            fieldPanels[i] = this.listingPanels[i].getFieldPanel();
            fieldPanels[i].addFocusListener((FocusListener)this);
            fieldPanels[i].addMouseListener((MouseListener)new DualListingMouseListener((Component)fieldPanels[i], i));
        }
        this.leftLocationListener = new LeftLocationListener();
        this.rightLocationListener = new RightLocationListener();
        fieldPanels[0].addFieldLocationListener((FieldLocationListener)this.leftLocationListener);
        fieldPanels[1].addFieldLocationListener((FieldLocationListener)this.rightLocationListener);
    }

    @Override
    public void setFieldPanelCoordinator(ListingComparisonFieldPanelCoordinator listingFieldPanelCoordinator) {
        ListingPanel focusedListingPanel;
        ProgramLocation programLocation;
        ListingComparisonFieldPanelCoordinator fieldPanelCoordinator = (ListingComparisonFieldPanelCoordinator)this.getFieldPanelCoordinator();
        if (fieldPanelCoordinator == listingFieldPanelCoordinator) {
            return;
        }
        super.setFieldPanelCoordinator(listingFieldPanelCoordinator);
        if (listingFieldPanelCoordinator != null && (programLocation = (focusedListingPanel = this.getFocusedListingPanel()).getProgramLocation()) != null) {
            focusedListingPanel.goTo(programLocation);
        }
    }

    public void addHighlightProviders(ListingHighlightProvider leftHighlightProvider, ListingHighlightProvider rightHighlightProvider) {
        this.addLeftHighlightProvider(leftHighlightProvider);
        this.addRightHighlightProvider(rightHighlightProvider);
    }

    private void addLeftHighlightProvider(ListingHighlightProvider leftHighlightProvider) {
        this.listingPanels[0].getFormatManager().addHighlightProvider(leftHighlightProvider);
    }

    private void addRightHighlightProvider(ListingHighlightProvider rightHighlightProvider) {
        this.listingPanels[1].getFormatManager().addHighlightProvider(rightHighlightProvider);
    }

    public void removeHighlightProviders(ListingHighlightProvider leftHighlightProvider, ListingHighlightProvider rightHighlightProvider) {
        this.removeLeftHighlightProvider(leftHighlightProvider);
        this.removeRightHighlightProvider(rightHighlightProvider);
    }

    private void removeLeftHighlightProvider(ListingHighlightProvider leftHighlightProvider) {
        this.listingPanels[0].getFormatManager().removeHighlightProvider(leftHighlightProvider);
    }

    private void removeRightHighlightProvider(ListingHighlightProvider rightHighlightProvider) {
        this.listingPanels[1].getFormatManager().removeHighlightProvider(rightHighlightProvider);
    }

    @Override
    protected void setPrograms(Program leftProgram, Program rightProgram) {
        boolean programChanged = false;
        if (leftProgram != this.programs[0]) {
            this.programs[0] = leftProgram;
            this.listingPanels[0].setProgram(leftProgram);
            this.addressSets[0] = EMPTY_ADDRESS_SET;
            this.indexMaps[0] = new AddressIndexMap(this.addressSets[0]);
            this.updateLeftListingTitle();
            programChanged = true;
        }
        if (rightProgram != this.programs[1]) {
            this.programs[1] = rightProgram;
            this.listingPanels[1].setProgram(rightProgram);
            this.addressSets[1] = EMPTY_ADDRESS_SET;
            this.indexMaps[1] = new AddressIndexMap(this.addressSets[1]);
            this.updateRightListingTitle();
            programChanged = true;
        }
        this.setupAreaMarkerSets();
        this.setupCursorMarkerSets();
        if (programChanged) {
            this.showEntireListing(this.isShowingEntireListing);
        }
    }

    private void updateLeftListingTitle() {
        this.titlePanels[0].setTitleName(this.getLeftProgramName());
    }

    private String getLeftProgramName() {
        String leftProgramName = this.programs[0] != null ? this.programs[0].getDomainFile().toString() : "none";
        return leftProgramName;
    }

    private void updateRightListingTitle() {
        this.titlePanels[1].setTitleName(this.getRightProgramName());
    }

    private String getRightProgramName() {
        String rightProgramName = this.programs[1] != null ? this.programs[1].getDomainFile().toString() : "none";
        return rightProgramName;
    }

    private void initializeListingFieldNavigation() {
        this.initializeListingFieldNavigation(0);
        this.initializeListingFieldNavigation(1);
    }

    private void initializeListingFieldNavigation(int leftOrRight) {
        boolean isLeftSide = leftOrRight == 0;
        this.navigatables[leftOrRight] = new DualListingNavigator(this, isLeftSide);
        this.fieldNavigators[leftOrRight] = new FieldNavigator(this.dualListingServiceProviders[leftOrRight], this.navigatables[leftOrRight]);
        this.listingPanels[leftOrRight].addButtonPressedListener(this.fieldNavigators[leftOrRight]);
    }

    private Navigatable getFocusedNavigatable() {
        return this.navigatables[this.currProgramIndex];
    }

    private void initializeListingHoverService() {
        this.referenceHoverService = new ReferenceListingHover(this.tool, this);
        this.dataTypeHoverService = new DataTypeListingHover(this.tool);
        this.truncatedTextHoverService = new TruncatedTextListingHover(this.tool);
        this.functionNameHoverService = new FunctionNameListingHover(this.tool);
        this.initializeListingHoverService(0);
        this.initializeListingHoverService(1);
    }

    private void initializeListingHoverService(int leftOrRight) {
        ListingPanel listingPanel = this.listingPanels[leftOrRight];
        listingPanel.addHoverService(this.referenceHoverService);
        listingPanel.addHoverService(this.dataTypeHoverService);
        listingPanel.addHoverService(this.truncatedTextHoverService);
        listingPanel.addHoverService(this.functionNameHoverService);
        listingPanel.setHoverMode(true);
    }

    public void setLeftProgramLocationListener(ProgramLocationListener programLocationListener) {
        this.listingPanels[0].setProgramLocationListener(programLocationListener);
    }

    public void setRightProgramLocationListener(ProgramLocationListener programLocationListener) {
        this.listingPanels[1].setProgramLocationListener(programLocationListener);
    }

    private void createActions() {
        this.toggleHeaderAction = new ToggleHeaderAction();
        this.toggleOrientationAction = new ToggleOrientationAction();
        this.toggleHoverAction = new ToggleHoverAction();
        this.applyFunctionSignatureAction = new ApplyFunctionSignatureAction(this.owner);
        this.nextDiffAction = new NextDiffAction();
        this.previousDiffAction = new PreviousDiffAction();
        this.optionsAction = new ListingCodeComparisonOptionsAction();
        this.nextPreviousAreaMarkerAction = new NextPreviousAreaMarkerAction(this.owner);
        this.diffActions = this.getListingDiffActions();
    }

    private DockingAction[] getListingDiffActions() {
        return this.diffActionManager.getActions();
    }

    @Override
    public DockingAction[] getActions() {
        DockingAction[] codeCompActions = super.getActions();
        DockingAction[] otherActions = new DockingAction[]{this.toggleHeaderAction, this.toggleOrientationAction, this.toggleHoverAction, this.applyFunctionSignatureAction, this.nextPreviousAreaMarkerAction, this.nextDiffAction, this.previousDiffAction, this.optionsAction};
        int compCount = codeCompActions.length;
        int otherCount = otherActions.length;
        int diffCount = this.diffActions.length;
        DockingAction[] actions = new DockingAction[compCount + otherCount + diffCount];
        System.arraycopy(codeCompActions, 0, actions, 0, compCount);
        System.arraycopy(otherActions, 0, actions, compCount, otherCount);
        System.arraycopy(this.diffActions, 0, actions, compCount + otherCount, diffCount);
        return actions;
    }

    @Override
    public void updateActionEnablement() {
        boolean isShowing = this.isShowing();
        boolean listingDiffActionEnablement = isShowing && this.listingDiff.hasCorrelation();
        this.tool.contextChanged(this.tool.getActiveComponentProvider());
        this.diffActionManager.updateActionEnablement(listingDiffActionEnablement);
    }

    private void setHoverEnabled(boolean enabled) {
        this.listingPanels[0].setHoverMode(enabled);
        this.listingPanels[1].setHoverMode(enabled);
    }

    private boolean isValidPanelContext(ActionContext context) {
        CodeComparisonPanelActionContext compareContext;
        CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel;
        CodeComparisonPanel<? extends FieldPanelCoordinator> displayedPanel = null;
        if (context instanceof CodeComparisonPanelActionContext && (codeComparisonPanel = (compareContext = (CodeComparisonPanelActionContext)context).getCodeComparisonPanel()) == this) {
            displayedPanel = codeComparisonPanel;
        }
        if (displayedPanel != this) {
            return false;
        }
        ListingCodeComparisonPanel dualListingPanel = (ListingCodeComparisonPanel)displayedPanel;
        ListingPanel leftPanel = dualListingPanel.getLeftPanel();
        ListingPanel rightPanel = dualListingPanel.getRightPanel();
        Object sourceObject = context.getSourceObject();
        if (sourceObject instanceof ListingPanel) {
            ListingPanel listingPanel = (ListingPanel)sourceObject;
            return listingPanel == leftPanel || listingPanel == rightPanel;
        }
        return true;
    }

    private void nextAreaDiff(String currentUserData, boolean forward) {
        MultiAddressRangeIterator multiIterator;
        boolean leftHasFocus = this.currProgramIndex == 0;
        ListingPanel focusPanel = this.getFocusedListingPanel();
        ProgramLocation focusLocation = focusPanel.getProgramLocation();
        if (focusLocation == null) {
            this.tool.setStatusInfo("The " + (leftHasFocus ? "first" : "second") + " listing is empty.");
            return;
        }
        Address focusAddress = focusLocation.getAddress();
        ArrayList<AddressRangeIterator> iteratorList = new ArrayList<AddressRangeIterator>();
        if (currentUserData.equals(ALL_AREA_MARKERS) || currentUserData.equals(DIFF_AREA_MARKERS)) {
            AddressSetView focusDiffs = leftHasFocus ? this.listingDiff.getListing1Diffs() : this.listingDiff.getListing2Diffs();
            iteratorList.add(focusDiffs.getAddressRanges(focusAddress, forward));
        }
        if (currentUserData.equals(ALL_AREA_MARKERS) || currentUserData.equals(UNMATCHED_AREA_MARKERS)) {
            AddressSetView unmatchedCode = leftHasFocus ? this.listingDiff.getListing1UnmatchedCode() : this.listingDiff.getListing2UnmatchedCode();
            iteratorList.add(unmatchedCode.getAddressRanges(focusAddress, forward));
        }
        if ((multiIterator = new MultiAddressRangeIterator(iteratorList.toArray(new AddressRangeIterator[iteratorList.size()]), forward)).hasNext()) {
            AddressRange nextRange = multiIterator.next();
            Address minAddress = nextRange.getMinAddress();
            if ((forward ? nextRange.contains(focusAddress) : minAddress.equals((Object)focusAddress)) && multiIterator.hasNext()) {
                nextRange = multiIterator.next();
                minAddress = nextRange.getMinAddress();
            }
            if (minAddress.equals((Object)focusAddress)) {
                this.outputNoNextPreviousMessage(forward, leftHasFocus);
                return;
            }
            this.tool.clearStatusInfo();
            focusPanel.goTo(minAddress);
        } else {
            this.outputNoNextPreviousMessage(forward, leftHasFocus);
        }
    }

    private void outputNoNextPreviousMessage(boolean forward, boolean isFirstListing) {
        this.tool.setStatusInfo("There isn't another " + (forward ? "next " : "previous ") + this.getCurrentAreaMarkerType().toLowerCase() + " area in the " + (isFirstListing ? "first" : "second") + " listing.");
    }

    private String getCurrentAreaMarkerType() {
        String type = "Highlighted";
        if (this.nextPreviousAreaType.equals(UNMATCHED_AREA_MARKERS)) {
            type = "Unmatched";
        } else if (this.nextPreviousAreaType.equals(DIFF_AREA_MARKERS)) {
            type = "Difference";
        }
        return type;
    }

    public boolean isEntireListingShowing() {
        return this.isShowingEntireListing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showEntireListing(boolean show) {
        try {
            this.fieldLocationChanging = true;
            this.isShowingEntireListing = show;
            ProgramLocation leftLocation = this.listingPanels[0].getProgramLocation();
            ProgramLocation rightLocation = this.listingPanels[1].getProgramLocation();
            if (show) {
                this.loadEntirePrograms();
            } else {
                this.loadLimitedAddresses();
            }
            if (leftLocation != null) {
                this.listingPanels[0].goTo(leftLocation);
            }
            if (rightLocation != null) {
                this.listingPanels[1].goTo(rightLocation);
            }
        }
        finally {
            this.fieldLocationChanging = false;
        }
    }

    public boolean isHeaderShowing() {
        return this.getLeftPanel().isHeaderShowing();
    }

    public void setHeaderShowing(boolean show) {
        ListingPanel listingPanel = this.getLeftPanel();
        boolean isShowing = listingPanel.isHeaderShowing();
        if (show == isShowing) {
            return;
        }
        listingPanel.showHeader(show);
        this.toggleHeaderAction.setSelected(show);
    }

    public boolean isSideBySide() {
        return this.isSideBySide;
    }

    public void showSideBySide(boolean sideBySide) {
        this.isSideBySide = sideBySide;
        this.splitPane.setOrientation(this.isSideBySide ? 1 : 0);
        this.splitPane.setDividerLocation(0.5);
        this.toggleOrientationAction.setSelected(sideBySide);
    }

    private void loadEntirePrograms() {
        AddressSetView leftSet = this.programs[0] != null ? this.programs[0].getMemory() : EMPTY_ADDRESS_SET;
        AddressSetView rightSet = this.programs[1] != null ? this.programs[1].getMemory() : EMPTY_ADDRESS_SET;
        ListingComparisonFieldPanelCoordinator fieldPanelCoordinator = (ListingComparisonFieldPanelCoordinator)this.getFieldPanelCoordinator();
        if (fieldPanelCoordinator != null) {
            fieldPanelCoordinator.resetLockedLines();
        }
        this.listingPanels[0].setView(leftSet);
        this.listingPanels[1].setView(rightSet);
    }

    private void loadLimitedAddresses() {
        AddressSetView leftSet = this.addressSets[0] != null ? this.addressSets[0] : EMPTY_ADDRESS_SET;
        AddressSetView rightSet = this.addressSets[1] != null ? this.addressSets[1] : EMPTY_ADDRESS_SET;
        ListingComparisonFieldPanelCoordinator fieldPanelCoordinator = (ListingComparisonFieldPanelCoordinator)this.getFieldPanelCoordinator();
        if (fieldPanelCoordinator != null) {
            fieldPanelCoordinator.resetLockedLines();
        }
        this.listingPanels[0].setView(leftSet);
        this.listingPanels[1].setView(rightSet);
    }

    @Override
    public void loadFunctions(Function leftFunction, Function rightFunction) {
        this.setFunctions(leftFunction, rightFunction);
    }

    @Override
    public Function getLeftFunction() {
        return this.functions[0];
    }

    @Override
    public Function getRightFunction() {
        return this.functions[1];
    }

    private void setFunctions(Function leftFunction, Function rightFunction) {
        if (leftFunction != this.functions[0] || rightFunction != this.functions[1]) {
            this.clearMarkers();
            Program leftProgram = leftFunction != null ? leftFunction.getProgram() : this.programs[0];
            Program rightProgram = rightFunction != null ? rightFunction.getProgram() : this.programs[1];
            this.setPrograms(leftProgram, rightProgram);
            this.data[0] = null;
            this.data[1] = null;
            this.functions[0] = leftFunction;
            this.functions[1] = rightFunction;
            this.setFunctionTitles();
        }
        this.doLoadFunctions(leftFunction, rightFunction, TaskMonitor.DUMMY);
        if (leftFunction == null || rightFunction == null) {
            this.correlator = null;
        }
        try {
            this.listingDiff.setCorrelation((ListingAddressCorrelation)this.correlator);
            ListingComparisonFieldPanelCoordinator fieldPanelCoordinator = (ListingComparisonFieldPanelCoordinator)this.getFieldPanelCoordinator();
            if (fieldPanelCoordinator != null) {
                fieldPanelCoordinator.setCorrelation((ListingAddressCorrelation)this.correlator);
            }
        }
        catch (MemoryAccessException e) {
            String leftName = leftFunction != null ? leftFunction.getName() : "No Function";
            String rightName = rightFunction != null ? rightFunction.getName() : "No Function";
            Msg.error((Object)this, (Object)("Failed to load functions, " + leftName + " and " + rightName + " , into dual listing panel. " + e.getMessage()), (Throwable)e);
        }
        this.loadCursorArrow();
        this.updateActionEnablement();
    }

    private void loadCursorArrow() {
        int focusedSide = this.currProgramIndex;
        boolean leftHasFocus = focusedSide == 0;
        int nonFocusedSide = leftHasFocus ? 1 : 0;
        ProgramLocation focusedProgramLocation = this.listingPanels[focusedSide].getProgramLocation();
        ProgramLocation nonFocusedProgramLocation = null;
        if (focusedProgramLocation != null) {
            nonFocusedProgramLocation = this.getProgramLocation(leftHasFocus ? 1 : 0, focusedProgramLocation);
        }
        if (focusedProgramLocation != null) {
            this.setCursorMarkers(focusedSide, focusedProgramLocation);
        } else {
            this.listingPanels[focusedSide].getFieldPanel().repaint();
        }
        if (nonFocusedProgramLocation != null) {
            this.setCursorMarkers(nonFocusedSide, nonFocusedProgramLocation);
        } else {
            this.listingPanels[nonFocusedSide].getFieldPanel().repaint();
        }
    }

    private ProgramLocation getProgramLocation(int leftOrRight, ProgramLocation programLocation) {
        if (programLocation == null) {
            return null;
        }
        if (programLocation instanceof VariableLocation) {
            return this.getVariableLocation(leftOrRight, (VariableLocation)programLocation);
        }
        SaveState saveState = new SaveState();
        programLocation.saveState(saveState);
        Address address = programLocation.getAddress();
        Address desiredAddress = this.getAddress(leftOrRight, address);
        if (desiredAddress == null || desiredAddress == Address.NO_ADDRESS) {
            return null;
        }
        saveState.remove("_ADDRESS");
        saveState.putString("_ADDRESS", desiredAddress.toString());
        Address byteAddress = programLocation.getByteAddress();
        saveState.remove("_BYTE_ADDR");
        Address desiredByteAddress = null;
        if (byteAddress != null && (desiredByteAddress = this.inferDesiredByteAddress(address, desiredAddress, byteAddress, programLocation.getProgram(), this.programs[leftOrRight])) != null) {
            saveState.putString("_BYTE_ADDR", desiredByteAddress.toString());
        }
        this.adjustSymbolPath(saveState, address, desiredAddress, byteAddress, desiredByteAddress, programLocation.getProgram(), this.programs[leftOrRight]);
        saveState.remove("_REF_ADDRESS");
        return ProgramLocation.getLocation((Program)this.programs[leftOrRight], (SaveState)saveState);
    }

    private void adjustSymbolPath(SaveState saveState, Address address, Address desiredAddress, Address byteAddress, Address desiredByteAddress, Program program, Program desiredProgram) {
        Address desiredSymbolAddress;
        String[] symbolPathArray = saveState.getStrings("_SYMBOL_PATH", new String[0]);
        saveState.remove("_SYMBOL_PATH");
        if (symbolPathArray.length == 0) {
            return;
        }
        Address symbolAddress = byteAddress != null ? byteAddress : address;
        Address address2 = desiredSymbolAddress = desiredByteAddress != null ? desiredByteAddress : desiredAddress;
        if (symbolAddress == null || desiredSymbolAddress == null) {
            return;
        }
        Symbol[] symbols = program.getSymbolTable().getSymbols(symbolAddress);
        if (symbols.length == 0) {
            return;
        }
        Symbol[] desiredSymbols = desiredProgram.getSymbolTable().getSymbols(desiredSymbolAddress);
        if (desiredSymbols.length == 0) {
            return;
        }
        int desiredRow = this.adjustSymbolRow(saveState, symbols, desiredSymbols);
        int desiredIndex = this.getDesiredSymbolIndex(desiredSymbols, desiredRow);
        Symbol desiredSymbol = desiredSymbols[desiredIndex];
        SymbolPath symbolPath = this.getSymbolPath(desiredSymbol);
        saveState.putStrings("_SYMBOL_PATH", symbolPath.asArray());
    }

    private int adjustSymbolRow(SaveState saveState, Symbol[] symbols, Symbol[] desiredSymbols) {
        int row = saveState.getInt("_ROW", 0);
        int desiredRow = row;
        if (desiredRow >= desiredSymbols.length || this.isFunctionCompare() && row == symbols.length - 1) {
            desiredRow = desiredSymbols.length - 1;
        }
        saveState.remove("_ROW");
        saveState.putInt("_ROW", desiredRow);
        return desiredRow;
    }

    private int getDesiredSymbolIndex(Symbol[] desiredSymbols, int desiredRow) {
        boolean hasFunction = desiredSymbols[0].getSymbolType().equals((Object)SymbolType.FUNCTION);
        int desiredIndex = 0;
        if (desiredRow >= 0 && desiredRow < desiredSymbols.length) {
            desiredIndex = desiredRow;
        }
        if (hasFunction) {
            desiredIndex = desiredIndex == desiredSymbols.length - 1 ? 0 : ++desiredIndex;
        }
        return desiredIndex;
    }

    private SymbolPath getSymbolPath(Symbol desiredSymbol) {
        String label = desiredSymbol.getName();
        Namespace namespace = desiredSymbol.getParentNamespace();
        SymbolPath symbolPath = namespace == null || namespace.isGlobal() ? new SymbolPath(label) : new SymbolPath(new SymbolPath(namespace.getSymbol()), label);
        return symbolPath;
    }

    private Address inferDesiredByteAddress(Address address, Address desiredAddress, Address byteAddress, Program program, Program desiredProgram) {
        if (this.isFunctionCompare()) {
            return this.inferDesiredFunctionAddress(address, desiredAddress, byteAddress, program, desiredProgram);
        }
        if (this.isDataCompare()) {
            return this.inferDesiredDataAddress(address, desiredAddress, byteAddress, program, desiredProgram);
        }
        return null;
    }

    private Address inferDesiredDataAddress(Address codeUnitAddress, Address desiredCodeUnitAddress, Address byteAddress, Program program, Program desiredProgram) {
        long offset = byteAddress.subtract(codeUnitAddress);
        if (offset == 0L) {
            return desiredCodeUnitAddress;
        }
        if (offset > 0L) {
            CodeUnit codeUnit = program.getListing().getCodeUnitContaining(codeUnitAddress);
            CodeUnit desiredCodeUnit = desiredProgram.getListing().getCodeUnitContaining(desiredCodeUnitAddress);
            if (codeUnit != null && desiredCodeUnit != null) {
                try {
                    return desiredCodeUnitAddress.add(offset);
                }
                catch (AddressOutOfBoundsException e) {
                    return null;
                }
            }
        }
        return null;
    }

    private Address inferDesiredFunctionAddress(Address address, Address desiredAddress, Address byteAddress, Program program, Program desiredProgram) {
        long numBytesIntoCodeUnit = byteAddress.subtract(address);
        if (numBytesIntoCodeUnit == 0L) {
            return desiredAddress;
        }
        if (numBytesIntoCodeUnit > 0L) {
            CodeUnit codeUnit = program.getListing().getCodeUnitAt(address);
            CodeUnit desiredCodeUnit = desiredProgram.getListing().getCodeUnitAt(desiredAddress);
            if (codeUnit != null && desiredCodeUnit != null) {
                int desiredCodeUnitLength = desiredCodeUnit.getLength();
                if (numBytesIntoCodeUnit < (long)desiredCodeUnitLength) {
                    return desiredAddress.add(numBytesIntoCodeUnit);
                }
                return desiredAddress.add((long)(desiredCodeUnitLength - 1));
            }
        }
        return null;
    }

    private ProgramLocation getVariableLocation(int leftOrRight, VariableLocation variableLocation) {
        Function thunkedFunction;
        if (variableLocation == null) {
            return null;
        }
        SaveState saveState = new SaveState();
        variableLocation.saveState(saveState);
        Address address = variableLocation.getAddress();
        Address byteAddress = variableLocation.getByteAddress();
        Address functionAddress = variableLocation.getFunctionAddress();
        Address desiredAddress = this.getAddress(leftOrRight, address);
        if (desiredAddress == null || desiredAddress == Address.NO_ADDRESS) {
            return null;
        }
        Address desiredByteAddress = null;
        if (byteAddress != null) {
            desiredByteAddress = this.getAddress(leftOrRight, byteAddress);
        }
        Address desiredFunctionAddress = null;
        if (functionAddress != null) {
            desiredFunctionAddress = this.getAddress(leftOrRight, functionAddress);
        }
        if (desiredFunctionAddress == null && this.functions[leftOrRight] != null && (thunkedFunction = this.functions[leftOrRight].getThunkedFunction(true)) != null) {
            desiredFunctionAddress = thunkedFunction.getEntryPoint();
        }
        saveState.remove("_ADDRESS");
        saveState.putString("_ADDRESS", desiredAddress.toString());
        saveState.remove("_BYTE_ADDR");
        if (desiredByteAddress != null) {
            saveState.putString("_BYTE_ADDR", desiredByteAddress.toString());
        }
        saveState.remove("_FUNC_ADDRESS");
        if (desiredFunctionAddress != null) {
            saveState.putString("_FUNC_ADDRESS", desiredFunctionAddress.toString());
        }
        saveState.remove("_REF_ADDRESS");
        return ProgramLocation.getLocation((Program)this.programs[leftOrRight], (SaveState)saveState);
    }

    private void clearMarkers() {
        this.clearUnmatchedCodeMarkers();
        this.clearDiffMarkers();
        this.clearCursorMarkers();
    }

    private void clearUnmatchedCodeMarkers() {
        if (this.unmatchedCodeMarkers[0] != null) {
            this.unmatchedCodeMarkers[0].clearAll();
        }
        if (this.unmatchedCodeMarkers[1] != null) {
            this.unmatchedCodeMarkers[1].clearAll();
        }
    }

    private void clearDiffMarkers() {
        if (this.diffMarkers[0] != null) {
            this.diffMarkers[0].clearAll();
        }
        if (this.diffMarkers[1] != null) {
            this.diffMarkers[1].clearAll();
        }
    }

    private void setCursorMarkers(int leftOrRight, ProgramLocation location) {
        if (this.currentCursorMarkers[leftOrRight] != null) {
            this.currentCursorMarkers[leftOrRight].clearAll();
            if (location != null) {
                this.currentCursorMarkers[leftOrRight].add(location.getAddress());
            }
        }
    }

    private void clearCursorMarkers() {
        if (this.currentCursorMarkers[0] != null) {
            this.currentCursorMarkers[0].clearAll();
        }
        if (this.currentCursorMarkers[1] != null) {
            this.currentCursorMarkers[1].clearAll();
        }
    }

    private void setFunctionTitles() {
        this.setLeftTitle(this.getFunctionTitle(this.functions[0]));
        this.setRightTitle(this.getFunctionTitle(this.functions[1]));
    }

    private String getFunctionTitle(Function function) {
        if (function == null) {
            return "none";
        }
        StringBuffer buf = new StringBuffer();
        String padStr = HTMLUtilities.spaces((int)4);
        buf.append(padStr);
        String functionStr = HTMLUtilities.friendlyEncodeHTML((String)(function.getName(true) + "()"));
        String specialFunctionStr = HTMLUtilities.bold((String)functionStr);
        buf.append(specialFunctionStr);
        Program program = function.getProgram();
        if (program != null) {
            buf.append(" in ");
            String programStr = HTMLUtilities.friendlyEncodeHTML((String)program.getDomainFile().getPathname());
            String specialProgramStr = HTMLUtilities.colorString((Color)FG_COLOR_TITLE, (String)programStr);
            buf.append(specialProgramStr);
            buf.append(padStr);
        }
        return HTMLUtilities.wrapAsHTML((String)buf.toString());
    }

    private void setDataTitles() {
        this.setLeftTitle(this.getDataTitle(this.data[0]));
        this.setRightTitle(this.getDataTitle(this.data[1]));
    }

    private String getDataTitle(Data currentData) {
        if (currentData == null) {
            return "none";
        }
        StringBuffer buf = new StringBuffer();
        String padStr = HTMLUtilities.spaces((int)4);
        buf.append(padStr);
        String dataLabel = currentData.getLabel();
        if (dataLabel == null) {
            Address address = currentData.getAddress();
            dataLabel = address.toString();
        }
        String dataStr = HTMLUtilities.friendlyEncodeHTML((String)dataLabel);
        String specialDataStr = HTMLUtilities.bold((String)dataStr);
        buf.append(specialDataStr);
        Program program = currentData.getProgram();
        if (program != null) {
            buf.append(" in ");
            String programStr = HTMLUtilities.friendlyEncodeHTML((String)program.getDomainFile().getPathname());
            String specialProgramStr = HTMLUtilities.colorString((Color)FG_COLOR_TITLE, (String)programStr);
            buf.append(specialProgramStr);
            buf.append(padStr);
        }
        return HTMLUtilities.wrapAsHTML((String)buf.toString());
    }

    private void setAddressesTitles() {
        this.setLeftTitle(this.getAddressesTitle(this.programs[0], this.addressSets[0]));
        this.setRightTitle(this.getAddressesTitle(this.programs[1], this.addressSets[1]));
    }

    private String getAddressesTitle(Program program, AddressSetView addresses) {
        if (program == null) {
            return "none";
        }
        StringBuffer buf = new StringBuffer();
        String padStr = HTMLUtilities.spaces((int)4);
        buf.append(padStr);
        String programStr = HTMLUtilities.friendlyEncodeHTML((String)program.getDomainFile().getPathname());
        String specialProgramStr = HTMLUtilities.colorString((Color)FG_COLOR_TITLE, (String)programStr);
        buf.append(specialProgramStr);
        buf.append(padStr);
        return HTMLUtilities.wrapAsHTML((String)buf.toString());
    }

    private void setDiffHighlights() {
        this.setFunctionComparisonDiffHighlights();
        this.setUnmatchedCodeUnitAreaMarkers();
        this.setDiffAreaMarkers();
    }

    private void setFunctionComparisonDiffHighlights() {
        this.removeHighlightProviders(this.leftDiffHighlightProvider, this.rightDiffHighlightProvider);
        this.leftDiffHighlightProvider = new ListingDiffHighlightProvider(this.listingDiff, true, this.comparisonOptions);
        this.rightDiffHighlightProvider = new ListingDiffHighlightProvider(this.listingDiff, false, this.comparisonOptions);
        this.addHighlightProviders(this.leftDiffHighlightProvider, this.rightDiffHighlightProvider);
    }

    private void setDiffAreaMarkers() {
        Color codeUnitDiffsBackgroundColor = this.comparisonOptions.getDiffCodeUnitsBackgroundColor();
        AddressSetView listing1Diffs = this.listingDiff.getListing1Diffs();
        AddressSetView listing2Diffs = this.listingDiff.getListing2Diffs();
        if (this.diffMarkers[0] != null) {
            this.diffMarkers[0].setMarkerColor(codeUnitDiffsBackgroundColor);
            this.diffMarkers[0].clearAll();
            this.diffMarkers[0].add(listing1Diffs);
            this.listingPanels[0].getFieldPanel().repaint();
        }
        if (this.diffMarkers[1] != null) {
            this.diffMarkers[1].setMarkerColor(codeUnitDiffsBackgroundColor);
            this.diffMarkers[1].clearAll();
            this.diffMarkers[1].add(listing2Diffs);
            this.listingPanels[1].getFieldPanel().repaint();
        }
    }

    private void setUnmatchedCodeUnitAreaMarkers() {
        Color unmatchedCodeUnitsBackgroundColor = this.comparisonOptions.getUnmatchedCodeUnitsBackgroundColor();
        AddressSetView listing1UnmatchedCode = this.listingDiff.getListing1UnmatchedCode();
        AddressSetView listing2UnmatchedCode = this.listingDiff.getListing2UnmatchedCode();
        if (this.unmatchedCodeMarkers[0] != null) {
            this.unmatchedCodeMarkers[0].setMarkerColor(unmatchedCodeUnitsBackgroundColor);
            this.unmatchedCodeMarkers[0].clearAll();
            this.unmatchedCodeMarkers[0].add(listing1UnmatchedCode);
            this.listingPanels[0].getFieldPanel().repaint();
        }
        if (this.unmatchedCodeMarkers[1] != null) {
            this.unmatchedCodeMarkers[1].setMarkerColor(unmatchedCodeUnitsBackgroundColor);
            this.unmatchedCodeMarkers[1].clearAll();
            this.unmatchedCodeMarkers[1].add(listing2UnmatchedCode);
            this.listingPanels[1].getFieldPanel().repaint();
        }
    }

    private void setupMarkerManagers() {
        this.setupMarkerManager(0);
        this.setupMarkerManager(1);
    }

    private void setupMarkerManager(int leftOrRight) {
        if (this.markerManagers[leftOrRight] == null) {
            this.markerManagers[leftOrRight] = new DualListingMarkerManager(this.owner, this.tool, this.dualListingServiceProviders[leftOrRight]);
            this.markerManagers[leftOrRight].addChangeListener(new MarkerChangeListener(leftOrRight));
            MarkerMarginProvider marginProvider = this.markerManagers[leftOrRight].getMarginProvider();
            JComponent providerComp = marginProvider.getComponent();
            DualListingMouseListener providerMouseListener = new DualListingMouseListener(providerComp, leftOrRight);
            providerComp.addMouseListener(providerMouseListener);
            this.listingPanels[leftOrRight].addMarginProvider(marginProvider);
            OverviewProvider overviewProvider = this.markerManagers[leftOrRight].getOverviewProvider();
            JComponent overviewComp = overviewProvider.getComponent();
            DualListingMouseListener overviewMouseListener = new DualListingMouseListener(overviewComp, leftOrRight);
            overviewComp.addMouseListener(overviewMouseListener);
            this.listingPanels[leftOrRight].addOverviewProvider(overviewProvider);
        }
    }

    private void setupAreaMarkerSets() {
        Color diffCodeUnitsBackgroundColor = this.comparisonOptions.getDiffCodeUnitsBackgroundColor();
        Color unmatchedCodeUnitsBackgroundColor = this.comparisonOptions.getUnmatchedCodeUnitsBackgroundColor();
        if (this.programs[0] != null) {
            AddressIndexMap indexMap = this.listingPanels[0].getAddressIndexMap();
            this.listingPanels[0].getFieldPanel().setBackgroundColorModel((BackgroundColorModel)new MarkerServiceBackgroundColorModel(this.markerManagers[0], this.programs[0], indexMap));
            this.unmatchedCodeMarkers[0] = this.markerManagers[0].createAreaMarker("Listing1 Unmatched Code", "Instructions that are not matched to an instruction in the other function.", this.programs[0], 80, true, true, true, unmatchedCodeUnitsBackgroundColor);
            this.diffMarkers[0] = this.markerManagers[0].createAreaMarker("Listing1 Diffs", "Instructions that have a difference.", this.programs[0], 80, true, true, true, diffCodeUnitsBackgroundColor);
        }
        if (this.programs[1] != null) {
            AddressIndexMap rightIndexMap = this.listingPanels[1].getAddressIndexMap();
            this.listingPanels[1].getFieldPanel().setBackgroundColorModel((BackgroundColorModel)new MarkerServiceBackgroundColorModel(this.markerManagers[1], this.programs[1], rightIndexMap));
            this.unmatchedCodeMarkers[1] = this.markerManagers[1].createAreaMarker("Listing2 Unmatched Code", "Instructions that are not matched to an instruction in the other function.", this.programs[1], 80, true, true, true, unmatchedCodeUnitsBackgroundColor);
            this.diffMarkers[1] = this.markerManagers[1].createAreaMarker("Listing2 Diffs", "Instructions that have a difference.", this.programs[1], 80, true, true, true, diffCodeUnitsBackgroundColor);
        }
    }

    private void setupCursorMarkerSets() {
        if (this.programs[0] != null) {
            this.currentCursorMarkers[0] = this.markerManagers[0].createPointMarker("Cursor", "Cursor Location", this.programs[0], 49, true, true, true, this.cursorHighlightColor, CURSOR_LOC_ICON, false);
        }
        if (this.programs[1] != null) {
            this.currentCursorMarkers[1] = this.markerManagers[1].createPointMarker("Cursor", "Cursor Location", this.programs[1], 49, true, true, true, this.cursorHighlightColor, CURSOR_LOC_ICON, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadFunctions(Function leftFunction, Function rightFunction, TaskMonitor monitor) {
        try {
            this.fieldLocationChanging = true;
            this.updateLeftAddressSet(leftFunction);
            this.updateRightAddressSet(rightFunction);
            try {
                this.correlator = new HashedFunctionAddressCorrelation(leftFunction, rightFunction, monitor);
            }
            catch (CancelledException e) {
                this.correlator = null;
            }
            catch (MemoryAccessException e) {
                this.correlator = null;
            }
            if (this.isShowingEntireListing) {
                this.loadEntirePrograms();
            } else {
                this.loadLimitedAddresses();
            }
            this.goToLeftFunction(leftFunction);
            this.goToRightFunction(rightFunction);
            this.validate();
        }
        finally {
            this.fieldLocationChanging = false;
        }
    }

    private void goToLeftFunction(Function leftFunction) {
        if (leftFunction != null && !this.adjustingLeftLocation) {
            try {
                this.adjustingLeftLocation = true;
                this.listingPanels[0].goTo((ProgramLocation)new FunctionSignatureFieldLocation(leftFunction.getProgram(), leftFunction.getEntryPoint(), null, 0, leftFunction.getPrototypeString(false, false)));
            }
            finally {
                this.adjustingLeftLocation = false;
            }
        }
    }

    private void goToRightFunction(Function rightFunction) {
        if (rightFunction != null && !this.adjustingRightLocation) {
            try {
                this.adjustingRightLocation = true;
                this.listingPanels[1].goTo((ProgramLocation)new FunctionSignatureFieldLocation(rightFunction.getProgram(), rightFunction.getEntryPoint(), null, 0, rightFunction.getPrototypeString(false, false)));
            }
            finally {
                this.adjustingRightLocation = false;
            }
        }
    }

    private void updateLeftAddressSet(Function leftFunction) {
        AddressSetView addressSetView = this.addressSets[0] = leftFunction != null ? leftFunction.getBody() : EMPTY_ADDRESS_SET;
        if (leftFunction != null && this.addressSets[0].isEmpty()) {
            Address entryPoint = leftFunction.getEntryPoint();
            this.addressSets[0] = new AddressSet(leftFunction.getProgram(), entryPoint, entryPoint);
        }
        this.indexMaps[0] = new AddressIndexMap(this.addressSets[0]);
        this.markerManagers[0].getOverviewProvider().setProgram(this.getLeftProgram(), this.indexMaps[0]);
        this.listingPanels[0].getFieldPanel().setBackgroundColorModel((BackgroundColorModel)new MarkerServiceBackgroundColorModel(this.markerManagers[0], this.programs[0], this.indexMaps[0]));
    }

    private void updateRightAddressSet(Function rightFunction) {
        AddressSetView addressSetView = this.addressSets[1] = rightFunction != null ? rightFunction.getBody() : EMPTY_ADDRESS_SET;
        if (rightFunction != null && this.addressSets[1].isEmpty()) {
            Address entryPoint = rightFunction.getEntryPoint();
            this.addressSets[1] = new AddressSet(rightFunction.getProgram(), entryPoint, entryPoint);
        }
        this.indexMaps[1] = new AddressIndexMap(this.addressSets[1]);
        this.markerManagers[1].getOverviewProvider().setProgram(this.getRightProgram(), this.indexMaps[1]);
        this.listingPanels[1].getFieldPanel().setBackgroundColorModel((BackgroundColorModel)new MarkerServiceBackgroundColorModel(this.markerManagers[1], this.programs[1], this.indexMaps[1]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadAddresses(Program leftProgram, Program rightProgram, AddressSetView leftAddresses, AddressSetView rightAddresses) {
        this.setPrograms(leftProgram, rightProgram);
        try {
            this.fieldLocationChanging = true;
            this.addressSets[0] = leftProgram != null && leftAddresses != null ? leftAddresses : EMPTY_ADDRESS_SET;
            this.addressSets[1] = rightProgram != null && rightAddresses != null ? rightAddresses : EMPTY_ADDRESS_SET;
            this.clearCorrelation();
            if (this.isShowingEntireListing) {
                this.loadEntirePrograms();
            } else {
                this.loadLimitedAddresses();
            }
            this.setAddressesTitles();
            if (this.programs[0] != null && !this.addressSets[0].isEmpty()) {
                this.listingPanels[0].goTo(new ProgramLocation(this.programs[0], this.addressSets[0].getMinAddress()));
            }
            if (this.programs[1] != null && !this.addressSets[1].isEmpty()) {
                this.listingPanels[1].goTo(new ProgramLocation(this.programs[1], this.addressSets[1].getMinAddress()));
            }
        }
        finally {
            this.loadCursorArrow();
            this.updateActionEnablement();
            this.fieldLocationChanging = false;
        }
    }

    public void setLocation(Function leftFunction, Function rightFunction) {
        this.goToLeftFunction(leftFunction);
        this.goToRightFunction(rightFunction);
    }

    public void setLeftLocation(Program program, ProgramLocation location) {
        if (this.isShowing()) {
            this.goToLeftLocation(location);
        }
    }

    public void setRightLocation(Program program, ProgramLocation location) {
        if (this.isShowing()) {
            this.goToRightLocation(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void goToLeftLocation(ProgramLocation location) {
        if (this.adjustingLeftLocation || location == null) {
            return;
        }
        try {
            CodeUnit leftCodeUnit;
            this.adjustingLeftLocation = true;
            Address address = location.getAddress();
            if (location instanceof CodeUnitLocation && (leftCodeUnit = this.programs[0].getListing().getCodeUnitContaining(address)) == null) {
                return;
            }
            this.listingPanels[0].goTo(location, false);
        }
        finally {
            this.adjustingLeftLocation = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void goToRightLocation(ProgramLocation location) {
        if (this.adjustingRightLocation || location == null) {
            return;
        }
        try {
            CodeUnit rightCodeUnit;
            this.adjustingRightLocation = true;
            Address address = location.getAddress();
            if (location instanceof CodeUnitLocation && (rightCodeUnit = this.programs[1].getListing().getCodeUnitContaining(address)) == null) {
                return;
            }
            this.listingPanels[1].goTo(location, false);
        }
        finally {
            this.adjustingRightLocation = false;
        }
    }

    private void buildPanel() {
        this.setName("DualListing");
        this.setLayout(new BorderLayout());
        if (this.splitPane != null) {
            this.remove(this.splitPane);
            this.listingPanels[0].dispose();
            this.listingPanels[1].dispose();
        }
        FormatManager leftFormatManager = this.createFormatManager(0);
        leftFormatManager.addFormatModelListener(this);
        this.listingPanels[0] = new ListingPanel(leftFormatManager, this.programs[0]);
        FormatManager rightFormatManager = this.createFormatManager(1);
        this.listingPanels[1] = new ListingPanel(rightFormatManager, this.programs[1]);
        this.listingPanels[0].setBorder(FOCUS_BORDER);
        this.listingPanels[1].setBorder(NON_FOCUS_BORDER);
        this.listingPanels[0].getFieldPanel().enableSelection(false);
        this.listingPanels[1].getFieldPanel().enableSelection(false);
        String leftProgramName = this.programs[0] != null ? this.programs[0].getDomainFile().toString() : "none";
        String rightProgramName = this.programs[1] != null ? this.programs[1].getDomainFile().toString() : "none";
        this.titlePanels[0] = new TitledPanel(leftProgramName, (JComponent)this.listingPanels[0], 5);
        this.titlePanels[1] = new TitledPanel(rightProgramName, (JComponent)this.listingPanels[1], 5);
        this.titlePanels[0].setMinimumSize(new Dimension(50, this.titlePanels[0].getMinimumSize().height));
        this.titlePanels[1].setMinimumSize(new Dimension(50, this.titlePanels[1].getMinimumSize().height));
        this.splitPane = new JSplitPane(1, true, this.titlePanels[0], this.titlePanels[1]);
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setDividerSize(4);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.splitPane, "Center");
    }

    private void setTitle(TitledPanel titlePanel, String titlePrefix, String title) {
        String htmlPrefix;
        if (!((String)titlePrefix).isEmpty()) {
            titlePrefix = (String)titlePrefix + " ";
        }
        if (title.startsWith(htmlPrefix = "<HTML>")) {
            titlePanel.setTitleName(htmlPrefix + HTMLUtilities.friendlyEncodeHTML((String)titlePrefix) + title.substring(htmlPrefix.length()));
        } else {
            titlePanel.setTitleName((String)titlePrefix + title);
        }
    }

    public void setLeftTitle(String leftTitle) {
        this.leftTitle = leftTitle;
        this.setTitle(this.titlePanels[0], this.leftTitlePrefix, leftTitle);
    }

    public void setRightTitle(String rightTitle) {
        this.rightTitle = rightTitle;
        this.setTitle(this.titlePanels[1], this.rightTitlePrefix, rightTitle);
    }

    public void setTopComponent(JComponent comp) {
        if (this.topComp == comp) {
            return;
        }
        if (this.topComp != null) {
            this.remove(this.topComp);
        }
        this.topComp = comp;
        if (this.topComp != null) {
            this.add((Component)this.topComp, "North");
        }
        this.validate();
    }

    public void setBottomComponent(JComponent comp) {
        if (this.bottomComp == comp) {
            return;
        }
        if (this.bottomComp != null) {
            this.remove(this.bottomComp);
        }
        this.validate();
        this.bottomComp = comp;
        if (this.bottomComp != null) {
            this.add((Component)this.bottomComp, "South");
        }
        this.validate();
    }

    public Program getFocusedProgram() {
        return this.programs[this.currProgramIndex];
    }

    @Override
    public Program getLeftProgram() {
        return this.programs[0];
    }

    @Override
    public Program getRightProgram() {
        return this.programs[1];
    }

    @Override
    public AddressSetView getLeftAddresses() {
        return this.addressSets[0];
    }

    @Override
    public AddressSetView getRightAddresses() {
        return this.addressSets[1];
    }

    public ListingPanel getFocusedListingPanel() {
        return this.listingPanels[this.currProgramIndex];
    }

    public ListingPanel getLeftPanel() {
        return this.listingPanels[0];
    }

    public ListingPanel getRightPanel() {
        return this.listingPanels[1];
    }

    public boolean goTo(Address addr) {
        return this.listingPanels[this.currProgramIndex].goTo(addr);
    }

    public boolean goTo(ProgramLocation loc, boolean centerOnScreen) {
        return this.listingPanels[this.currProgramIndex].goTo(loc, centerOnScreen);
    }

    @Override
    public void dispose() {
        this.setFieldPanelCoordinator((ListingComparisonFieldPanelCoordinator)null);
        this.listingDiff.removeListingDiffChangeListener(this);
        this.markerManagers[0].dispose();
        this.markerManagers[1].dispose();
        this.listingPanels[0].getFieldPanel().removeFieldLocationListener((FieldLocationListener)this.leftLocationListener);
        this.listingPanels[1].getFieldPanel().removeFieldLocationListener((FieldLocationListener)this.rightLocationListener);
        for (int i = 0; i < 2; ++i) {
            this.listingPanels[i].dispose();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Component comp = e.getComponent();
        for (int i = 0; i < this.listingPanels.length; ++i) {
            if (this.listingPanels[i].getFieldPanel() != comp) continue;
            this.setDualPanelFocus(i);
        }
        if (this.tool.getActiveComponentProvider() != null) {
            this.tool.getActiveComponentProvider().contextChanged();
        }
    }

    private void setDualPanelFocus(int leftOrRight) {
        this.currProgramIndex = leftOrRight;
        this.listingPanels[leftOrRight].setBorder(FOCUS_BORDER);
        this.listingPanels[leftOrRight == 0 ? 1 : 0].setBorder(NON_FOCUS_BORDER);
    }

    @Override
    public ActionContext getActionContext(ComponentProvider provider, MouseEvent event) {
        ListingCodeComparisonPanel dualListingPanel = this;
        if (event == null) {
            Navigatable focusedNavigatable = dualListingPanel.getFocusedNavigatable();
            DualListingActionContext myActionContext = new DualListingActionContext(provider, focusedNavigatable);
            myActionContext.setContextObject(this);
            myActionContext.setCodeComparisonPanel(this);
            return myActionContext;
        }
        ListingPanel leftPanel = dualListingPanel.getLeftPanel();
        ListingPanel rightPanel = dualListingPanel.getRightPanel();
        Object leftMarginContext = this.getContextForMarginPanels(leftPanel, event);
        if (leftMarginContext != null) {
            return new DefaultActionContext(provider).setContextObject(leftMarginContext);
        }
        Object rightMarginContext = this.getContextForMarginPanels(rightPanel, event);
        if (rightMarginContext != null) {
            return new DefaultActionContext(provider).setContextObject(rightMarginContext);
        }
        Object source = event.getSource();
        if (source instanceof FieldHeaderComp) {
            FieldHeaderLocation fieldHeaderLocation = leftPanel.getFieldHeader().getFieldHeaderLocation(event.getPoint());
            return new DefaultActionContext(provider).setContextObject((Object)fieldHeaderLocation);
        }
        Navigatable focusedNavigatable = dualListingPanel.getFocusedNavigatable();
        DualListingActionContext myActionContext = new DualListingActionContext(provider, focusedNavigatable);
        myActionContext.setContextObject(this);
        myActionContext.setCodeComparisonPanel(this);
        myActionContext.setSourceObject(source);
        return myActionContext;
    }

    private Object getContextForMarginPanels(ListingPanel lp, MouseEvent event) {
        Object source = event.getSource();
        List<MarginProvider> marginProvidersForLP = lp.getMarginProviders();
        for (MarginProvider marginProvider : marginProvidersForLP) {
            JComponent c = marginProvider.getComponent();
            if (c != source) continue;
            MarkerLocation loc = marginProvider.getMarkerLocation(event.getX(), event.getY());
            if (loc != null) {
                return loc;
            }
            return source;
        }
        List<OverviewProvider> overviewProvidersForLP = lp.getOverviewProviders();
        for (OverviewProvider overviewProvider : overviewProvidersForLP) {
            JComponent c = overviewProvider.getComponent();
            if (c != source) continue;
            return source;
        }
        return null;
    }

    public void addButtonPressedListener(ButtonPressedListener listener) {
        for (ListingPanel listingPanel : this.listingPanels) {
            listingPanel.addButtonPressedListener(listener);
        }
    }

    public void updateListings() {
        if (!this.isVisible()) {
            return;
        }
        this.listingPanels[0].repaint();
        this.listingPanels[1].repaint();
    }

    private Address getAddress(int leftOrRight, Address otherSidesAddress) {
        if (this.isFunctionCompare()) {
            return this.getFunctionAddress(leftOrRight, otherSidesAddress);
        }
        if (this.isDataCompare()) {
            return this.getDataAddress(leftOrRight, otherSidesAddress);
        }
        return null;
    }

    private Address getFunctionAddress(int leftOrRight, Address otherSidesAddress) {
        Address desiredCodeUnitAddress;
        Address desiredSidesAddress;
        int otherSide = leftOrRight == 1 ? 0 : 1;
        Address address = desiredSidesAddress = leftOrRight == 1 ? this.getRightCorrelatedAddress(otherSidesAddress) : this.getLeftCorrelatedAddress(otherSidesAddress);
        if (desiredSidesAddress != null) {
            return desiredSidesAddress;
        }
        CodeUnit otherCodeUnit = this.programs[otherSide].getListing().getCodeUnitContaining(otherSidesAddress);
        if (otherCodeUnit == null) {
            return null;
        }
        Address otherCodeUnitAddress = otherCodeUnit.getMinAddress();
        Address address2 = desiredCodeUnitAddress = leftOrRight == 1 ? this.getRightCorrelatedAddress(otherCodeUnitAddress) : this.getLeftCorrelatedAddress(otherCodeUnitAddress);
        if (desiredCodeUnitAddress == null) {
            return null;
        }
        return this.inferDesiredFunctionAddress(otherCodeUnitAddress, desiredCodeUnitAddress, otherSidesAddress, this.programs[otherSide], this.programs[leftOrRight]);
    }

    private Address getDataAddress(int leftOrRight, Address otherSidesAddress) {
        Address leftDataAddress = this.getLeftDataAddress();
        Address rightDataAddress = this.getRightDataAddress();
        if (leftOrRight == 1) {
            return this.inferDesiredDataAddress(leftDataAddress, rightDataAddress, otherSidesAddress, this.programs[0], this.programs[1]);
        }
        return this.inferDesiredDataAddress(rightDataAddress, leftDataAddress, otherSidesAddress, this.programs[1], this.programs[0]);
    }

    private boolean isFunctionCompare() {
        Address leftFunctionAddress = this.getLeftFunctionAddress();
        Address rightFunctionAddress = this.getRightFunctionAddress();
        return leftFunctionAddress != null && rightFunctionAddress != null;
    }

    private boolean isDataCompare() {
        Address leftDataAddress = this.getLeftDataAddress();
        Address rightDataAddress = this.getRightDataAddress();
        return leftDataAddress != null && rightDataAddress != null;
    }

    private Address getLeftCorrelatedAddress(Address rightByteAddress) {
        if (this.correlator != null) {
            return this.correlator.getAddressInFirst(rightByteAddress);
        }
        return null;
    }

    private Address getRightCorrelatedAddress(Address leftByteAddress) {
        if (this.correlator != null) {
            return this.correlator.getAddressInSecond(leftByteAddress);
        }
        return null;
    }

    private Address getLeftFunctionAddress() {
        if (this.functions[0] != null) {
            return this.functions[0].getEntryPoint();
        }
        return null;
    }

    private Address getRightFunctionAddress() {
        if (this.functions[1] != null) {
            return this.functions[1].getEntryPoint();
        }
        return null;
    }

    private Address getLeftDataAddress() {
        if (this.data[0] != null) {
            return this.data[0].getMinAddress();
        }
        return null;
    }

    private Address getRightDataAddress() {
        if (this.data[1] != null) {
            return this.data[1].getMinAddress();
        }
        return null;
    }

    @Override
    public void formatModelAdded(FieldFormatModel model) {
        this.changeRightToMatchLeftFormat(model);
    }

    @Override
    public void formatModelChanged(FieldFormatModel model) {
        this.changeRightToMatchLeftFormat(model);
    }

    @Override
    public void formatModelRemoved(FieldFormatModel model) {
        this.changeRightToMatchLeftFormat(model);
    }

    private void changeRightToMatchLeftFormat(FieldFormatModel model) {
        SaveState saveState = new SaveState();
        this.listingPanels[0].getFormatManager().saveState(saveState);
        this.listingPanels[1].getFormatManager().readState(saveState);
    }

    public ListingPanel getListingPanel(FieldPanel fieldPanel) {
        if (this.listingPanels[0].getFieldPanel() == fieldPanel) {
            return this.listingPanels[0];
        }
        if (this.listingPanels[1].getFieldPanel() == fieldPanel) {
            return this.listingPanels[1];
        }
        return null;
    }

    @Override
    public FormatManager getFormatManager() {
        return this.listingPanels[0].getFormatManager();
    }

    @Override
    public void setMouseNavigationEnabled(boolean enabled) {
        this.listingPanels[0].removeButtonPressedListener(this.fieldNavigators[0]);
        this.listingPanels[1].removeButtonPressedListener(this.fieldNavigators[1]);
        if (enabled) {
            this.listingPanels[0].addButtonPressedListener(this.fieldNavigators[0]);
            this.listingPanels[1].addButtonPressedListener(this.fieldNavigators[1]);
        }
    }

    @Override
    public void loadData(Data leftData, Data rightData) {
        this.clearCorrelation();
        Program leftProgram = leftData != null ? leftData.getProgram() : null;
        Program rightProgram = rightData != null ? rightData.getProgram() : null;
        long maxOffset = this.getMaxOffset(leftData, rightData);
        AddressSetView leftAddressSet = EMPTY_ADDRESS_SET;
        if (leftData != null) {
            Address leftMinAddress = leftData.getMinAddress();
            Address leftEndAddress = this.getEndAddress(leftProgram, maxOffset, leftMinAddress);
            leftAddressSet = new AddressSet(leftMinAddress, leftEndAddress);
        }
        AddressSetView rightAddressSet = EMPTY_ADDRESS_SET;
        if (rightData != null) {
            Address rightMinAddress = rightData.getMinAddress();
            Address rightEndAddress = this.getEndAddress(rightProgram, maxOffset, rightMinAddress);
            rightAddressSet = new AddressSet(rightMinAddress, rightEndAddress);
        }
        this.setPrograms(leftProgram, rightProgram);
        this.functions[0] = null;
        this.functions[1] = null;
        this.data[0] = leftData;
        this.data[1] = rightData;
        this.loadAddresses(leftProgram, rightProgram, leftAddressSet, rightAddressSet);
        this.setDataTitles();
        this.updateActionEnablement();
    }

    private long getMaxOffset(Data leftData, Data rightData) {
        long leftOffset = 0L;
        if (leftData != null) {
            leftOffset = leftData.getMaxAddress().subtract(leftData.getMinAddress());
        }
        long rightOffset = 0L;
        if (rightData != null) {
            rightOffset = rightData.getMaxAddress().subtract(rightData.getMinAddress());
        }
        long maxOffset = Math.max(leftOffset, rightOffset);
        return maxOffset;
    }

    private Address getEndAddress(Program program, long maxOffset, Address minAddress) {
        Address endAddress;
        if (minAddress.isExternalAddress()) {
            return minAddress;
        }
        MemoryBlock block = program.getMemory().getBlock(minAddress);
        Address blockEnd = block.getEnd();
        try {
            endAddress = minAddress.add(maxOffset);
            if (endAddress.compareTo((Object)blockEnd) > 0) {
                endAddress = blockEnd;
            }
        }
        catch (AddressOutOfBoundsException e) {
            endAddress = blockEnd;
        }
        return endAddress;
    }

    private void clearCorrelation() {
        this.correlator = null;
        try {
            this.listingDiff.setCorrelation((ListingAddressCorrelation)this.correlator);
            ListingComparisonFieldPanelCoordinator fieldPanelCoordinator = (ListingComparisonFieldPanelCoordinator)this.getFieldPanelCoordinator();
            if (fieldPanelCoordinator != null) {
                fieldPanelCoordinator.setCorrelation((ListingAddressCorrelation)this.correlator);
            }
        }
        catch (MemoryAccessException e) {
            Msg.error((Object)this, (Object)"Couldn't clear the address correlator for the dual listing.", (Throwable)e);
        }
    }

    @Override
    public Data getLeftData() {
        return this.data[0];
    }

    @Override
    public Data getRightData() {
        return this.data[1];
    }

    @Override
    public Class<? extends CodeComparisonPanel<ListingComparisonFieldPanelCoordinator>> getPanelThisSupersedes() {
        return null;
    }

    @Override
    public void listingDiffChanged() {
        this.setDiffHighlights();
    }

    void setStatusInfo(String text) {
        this.tool.setStatusInfo(text);
    }

    @Override
    public void refreshLeftPanel() {
        this.setLeftTitle(this.getFunctionTitle(this.functions[0]));
    }

    @Override
    public void refreshRightPanel() {
        this.setRightTitle(this.getFunctionTitle(this.functions[1]));
    }

    @Override
    public void programRestored(Program program) {
        if (this.getLeftProgram() == program) {
            this.setLeftTitle(this.getFunctionTitle(this.functions[0]));
        }
        if (this.getRightProgram() == program) {
            this.setRightTitle(this.getFunctionTitle(this.functions[1]));
        }
    }

    @Override
    public boolean leftPanelHasFocus() {
        return this.currProgramIndex == 0;
    }

    @Override
    public void setTitlePrefixes(String leftTitlePrefix, String rightTitlePrefix) {
        this.leftTitlePrefix = leftTitlePrefix;
        this.rightTitlePrefix = rightTitlePrefix;
        this.setLeftTitle(this.leftTitle);
        this.setRightTitle(this.rightTitle);
    }

    GoToService getGoToService(boolean isLeftSide) {
        return this.dualListingServiceProviders[isLeftSide ? 0 : 1].getService(GoToService.class);
    }

    public ActionContext getActionContext(MouseEvent event, ComponentProvider provider) {
        Component sourceComponent;
        Object source = event != null ? event.getSource() : null;
        Component component = sourceComponent = source instanceof Component ? (Component)source : null;
        if (this.isAncestorOf(sourceComponent)) {
            ListingPanel sourcePanel = this.getLeftPanel();
            ListingPanel destinationPanel = this.getRightPanel();
            Object sourceMarginContextObject = this.getContextObjectForMarginPanels(sourcePanel, event);
            if (sourceMarginContextObject != null) {
                return new DefaultActionContext(provider).setContextObject(sourceMarginContextObject);
            }
            Object destinationMarginContextObject = this.getContextObjectForMarginPanels(destinationPanel, event);
            if (destinationMarginContextObject != null) {
                return new DefaultActionContext(provider).setContextObject(destinationMarginContextObject);
            }
            if (sourceComponent instanceof FieldHeaderComp) {
                FieldHeaderLocation fieldHeaderLocation = sourcePanel.getFieldHeader().getFieldHeaderLocation(event.getPoint());
                return new DefaultActionContext(provider).setContextObject((Object)fieldHeaderLocation);
            }
        }
        return null;
    }

    public Object getContextObjectForMarginPanels(ListingPanel lp, MouseEvent event) {
        Object source = event.getSource();
        List<MarginProvider> marginProviders = lp.getMarginProviders();
        for (MarginProvider marginProvider : marginProviders) {
            JComponent c = marginProvider.getComponent();
            if (c != source) continue;
            MarkerLocation loc = marginProvider.getMarkerLocation(event.getX(), event.getY());
            if (loc != null) {
                return loc;
            }
            return source;
        }
        List<OverviewProvider> overviewProviders = lp.getOverviewProviders();
        for (OverviewProvider overviewProvider : overviewProviders) {
            JComponent c = overviewProvider.getComponent();
            if (c != source) continue;
            return source;
        }
        return null;
    }

    @Override
    public FieldPanel getLeftFieldPanel() {
        return this.getLeftPanel().getFieldPanel();
    }

    @Override
    public FieldPanel getRightFieldPanel() {
        return this.getRightPanel().getFieldPanel();
    }

    @Override
    protected ListingComparisonFieldPanelCoordinator createFieldPanelCoordinator() {
        ListingComparisonFieldPanelCoordinator coordinator = new ListingComparisonFieldPanelCoordinator(this);
        if (this.correlator != null) {
            coordinator.setCorrelation((ListingAddressCorrelation)this.correlator);
        }
        return coordinator;
    }

    public void readConfigState(String prefix, SaveState saveState) {
        this.showSideBySide(saveState.getBoolean(prefix + DUAL_LISTING_SIDE_BY_SIDE, true));
        this.setHeaderShowing(saveState.getBoolean(prefix + DUAL_LISTING_HEADER_SHOWING, false));
    }

    public void writeConfigState(String prefix, SaveState saveState) {
        saveState.putBoolean(prefix + DUAL_LISTING_SIDE_BY_SIDE, this.isSideBySide());
        saveState.putBoolean(prefix + DUAL_LISTING_HEADER_SHOWING, this.isHeaderShowing());
    }

    @Override
    public void setScrollingSyncState(boolean syncScrolling) {
        if (this.isScrollingSynced() == syncScrolling) {
            return;
        }
        FieldPanel currentFieldPanel = this.listingPanels[this.currProgramIndex].getFieldPanel();
        ViewerPosition viewerPosition = currentFieldPanel.getViewerPosition();
        this.saveCoordinatorState();
        super.setScrollingSyncState(syncScrolling);
        if (!this.hasMatchingLocation()) {
            this.restoreCoordinatorState();
        }
        currentFieldPanel.setViewerPosition(viewerPosition.getIndex(), viewerPosition.getXOffset(), viewerPosition.getYOffset());
    }

    private boolean hasMatchingLocation() {
        ProgramLocation cursorLocation = this.listingPanels[this.currProgramIndex].getCursorLocation();
        if (cursorLocation != null) {
            Address address = cursorLocation.getAddress();
            Address otherAddress = this.currProgramIndex == 0 ? this.getRightCorrelatedAddress(address) : this.getLeftCorrelatedAddress(address);
            return otherAddress != null;
        }
        return false;
    }

    private void saveCoordinatorState() {
        ListingComparisonFieldPanelCoordinator fieldPanelCoordinator = (ListingComparisonFieldPanelCoordinator)this.getFieldPanelCoordinator();
        if (fieldPanelCoordinator != null) {
            this.coordinatorLockedAddresses = fieldPanelCoordinator.getLockedAddresses();
        }
    }

    private void restoreCoordinatorState() {
        ListingComparisonFieldPanelCoordinator fieldPanelCoordinator = (ListingComparisonFieldPanelCoordinator)this.getFieldPanelCoordinator();
        if (fieldPanelCoordinator != null && this.coordinatorLockedAddresses != null && this.coordinatorLockedAddresses.length == 2) {
            fieldPanelCoordinator.setLockedAddresses(this.coordinatorLockedAddresses[0], this.coordinatorLockedAddresses[1]);
        }
    }

    private class DualListingMouseListener
    extends MouseAdapter {
        private int leftOrRight;
        private Component leftOrRightComponent;

        DualListingMouseListener(Component leftOrRightComponent, int leftOrRight) {
            this.leftOrRightComponent = leftOrRightComponent;
            this.leftOrRight = leftOrRight;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ListingCodeComparisonPanel.this.setDualPanelFocus(this.leftOrRight);
        }
    }

    private class LeftLocationListener
    implements FieldLocationListener {
        private LeftLocationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fieldLocationChanged(FieldLocation location, Field field, EventTrigger trigger) {
            if (ListingCodeComparisonPanel.this.fieldLocationChanging) {
                return;
            }
            try {
                ListingCodeComparisonPanel.this.fieldLocationChanging = true;
                ProgramLocation leftProgramLocation = ListingCodeComparisonPanel.this.listingPanels[0].getProgramLocation();
                ListingComparisonFieldPanelCoordinator fieldPanelCoordinator = (ListingComparisonFieldPanelCoordinator)ListingCodeComparisonPanel.this.getFieldPanelCoordinator();
                ProgramLocation rightProgramLocation = fieldPanelCoordinator != null ? ListingCodeComparisonPanel.this.getProgramLocation(1, leftProgramLocation) : null;
                ListingCodeComparisonPanel.this.setCursorMarkers(0, leftProgramLocation);
                ListingCodeComparisonPanel.this.setCursorMarkers(1, rightProgramLocation);
                if (rightProgramLocation == null) {
                    ListingCodeComparisonPanel.this.listingPanels[1].getFieldPanel().repaint();
                    return;
                }
                if (fieldPanelCoordinator != null) {
                    fieldPanelCoordinator.leftLocationChanged(leftProgramLocation);
                    ListingCodeComparisonPanel.this.setRightLocation(ListingCodeComparisonPanel.this.getRightProgram(), rightProgramLocation);
                }
            }
            finally {
                ListingCodeComparisonPanel.this.fieldLocationChanging = false;
            }
        }
    }

    private class RightLocationListener
    implements FieldLocationListener {
        private RightLocationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fieldLocationChanged(FieldLocation location, Field field, EventTrigger trigger) {
            if (ListingCodeComparisonPanel.this.fieldLocationChanging) {
                return;
            }
            try {
                ListingCodeComparisonPanel.this.fieldLocationChanging = true;
                ProgramLocation rightProgramLocation = ListingCodeComparisonPanel.this.listingPanels[1].getProgramLocation();
                ListingComparisonFieldPanelCoordinator fieldPanelCoordinator = (ListingComparisonFieldPanelCoordinator)ListingCodeComparisonPanel.this.getFieldPanelCoordinator();
                ProgramLocation leftProgramLocation = fieldPanelCoordinator != null ? ListingCodeComparisonPanel.this.getProgramLocation(0, rightProgramLocation) : null;
                ListingCodeComparisonPanel.this.setCursorMarkers(1, rightProgramLocation);
                ListingCodeComparisonPanel.this.setCursorMarkers(0, leftProgramLocation);
                if (leftProgramLocation == null) {
                    ListingCodeComparisonPanel.this.listingPanels[0].getFieldPanel().repaint();
                    return;
                }
                if (fieldPanelCoordinator != null) {
                    fieldPanelCoordinator.rightLocationChanged(rightProgramLocation);
                    ListingCodeComparisonPanel.this.setLeftLocation(ListingCodeComparisonPanel.this.getLeftProgram(), leftProgramLocation);
                }
            }
            finally {
                ListingCodeComparisonPanel.this.fieldLocationChanging = false;
            }
        }
    }

    class ToggleHeaderAction
    extends ToggleDockingAction {
        ToggleHeaderAction() {
            super("Dual Listing Toggle Header", ListingCodeComparisonPanel.this.owner);
            this.setDescription("Toggle Format Header");
            this.setEnabled(true);
            MenuData menuData = new MenuData(new String[]{"Show Listing Format Header"}, "DualListing");
            this.setMenuBarData(menuData);
            this.setHelpLocation(new HelpLocation(ListingCodeComparisonPanel.DUAL_LISTING_HELP_TOPIC, "Dual Listing Toggle Format Header"));
        }

        public void actionPerformed(ActionContext context) {
            ListingPanel listingPanel = ListingCodeComparisonPanel.this.getLeftPanel();
            boolean show = !listingPanel.isHeaderShowing();
            listingPanel.showHeader(show);
            listingPanel.validate();
            listingPanel.invalidate();
        }
    }

    class ToggleOrientationAction
    extends ToggleDockingAction {
        ToggleOrientationAction() {
            super("Dual Listing Toggle Orientation", ListingCodeComparisonPanel.this.owner);
            this.setDescription("<HTML>Toggle the layout of the listings <BR>between side-by-side and one above the other.</HTML>");
            this.setEnabled(true);
            this.setSelected(ListingCodeComparisonPanel.this.isSideBySide);
            MenuData menuData = new MenuData(new String[]{"Show Listings Side-by-Side"}, "DualListing");
            this.setMenuBarData(menuData);
            this.setHelpLocation(new HelpLocation(ListingCodeComparisonPanel.DUAL_LISTING_HELP_TOPIC, "Dual Listing Toggle Orientation"));
        }

        public void actionPerformed(ActionContext context) {
            boolean sideBySide = !ListingCodeComparisonPanel.this.isSideBySide();
            ListingCodeComparisonPanel.this.showSideBySide(sideBySide);
        }
    }

    class ToggleHoverAction
    extends ToggleDockingAction {
        ToggleHoverAction() {
            super("Dual Listing Toggle Mouse Hover Popups", ListingCodeComparisonPanel.this.owner);
            this.setEnabled(true);
            this.setToolBarData(new ToolBarData(HOVER_ON_ICON, ListingCodeComparisonPanel.HOVER_GROUP));
            this.setSelected(true);
            this.setHelpLocation(new HelpLocation(ListingCodeComparisonPanel.DUAL_LISTING_HELP_TOPIC, "Dual Listing Toggle Mouse Hover Popups"));
            this.setHover(true);
        }

        public boolean isEnabledForContext(ActionContext context) {
            return ListingCodeComparisonPanel.this.isShowing();
        }

        public void actionPerformed(ActionContext context) {
            this.setHover(this.isSelected());
        }

        void setHover(boolean enabled) {
            this.getToolBarData().setIcon(enabled ? HOVER_ON_ICON : HOVER_OFF_ICON);
            ListingCodeComparisonPanel.this.setHoverEnabled(enabled);
        }
    }

    class NextDiffAction
    extends DockingAction {
        NextDiffAction() {
            super("Dual Listing Go To Next Area Marker", ListingCodeComparisonPanel.this.owner);
            this.setEnabled(true);
            this.setKeyBindingData(new KeyBindingData('N', DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x200));
            this.setDescription("Go to the next highlighted area.");
            this.setPopupMenuData(new MenuData(new String[]{"Go To Next Highlighted Area"}, NEXT_DIFF_ICON, ListingCodeComparisonPanel.DIFF_NAVIGATE_GROUP));
            ToolBarData newToolBarData = new ToolBarData(NEXT_DIFF_ICON, ListingCodeComparisonPanel.DIFF_NAVIGATE_GROUP);
            this.setToolBarData(newToolBarData);
            HelpLocation helpLocation = new HelpLocation(ListingCodeComparisonPanel.DUAL_LISTING_HELP_TOPIC, "Dual Listing Go To Next Highlighted Area");
            this.setHelpLocation(helpLocation);
            this.setEnabled(true);
        }

        public boolean isValidContext(ActionContext context) {
            return ListingCodeComparisonPanel.this.isValidPanelContext(context);
        }

        public boolean isEnabledForContext(ActionContext context) {
            return ListingCodeComparisonPanel.this.isShowing() && ListingCodeComparisonPanel.this.listingDiff.hasCorrelation();
        }

        public void actionPerformed(ActionContext context) {
            if (this.isValidContext(context)) {
                ListingCodeComparisonPanel.this.nextAreaDiff(ListingCodeComparisonPanel.this.nextPreviousAreaType, true);
            }
        }

        void setMenuString() {
            String type = ListingCodeComparisonPanel.this.getCurrentAreaMarkerType();
            this.setPopupMenuData(new MenuData(new String[]{"Go To Next " + type + " Area"}, NEXT_DIFF_ICON, ListingCodeComparisonPanel.DIFF_NAVIGATE_GROUP));
            this.setDescription("Go to the next " + type.toLowerCase() + " area.");
        }
    }

    class PreviousDiffAction
    extends DockingAction {
        PreviousDiffAction() {
            super("Dual Listing Go To Previous Area Marker", ListingCodeComparisonPanel.this.owner);
            this.setEnabled(true);
            this.setKeyBindingData(new KeyBindingData('P', DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x200));
            this.setDescription("Go to the previous highlighted area.");
            this.setPopupMenuData(new MenuData(new String[]{"Go To Previous Highlighted Area"}, PREVIOUS_DIFF_ICON, ListingCodeComparisonPanel.DIFF_NAVIGATE_GROUP));
            ToolBarData newToolBarData = new ToolBarData(PREVIOUS_DIFF_ICON, ListingCodeComparisonPanel.DIFF_NAVIGATE_GROUP);
            this.setToolBarData(newToolBarData);
            HelpLocation helpLocation = new HelpLocation(ListingCodeComparisonPanel.DUAL_LISTING_HELP_TOPIC, "Dual Listing Go To Previous Highlighted Area");
            this.setHelpLocation(helpLocation);
            this.setEnabled(true);
        }

        public boolean isValidContext(ActionContext context) {
            return ListingCodeComparisonPanel.this.isValidPanelContext(context);
        }

        public boolean isEnabledForContext(ActionContext context) {
            return ListingCodeComparisonPanel.this.isShowing() && ListingCodeComparisonPanel.this.listingDiff.hasCorrelation();
        }

        public void actionPerformed(ActionContext context) {
            if (this.isValidContext(context)) {
                ListingCodeComparisonPanel.this.nextAreaDiff(ListingCodeComparisonPanel.this.nextPreviousAreaType, false);
            }
        }

        void setMenuString() {
            String type = ListingCodeComparisonPanel.this.getCurrentAreaMarkerType();
            this.setPopupMenuData(new MenuData(new String[]{"Go To Previous " + type + " Area"}, PREVIOUS_DIFF_ICON, ListingCodeComparisonPanel.DIFF_NAVIGATE_GROUP));
            this.setDescription("Go to the previous " + type.toLowerCase() + " area.");
        }
    }

    class ListingCodeComparisonOptionsAction
    extends DockingAction {
        ListingCodeComparisonOptionsAction() {
            super("Listing Code Comparison Options", ListingCodeComparisonPanel.this.owner);
            this.setEnabled(true);
            this.setDescription("Show the tool options for the Listing Code Comparison.");
            this.setPopupMenuData(new MenuData(new String[]{"Properties"}, null, ListingCodeComparisonPanel.PROPERTIES_GROUP));
            this.setHelpLocation(new HelpLocation(ListingCodeComparisonPanel.DUAL_LISTING_HELP_TOPIC, "Listing_Code_Comparison_Options"));
            this.setEnabled(true);
        }

        public boolean isEnabledForContext(ActionContext context) {
            return ListingCodeComparisonPanel.this.isShowing() && ListingCodeComparisonPanel.this.listingDiff.hasCorrelation();
        }

        public boolean isValidContext(ActionContext context) {
            return ListingCodeComparisonPanel.this.isValidPanelContext(context);
        }

        public void actionPerformed(ActionContext context) {
            OptionsService service = (OptionsService)ListingCodeComparisonPanel.this.tool.getService(OptionsService.class);
            service.showOptionsDialog("Listing Code Comparison", "Listing Code Comparison");
        }
    }

    class NextPreviousAreaMarkerAction
    extends MultiStateDockingAction<String> {
        public NextPreviousAreaMarkerAction(String owner) {
            super("Dual Listing Next/Previous Area Marker", owner);
            ToolBarData toolBarData = new ToolBarData(DIFF_ICON, ListingCodeComparisonPanel.DIFF_NAVIGATE_GROUP);
            this.setToolBarData(toolBarData);
            HelpLocation helpLocation = new HelpLocation(ListingCodeComparisonPanel.DUAL_LISTING_HELP_TOPIC, "Dual Listing Next/Previous Area Marker");
            this.setHelpLocation(helpLocation);
            this.setDescription("Set Navigate Next/Previous Area Marker options");
            ActionState allAreaMarkers = new ActionState(ListingCodeComparisonPanel.ALL_AREA_MARKERS, BOTH_VIEWS_ICON, (Object)ListingCodeComparisonPanel.ALL_AREA_MARKERS);
            allAreaMarkers.setHelpLocation(helpLocation);
            ActionState unmatchedAreaMarkers = new ActionState(ListingCodeComparisonPanel.UNMATCHED_AREA_MARKERS, UNMATCHED_ICON, (Object)ListingCodeComparisonPanel.UNMATCHED_AREA_MARKERS);
            unmatchedAreaMarkers.setHelpLocation(helpLocation);
            ActionState diffAreaMarkers = new ActionState(ListingCodeComparisonPanel.DIFF_AREA_MARKERS, DIFF_ICON, (Object)ListingCodeComparisonPanel.DIFF_AREA_MARKERS);
            diffAreaMarkers.setHelpLocation(helpLocation);
            this.addActionState(allAreaMarkers);
            this.addActionState(unmatchedAreaMarkers);
            this.addActionState(diffAreaMarkers);
            this.setCurrentActionState(allAreaMarkers);
            this.adjustNextPreviousAreaType();
        }

        private void adjustNextPreviousAreaType() {
            ListingCodeComparisonPanel.this.nextPreviousAreaType = (String)this.getCurrentUserData();
            ListingCodeComparisonPanel.this.nextDiffAction.setMenuString();
            ListingCodeComparisonPanel.this.previousDiffAction.setMenuString();
        }

        public boolean isEnabledForContext(ActionContext context) {
            return ListingCodeComparisonPanel.this.isShowing() && ListingCodeComparisonPanel.this.listingDiff.hasCorrelation();
        }

        public void actionStateChanged(ActionState<String> newActionState, EventTrigger trigger) {
            this.adjustNextPreviousAreaType();
        }

        public void refresh() {
            this.actionStateChanged((ActionState<String>)this.getCurrentState(), null);
        }
    }

    private class DualListingMarkerManager
    extends MarkerManager {
        private DualListingServiceProvider serviceProvider;

        private DualListingMarkerManager(String Owner, PluginTool tool, DualListingServiceProvider serviceProvider) {
            super(ListingCodeComparisonPanel.this.owner, tool);
            this.serviceProvider = serviceProvider;
        }

        @Override
        public GoToService getGoToService() {
            return this.serviceProvider.getService(GoToService.class);
        }
    }

    private class MarkerChangeListener
    implements ChangeListener {
        private int leftOrRight;

        private MarkerChangeListener(int leftOrRight) {
            this.leftOrRight = leftOrRight;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ListingCodeComparisonPanel.this.listingPanels[this.leftOrRight].getFieldPanel().repaint();
        }
    }
}

