/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.widgets.tree.GTreeNode;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class FSBFileNode
extends FSBNode {
    protected GFile file;
    protected boolean isEncrypted;
    protected boolean hasPassword;

    FSBFileNode(GFile file) {
        this.file = file;
    }

    @Override
    public FSRL getFSRL() {
        return this.file.getFSRL();
    }

    public boolean isLeaf() {
        return true;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    protected void updateFileAttributes(TaskMonitor monitor) {
        FileAttributes fattrs = this.file.getFilesystem().getFileAttributes(this.file, monitor);
        this.isEncrypted = fattrs.get(FileAttributeType.IS_ENCRYPTED_ATTR, Boolean.class, false);
        this.hasPassword = fattrs.get(FileAttributeType.HAS_GOOD_PASSWORD_ATTR, Boolean.class, false);
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        return List.of();
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public boolean hasPassword() {
        return this.hasPassword;
    }

    public boolean hasMissingPassword() {
        return this.isEncrypted && !this.hasPassword;
    }

    public boolean needsFileAttributesUpdate(TaskMonitor monitor) {
        if (this.hasMissingPassword()) {
            this.updateFileAttributes(monitor);
            return this.hasPassword;
        }
        return false;
    }
}

