/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.OffsetReference;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.ShiftedReference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.StackReference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.AddressTranslator;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.SimpleDiffUtility;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class DiffUtility
extends SimpleDiffUtility {
    public static Address getCompatibleMemoryAddress(Address memoryAddress, Program otherProgram) {
        if (memoryAddress != null && memoryAddress.isMemoryAddress()) {
            return DiffUtility.translateMemoryAddress((Address)memoryAddress, (Program)otherProgram, (boolean)true);
        }
        return null;
    }

    public static AddressSet getCompatibleAddressSet(AddressSetView set, Program otherProgram) {
        AddressSet otherSet = new AddressSet();
        AddressRangeIterator rangeIter = set.getAddressRanges();
        while (rangeIter.hasNext()) {
            AddressRange range = (AddressRange)rangeIter.next();
            AddressRange compatibleAddressRange = DiffUtility.getCompatibleAddressRange(range, otherProgram);
            if (compatibleAddressRange == null) continue;
            otherSet.add(compatibleAddressRange);
        }
        return otherSet;
    }

    public static AddressSet getNonCompatibleAddressSet(AddressSetView set, Program otherProgram) {
        AddressSet nonCompatibleSet = new AddressSet();
        AddressRangeIterator rangeIter = set.getAddressRanges();
        while (rangeIter.hasNext()) {
            AddressRange range = (AddressRange)rangeIter.next();
            AddressRange compatibleAddressRange = DiffUtility.getCompatibleAddressRange(range, otherProgram);
            if (compatibleAddressRange != null) continue;
            nonCompatibleSet.add(range);
        }
        return nonCompatibleSet;
    }

    public static AddressRange getCompatibleAddressRange(AddressRange range, Program otherProgram) {
        Address nextMin = range.getMinAddress();
        Address nextMax = range.getMaxAddress();
        Address newMinAddress = DiffUtility.translateMemoryAddress((Address)nextMin, (Program)otherProgram, (boolean)false);
        Address newMaxAddress = DiffUtility.translateMemoryAddress((Address)nextMax, (Program)otherProgram, (boolean)true);
        try {
            int compareMaxToMin;
            while (newMaxAddress == null && nextMin != null && (compareMaxToMin = (nextMax = nextMax.subtract(1L)).compareTo((Object)nextMin)) >= 0) {
                newMaxAddress = DiffUtility.translateMemoryAddress((Address)nextMax, (Program)otherProgram, (boolean)true);
                if (compareMaxToMin != 0) continue;
                break;
            }
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            // empty catch block
        }
        if (newMinAddress == null || newMaxAddress == null || newMinAddress.getOffset() > newMaxAddress.getOffset()) {
            return null;
        }
        return new AddressRangeImpl(newMinAddress, newMaxAddress);
    }

    public static int compare(Program program1, Address addr1, Program program2, Address addr2) {
        Address translatedAddr = DiffUtility.getCompatibleAddress((Program)program1, (Address)addr1, (Program)program2);
        if (translatedAddr != null) {
            if (addr2 != null) {
                return translatedAddr.compareTo((Object)addr2);
            }
            return 1;
        }
        if (addr2 == null) {
            return 0;
        }
        return -1;
    }

    public static Namespace getNamespace(Namespace namespace, Program otherProgram) {
        Symbol s = DiffUtility.getSymbol((Symbol)namespace.getSymbol(), (Program)otherProgram);
        return s != null ? (Namespace)s.getObject() : null;
    }

    public static Namespace createNamespace(Program program, Namespace namespace, Program otherProgram) throws InvalidInputException, DuplicateNameException {
        if (namespace == null) {
            return otherProgram.getGlobalNamespace();
        }
        Symbol otherNamespaceSymbol = DiffUtility.getSymbol((Symbol)namespace.getSymbol(), (Program)otherProgram);
        if (otherNamespaceSymbol != null) {
            return (Namespace)otherNamespaceSymbol.getObject();
        }
        Namespace parentNamespace = namespace.getParentNamespace();
        Namespace otherParentNamespace = DiffUtility.createNamespace(program, parentNamespace, otherProgram);
        SourceType source = namespace.getSymbol().getSource();
        if (namespace instanceof Library) {
            return otherProgram.getSymbolTable().createExternalLibrary(namespace.getName(), source);
        }
        if (namespace instanceof GhidraClass) {
            return otherProgram.getSymbolTable().createClass(otherParentNamespace, namespace.getName(), source);
        }
        return otherProgram.getSymbolTable().createNameSpace(otherParentNamespace, namespace.getName(), source);
    }

    public static boolean variableStorageOverlaps(Variable var1, Variable var2) {
        Program program1 = var1.getFunction().getProgram();
        Program program2 = var2.getFunction().getProgram();
        VariableStorage storage = DiffUtility.getCompatibleVariableStorage((Program)program1, (VariableStorage)var1.getVariableStorage(), (Program)program2);
        if (storage == null || storage.isBadStorage()) {
            return false;
        }
        return storage.intersects(var2.getVariableStorage());
    }

    public static boolean variableStorageMatches(Variable var1, Variable var2) {
        Program program1 = var1.getFunction().getProgram();
        Program program2 = var2.getFunction().getProgram();
        VariableStorage storage = DiffUtility.getCompatibleVariableStorage((Program)program1, (VariableStorage)var1.getVariableStorage(), (Program)program2);
        if (storage == null || storage.isBadStorage()) {
            return false;
        }
        return storage.equals((Object)var2.getVariableStorage());
    }

    public static Function getFunction(Function function, Program otherProgram) {
        return (Function)DiffUtility.getNamespace((Namespace)function, otherProgram);
    }

    public static Reference getReference(Program program, Reference ref, Program otherProgram) {
        Address fromAddr = DiffUtility.getCompatibleAddress((Program)program, (Address)ref.getFromAddress(), (Program)otherProgram);
        if (fromAddr == null) {
            return null;
        }
        if (ref.isMemoryReference()) {
            Address toAddr = DiffUtility.getCompatibleAddress((Program)program, (Address)ref.getToAddress(), (Program)otherProgram);
            if (toAddr == null) {
                return null;
            }
            return otherProgram.getReferenceManager().getReference(fromAddr, toAddr, ref.getOperandIndex());
        }
        Reference otherRef = otherProgram.getReferenceManager().getPrimaryReferenceFrom(fromAddr, ref.getOperandIndex());
        if (otherRef != null && ref.getToAddress().hasSameAddressSpace(otherRef.getToAddress())) {
            return otherRef;
        }
        return null;
    }

    public static Reference getReference(AddressTranslator p2ToP1Translator, Reference p2Ref) {
        Program program = p2ToP1Translator.getDestinationProgram();
        Address fromAddr1 = p2ToP1Translator.getAddress(p2Ref.getFromAddress());
        if (fromAddr1 == null) {
            return null;
        }
        if (p2Ref.isMemoryReference()) {
            Address toAddr1 = p2ToP1Translator.getAddress(p2Ref.getToAddress());
            if (toAddr1 == null) {
                return null;
            }
            return program.getReferenceManager().getReference(fromAddr1, toAddr1, p2Ref.getOperandIndex());
        }
        Reference p1Ref = program.getReferenceManager().getPrimaryReferenceFrom(fromAddr1, p2Ref.getOperandIndex());
        if (p1Ref != null && p1Ref.getToAddress().hasSameAddressSpace(p2Ref.getToAddress())) {
            return p1Ref;
        }
        return null;
    }

    public static ExternalLocation createExtLocation(Program program, ExternalLocation extLoc, Program otherProgram) throws InvalidInputException, DuplicateNameException {
        Address addr = extLoc.getAddress();
        Address otherAddr = null;
        if (addr != null) {
            otherAddr = DiffUtility.getCompatibleAddress((Program)program, (Address)addr, (Program)otherProgram);
        }
        return otherProgram.getExternalManager().addExtLocation(extLoc.getLibraryName(), extLoc.getLabel(), otherAddr, extLoc.getSource());
    }

    public static Reference createReference(Program program, Reference ref, Program otherProgram) {
        Symbol s;
        Reference newRef;
        ReferenceManager otherRefMgr = otherProgram.getReferenceManager();
        if (ref.isExternalReference()) {
            Address extAddr = ref.getToAddress();
            Symbol s2 = program.getSymbolTable().getPrimarySymbol(extAddr);
            if (s2 == null || !s2.isExternal()) {
                return null;
            }
            try {
                ExternalLocation extLoc = program.getExternalManager().getExternalLocation(s2);
                Symbol otherExtSym = DiffUtility.getSymbol((Symbol)s2, (Program)otherProgram);
                ExternalLocation otherExtLoc = otherExtSym == null ? DiffUtility.createExtLocation(program, extLoc, otherProgram) : otherProgram.getExternalManager().getExternalLocation(otherExtSym);
                return otherRefMgr.addExternalReference(ref.getFromAddress(), ref.getOperandIndex(), otherExtLoc, ref.getSource(), ref.getReferenceType());
            }
            catch (DuplicateNameException e) {
                return null;
            }
            catch (InvalidInputException e) {
                throw new AssertException((Throwable)e);
            }
        }
        Address otherFromAddress = DiffUtility.getCompatibleAddress((Program)program, (Address)ref.getFromAddress(), (Program)otherProgram);
        if (otherFromAddress == null) {
            return null;
        }
        Address otherToAddress = DiffUtility.getCompatibleAddress((Program)program, (Address)ref.getToAddress(), (Program)otherProgram);
        if (otherToAddress == null && !ref.isStackReference()) {
            return null;
        }
        if (ref.isOffsetReference()) {
            OffsetReference offRef = (OffsetReference)ref;
            newRef = otherRefMgr.addOffsetMemReference(otherFromAddress, offRef.getBaseAddress(), true, offRef.getOffset(), ref.getReferenceType(), ref.getSource(), ref.getOperandIndex());
        } else if (ref.isShiftedReference()) {
            newRef = otherRefMgr.addShiftedMemReference(otherFromAddress, otherToAddress, ((ShiftedReference)ref).getShift(), ref.getReferenceType(), ref.getSource(), ref.getOperandIndex());
        } else {
            if (ref.isStackReference()) {
                StackReference stackRef = (StackReference)ref;
                if (otherProgram.getFunctionManager().isInFunction(otherFromAddress)) {
                    return otherRefMgr.addStackReference(otherFromAddress, ref.getOperandIndex(), stackRef.getStackOffset(), ref.getReferenceType(), ref.getSource());
                }
                return null;
            }
            if (ref.isMemoryReference() || ref.isRegisterReference()) {
                newRef = otherRefMgr.addMemoryReference(otherFromAddress, otherToAddress, ref.getReferenceType(), ref.getSource(), ref.getOperandIndex());
            } else {
                return null;
            }
        }
        long symId = ref.getSymbolID();
        if (symId > 0L && (s = program.getSymbolTable().getSymbol(symId)) != null && (s = DiffUtility.getSymbol((Symbol)s, (Program)otherProgram)) != null) {
            otherRefMgr.setAssociation(s, ref);
            newRef = otherRefMgr.getReference(newRef.getFromAddress(), newRef.getToAddress(), newRef.getOperandIndex());
        }
        if (ref.isPrimary() != newRef.isPrimary()) {
            otherRefMgr.setPrimary(newRef, ref.isPrimary());
        }
        return newRef;
    }

    public static Variable getVariable(Program program, Variable var, Program otherProgram) {
        Symbol s = DiffUtility.getSymbol((Symbol)var.getSymbol(), (Program)otherProgram);
        return s != null ? (Variable)s.getObject() : null;
    }

    public static Variable getVariable(Variable var, Function otherFunction) {
        Symbol s = DiffUtility.getVariableSymbol((Symbol)var.getSymbol(), (Function)otherFunction);
        return s != null ? (Variable)s.getObject() : null;
    }

    public static Variable createVariable(Program program, Variable var, Program otherProgram) throws DuplicateNameException, InvalidInputException {
        Symbol parent = var.getSymbol().getParentSymbol();
        SourceType source = var.getSource();
        if ((parent = DiffUtility.getSymbol((Symbol)parent, (Program)otherProgram)) == null) {
            return null;
        }
        Namespace namespace = (Namespace)parent.getObject();
        if (namespace instanceof Function) {
            Function func = (Function)namespace;
            if (var instanceof Parameter) {
                return func.insertParameter(((Parameter)var).getOrdinal(), var, source);
            }
            return func.addLocalVariable(var, source);
        }
        return null;
    }

    public static AddressSet getCodeUnitSet(AddressSetView addrSet, Program program) {
        Listing listing = program.getListing();
        AddressSet addrs = new AddressSet(addrSet);
        AddressRangeIterator iter = addrSet.getAddressRanges();
        while (iter.hasNext()) {
            Address maxCuMaxAddr;
            CodeUnit maxCu;
            Address minCuMinAddr;
            AddressRange range = (AddressRange)iter.next();
            Address rangeMin = range.getMinAddress();
            Address rangeMax = range.getMaxAddress();
            CodeUnit minCu = listing.getCodeUnitContaining(rangeMin);
            if (minCu != null && (minCuMinAddr = minCu.getMinAddress()).compareTo((Object)rangeMin) != 0) {
                addrs.addRange(minCuMinAddr, DiffUtility.getMaxAddress(minCu));
            }
            if ((maxCu = listing.getCodeUnitContaining(rangeMax)) == null || (maxCuMaxAddr = DiffUtility.getMaxAddress(maxCu)).compareTo((Object)rangeMax) == 0) continue;
            addrs.addRange(maxCu.getMinAddress(), maxCuMaxAddr);
        }
        return addrs;
    }

    private static Address getMaxAddress(CodeUnit cu) {
        Instruction inst;
        if (cu instanceof Instruction && (inst = (Instruction)cu).isLengthOverridden()) {
            return cu.getMinAddress().add((long)(inst.getParsedLength() - 1));
        }
        return cu.getMaxAddress();
    }

    public static String toSignedHexString(int value) {
        return value >= 0 ? "0x" + Integer.toHexString(value) : "-0x" + Integer.toHexString(-value);
    }

    public static String toSignedHexString(long value) {
        return value >= 0L ? "0x" + Long.toHexString(value) : "-0x" + Long.toHexString(-value);
    }

    public static String getUserToAddressString(Program program, Reference ref) {
        Address toAddr = ref.getToAddress();
        if (ref.isExternalReference()) {
            ExternalLocation extLoc = ((ExternalReference)ref).getExternalLocation();
            Address extAddr = extLoc.getAddress();
            String extLabel = extLoc.getLabel();
            return extLoc.getLibraryName() + "::" + (extLabel != null ? extLabel : "") + (String)(extAddr != null ? " (" + extAddr + ")" : "");
        }
        if (ref.isStackReference()) {
            int offset = ((StackReference)ref).getStackOffset();
            return "Stack[" + DiffUtility.toSignedHexString(offset) + "]";
        }
        if (ref.isOffsetReference()) {
            OffsetReference oref = (OffsetReference)ref;
            return toAddr.toString() + " base:" + DiffUtility.getUserToAddressString(program, oref.getBaseAddress()) + " offset:" + DiffUtility.toSignedHexString(oref.getOffset());
        }
        if (ref.isShiftedReference()) {
            ShiftedReference sref = (ShiftedReference)ref;
            return toAddr.toString() + " value:" + sref.getValue() + " <<" + sref.getShift();
        }
        Register reg = program.getRegister(toAddr);
        if (reg != null) {
            return "register: " + reg.getName();
        }
        return toAddr.toString();
    }

    public static String getUserToAddressString(Program program, Address address) {
        if (address == null) {
            return "";
        }
        if (address.isVariableAddress()) {
            // empty if block
        }
        if (address.isRegisterAddress()) {
            Register reg = program.getRegister(address);
            if (reg != null) {
                return "register:" + reg.getName();
            }
        } else if (address.isStackAddress()) {
            return "stack:" + DiffUtility.toSignedHexString(address.getOffset());
        }
        return address.toString();
    }

    public static String getUserToSymbolString(Program program, Reference ref) {
        if (ref.isExternalReference()) {
            ExternalLocation extLoc = ((ExternalReference)ref).getExternalLocation();
            return extLoc.getLibraryName() + "::" + extLoc.getLabel();
        }
        long id = ref.getSymbolID();
        Symbol s = id >= 0L ? program.getSymbolTable().getSymbol(id) : null;
        return s != null ? s.getName() : "";
    }

    public static ProgramLocation getCompatibleProgramLocation(Program program, ProgramLocation location, Program otherProgram) {
        Address address = DiffUtility.getCompatibleAddress((Program)program, (Address)location.addr, (Program)otherProgram);
        Address byteAddress = DiffUtility.getCompatibleAddress((Program)program, (Address)location.getByteAddress(), (Program)otherProgram);
        Address refAddress = DiffUtility.getCompatibleAddress((Program)program, (Address)location.refAddr, (Program)otherProgram);
        if (address != null) {
            if (byteAddress == null) {
                byteAddress = address;
            }
            ProgramLocation otherLocation = new ProgramLocation(otherProgram, address, byteAddress, location.getComponentPath(), refAddress, 0, 0, 0);
            return otherLocation;
        }
        return null;
    }
}

