/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import db.Transaction;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.Loaded;
import ghidra.framework.options.Options;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class ExternalSymbolResolver {
    private static final String REQUIRED_LIBRARY_PROPERTY_PREFIX = "Required Library [";

    public static String getRequiredLibraryProperty(int libraryIndex) {
        return String.format("%s %s]", REQUIRED_LIBRARY_PROPERTY_PREFIX, StringUtilities.pad((String)("" + libraryIndex), (char)' ', (int)4));
    }

    public static void fixUnresolvedExternalSymbols(List<Loaded<Program>> loadedPrograms, boolean fixAll, MessageLog messageLog, TaskMonitor monitor) throws CancelledException, IOException {
        Map<String, Loaded> loadedByPath = loadedPrograms.stream().collect(Collectors.toMap(loaded -> loaded.getProjectFolderPath() + loaded.getName(), loaded -> loaded));
        List<Loaded<Program>> fixupList = loadedPrograms.subList(0, fixAll ? loadedPrograms.size() : 1);
        monitor.initialize((long)fixupList.size());
        for (Loaded<Program> loadedProgram : fixupList) {
            List<Library> libSearchList;
            Program program = loadedProgram.getDomainObject();
            Collection<Long> unresolvedExternalFunctionIds = ExternalSymbolResolver.getUnresolvedExternalFunctionIds(program);
            if (unresolvedExternalFunctionIds.size() == 0 || (libSearchList = ExternalSymbolResolver.getLibrarySearchList(program)).isEmpty()) continue;
            Transaction tx = program.openTransaction("Resolve External Symbols");
            try {
                messageLog.appendMsg("----- [" + program.getName() + "] Resolve " + unresolvedExternalFunctionIds.size() + " external symbols -----");
                for (Library extLibrary : libSearchList) {
                    monitor.checkCancelled();
                    String libName = extLibrary.getName();
                    String libPath = extLibrary.getAssociatedProgramPath();
                    if (libPath == null) continue;
                    Loaded loadedLib = loadedByPath.get(libPath);
                    if (loadedLib == null) {
                        messageLog.appendMsg("Referenced external program not found: " + libName);
                        continue;
                    }
                    Program libProgram = (Program)loadedLib.getDomainObject();
                    monitor.setMessage("Resolving symbols published by library " + libName);
                    ExternalSymbolResolver.resolveSymbolsToLibrary(program, unresolvedExternalFunctionIds, extLibrary, libProgram, messageLog, monitor);
                }
                messageLog.appendMsg("Unresolved external symbols which remain: " + unresolvedExternalFunctionIds.size());
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
    }

    private static void resolveSymbolsToLibrary(Program program, Collection<Long> unresolvedExternalFunctionIds, Library extLibrary, Program libProgram, MessageLog messageLog, TaskMonitor monitor) throws CancelledException {
        int libResolvedCount = 0;
        ExternalManager externalManager = program.getExternalManager();
        SymbolTable symbolTable = program.getSymbolTable();
        Iterator<Long> idIterator = unresolvedExternalFunctionIds.iterator();
        while (idIterator.hasNext()) {
            monitor.checkCancelled();
            Symbol s = symbolTable.getSymbol(idIterator.next().longValue());
            if (s == null || !s.isExternal() || s.getSymbolType() != SymbolType.FUNCTION) {
                Msg.error(ExternalSymbolResolver.class, (Object)"Concurrent modification of symbol table while resolving external symbols");
                idIterator.remove();
                continue;
            }
            ExternalLocation extLoc = externalManager.getExternalLocation(s);
            if (s.getSource() == SourceType.DEFAULT || !ExternalSymbolResolver.isLocationContainedInLibrary(libProgram, extLoc)) continue;
            try {
                s.setNamespace((Namespace)extLibrary);
                idIterator.remove();
                ++libResolvedCount;
                Msg.debug(ExternalSymbolResolver.class, (Object)("External symbol " + extLoc.getLabel() + " resolved to " + extLibrary.getName()));
            }
            catch (CircularDependencyException | DuplicateNameException | InvalidInputException e) {
                Msg.error(ExternalSymbolResolver.class, (Object)("Error setting external symbol namespace for " + extLoc.getLabel()), (Throwable)e);
            }
        }
        messageLog.appendMsg("Resolved " + libResolvedCount + " symbols to library " + extLibrary.getName());
    }

    private static boolean isLocationContainedInLibrary(Program libProgram, ExternalLocation extLoc) {
        String name = extLoc.getOriginalImportedName();
        if (name == null) {
            name = extLoc.getLabel();
        }
        for (Symbol s : libProgram.getSymbolTable().getLabelOrFunctionSymbols(name, null)) {
            if (!s.isExternalEntryPoint()) continue;
            return true;
        }
        return false;
    }

    private static Collection<Long> getUnresolvedExternalFunctionIds(Program program) {
        ArrayList<Long> symbolIds = new ArrayList<Long>();
        ExternalManager externalManager = program.getExternalManager();
        Library library = externalManager.getExternalLibrary("<EXTERNAL>");
        if (library != null) {
            for (Symbol s : program.getSymbolTable().getSymbols((Namespace)library)) {
                if (s.getSymbolType() != SymbolType.FUNCTION) continue;
                symbolIds.add(s.getID());
            }
        }
        return symbolIds;
    }

    private static Collection<String> getOrderedLibraryNamesNeeded(Program program) {
        TreeMap<Integer, String> orderLibraryMap = new TreeMap<Integer, String>();
        Options options = program.getOptions("Program Information");
        for (String optionName : options.getOptionNames()) {
            String libName;
            int prefixIndex = optionName.indexOf(REQUIRED_LIBRARY_PROPERTY_PREFIX);
            if (prefixIndex == -1 || !optionName.endsWith("]") || (libName = options.getString(optionName, null)) == null) continue;
            String indexStr = optionName.substring(prefixIndex + REQUIRED_LIBRARY_PROPERTY_PREFIX.length(), optionName.length() - 1).trim();
            try {
                orderLibraryMap.put(Integer.parseInt(indexStr), libName.trim());
            }
            catch (NumberFormatException e) {
                Msg.error(ExternalSymbolResolver.class, (Object)("Program contains invalid property: " + optionName));
            }
        }
        return orderLibraryMap.values();
    }

    public static List<Library> getLibrarySearchList(Program program) {
        ArrayList<Library> result = new ArrayList<Library>();
        ExternalManager externalManager = program.getExternalManager();
        for (String libName : ExternalSymbolResolver.getOrderedLibraryNamesNeeded(program)) {
            Library lib = externalManager.getExternalLibrary(libName);
            if (lib == null) continue;
            result.add(lib);
        }
        return result;
    }
}

