/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.util.Msg;

public class ProgramMergeFilter {
    public static final int INVALID = -1;
    public static final int IGNORE = 0;
    public static final int REPLACE = 1;
    public static final int MERGE = 2;
    private static final int MERGE_PROGRAM_CONTEXT = 0;
    public static final int PROGRAM_CONTEXT = 1;
    private static final int MERGE_BYTES = 1;
    public static final int BYTES = 2;
    private static final int MERGE_INSTRUCTIONS = 2;
    public static final int INSTRUCTIONS = 4;
    private static final int MERGE_DATA = 3;
    public static final int DATA = 8;
    private static final int MERGE_REFS = 4;
    public static final int REFERENCES = 16;
    private static final int MERGE_PLATE_COMMENTS = 5;
    public static final int PLATE_COMMENTS = 32;
    private static final int MERGE_PRE_COMMENTS = 6;
    public static final int PRE_COMMENTS = 64;
    private static final int MERGE_EOL_COMMENTS = 7;
    public static final int EOL_COMMENTS = 128;
    private static final int MERGE_REPEATABLE_COMMENTS = 8;
    public static final int REPEATABLE_COMMENTS = 256;
    private static final int MERGE_POST_COMMENTS = 9;
    public static final int POST_COMMENTS = 512;
    private static final int MERGE_SYMBOLS = 10;
    public static final int SYMBOLS = 1024;
    private static final int MERGE_BOOKMARKS = 11;
    public static final int BOOKMARKS = 2048;
    private static final int MERGE_PROPERTIES = 12;
    public static final int PROPERTIES = 4096;
    private static final int MERGE_FUNCTIONS = 13;
    public static final int FUNCTIONS = 8192;
    private static final int MERGE_EQUATES = 14;
    public static final int EQUATES = 16384;
    private static final int MERGE_PRIMARY_SYMBOL = 15;
    public static final int PRIMARY_SYMBOL = 32768;
    private static final int MERGE_FUNCTION_TAGS = 16;
    public static final int FUNCTION_TAGS = 65536;
    private static final int NUM_PRIMARY_TYPES = 17;
    public static final int CODE_UNITS = 12;
    public static final int COMMENTS = 992;
    public static final int ALL = 131071;
    private int[] filterFlags = new int[17];

    public ProgramMergeFilter() {
    }

    public ProgramMergeFilter(ProgramMergeFilter filter) {
        int length = filter.filterFlags.length;
        this.filterFlags = new int[length];
        System.arraycopy(filter.filterFlags, 0, this.filterFlags, 0, length);
    }

    public ProgramMergeFilter(int type, int filter) {
        this.setFilter(type, filter);
    }

    public int getFilter(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: 
            case 1024: 
            case 2048: 
            case 4096: 
            case 8192: 
            case 16384: 
            case 32768: 
            case 65536: {
                int tmpType = type;
                for (int bitPos = 0; bitPos < 17; ++bitPos) {
                    if ((tmpType & 1) == 1) {
                        return this.filterFlags[bitPos];
                    }
                    tmpType >>= 1;
                }
                return -1;
            }
        }
        return -1;
    }

    public boolean validatePredefinedType(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: 
            case 992: 
            case 1024: 
            case 2048: 
            case 4096: 
            case 8192: 
            case 16384: 
            case 32768: 
            case 65536: 
            case 131071: {
                return true;
            }
        }
        return false;
    }

    public boolean isSet() {
        int num = this.filterFlags.length;
        for (int i = 0; i < num; ++i) {
            if (this.filterFlags[i] == 0) continue;
            return true;
        }
        return false;
    }

    private boolean validateType(int type) {
        return type >= 0 && (double)type < Math.pow(2.0, 17.0);
    }

    private boolean validateFilter(int filter) {
        if (filter < 0 || filter > 2) {
            Msg.error((Object)this, (Object)("setFilter: Invalid filter: " + filter));
            return false;
        }
        return true;
    }

    private boolean isMergeValidForFilter(int type) throws IllegalArgumentException {
        switch (type) {
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: 
            case 1024: 
            case 65536: {
                return true;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 2048: 
            case 4096: 
            case 8192: 
            case 16384: 
            case 32768: {
                return false;
            }
        }
        throw new IllegalArgumentException("Parameter to method isBothFilterValid() must be an individual merge type.");
    }

    public synchronized void setFilter(int type, int filter) {
        if (!this.validateType(type)) {
            Msg.error((Object)this, (Object)"setFilter: Invalid type.");
            return;
        }
        if (!this.validateFilter(filter)) {
            Msg.error((Object)this, (Object)"setFilter: Invalid filter.");
            return;
        }
        int[] types = ProgramMergeFilter.getPrimaryTypes();
        for (int i = 0; i < types.length; ++i) {
            if ((type & types[i]) == 0) continue;
            int tmpFilter = filter;
            if (filter == 2 && !this.isMergeValidForFilter(types[i])) {
                tmpFilter = 1;
            }
            this.filterFlags[i] = tmpFilter;
        }
    }

    public String toString() {
        int[] types;
        StringBuffer buf = new StringBuffer();
        buf.append("ProgramMergeFilter:\n");
        for (int type : types = ProgramMergeFilter.getPrimaryTypes()) {
            int filter = this.getFilter(type);
            String s = "  " + ProgramMergeFilter.typeToName(type) + "=" + ProgramMergeFilter.filterToName(filter) + "\n";
            buf.append(s);
        }
        return buf.toString();
    }

    public static int[] getPrimaryTypes() {
        int[] pt = new int[17];
        for (int i = 0; i < 17; ++i) {
            pt[i] = 1 << i;
        }
        return pt;
    }

    public static String typeToName(int type) {
        switch (type) {
            case 1: {
                return "PROGRAM CONTEXT";
            }
            case 2: {
                return "BYTES";
            }
            case 4: {
                return "INSTRUCTIONS";
            }
            case 8: {
                return "DATA";
            }
            case 16: {
                return "REFERENCES";
            }
            case 32: {
                return "PLATE_COMMENTS";
            }
            case 64: {
                return "PRE_COMMENTS";
            }
            case 128: {
                return "EOL_COMMENTS";
            }
            case 256: {
                return "REPEATABLE_COMMENTS";
            }
            case 512: {
                return "POST_COMMENTS";
            }
            case 1024: {
                return "SYMBOLS";
            }
            case 32768: {
                return "PRIMARY_SYMBOL";
            }
            case 2048: {
                return "BOOKMARKS";
            }
            case 4096: {
                return "PROPERTIES";
            }
            case 8192: {
                return "FUNCTIONS";
            }
            case 65536: {
                return "FUNCTION TAGS";
            }
            case 16384: {
                return "EQUATES";
            }
            case 12: {
                return "CODE_UNITS";
            }
            case 992: {
                return "COMMENTS";
            }
            case 131071: {
                return "ALL";
            }
        }
        return "";
    }

    public static String filterToName(int type) {
        switch (type) {
            case 0: {
                return "IGNORE";
            }
            case 1: {
                return "REPLACE";
            }
            case 2: {
                return "MERGE";
            }
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProgramMergeFilter) {
            ProgramMergeFilter otherFilter = (ProgramMergeFilter)obj;
            for (int type = 0; type < 17; ++type) {
                if (this.filterFlags[type] == otherFilter.filterFlags[type]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

