/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.EndianSettingsDefinition;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.BytesFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.StringFormat;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.ByteCountSettingsDefinition;
import ghidra.util.table.field.MemoryOffsetSettingsDefinition;
import ghidra.util.table.field.ProgramLocationTableColumnExtensionPoint;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class BytesTableColumn
extends ProgramLocationTableColumnExtensionPoint<Address, Byte[]> {
    private static final ByteCountSettingsDefinition BYTE_COUNT = ByteCountSettingsDefinition.DEF;
    private static final MemoryOffsetSettingsDefinition MEMORY_OFFSET = MemoryOffsetSettingsDefinition.DEF;
    private static final EndianSettingsDefinition ENDIANESS = EndianSettingsDefinition.DEF;
    private static final FormatSettingsDefinition FORMAT = FormatSettingsDefinition.DEF;
    private static SettingsDefinition[] SETTINGS_DEFS = new SettingsDefinition[]{BYTE_COUNT, MEMORY_OFFSET, ENDIANESS, FORMAT};
    private final GColumnRenderer<Byte[]> monospacedRenderer = new AbstractGColumnRenderer<Byte[]>(){

        protected void configureFont(JTable table, TableModel model, int column) {
            this.setFont(this.getFixedWidthFont());
        }

        private String formatBytes(Byte[] bytes, Settings settings) {
            int format;
            boolean bigEndian = ENDIANESS.getChoice(settings) != 1;
            int startIx = 0;
            int endIx = bytes.length;
            int inc = 1;
            if (!bigEndian) {
                startIx = bytes.length - 1;
                endIx = -1;
                inc = -1;
            }
            if ((format = FORMAT.getChoice(settings)) == 4) {
                return this.bytesToString(bytes);
            }
            StringBuilder buffer = new StringBuilder();
            for (int i = startIx; i != endIx; i += inc) {
                if (buffer.length() != 0) {
                    buffer.append(' ');
                }
                buffer.append(this.getByteString(bytes[i], format));
            }
            return buffer.toString();
        }

        private String bytesToString(Byte[] bytes) {
            StringBuilder buf = new StringBuilder();
            Byte[] byteArray = bytes;
            int n = byteArray.length;
            for (int i = 0; i < n; ++i) {
                byte b = byteArray[i];
                char c = (char)(b & 0xFF);
                if (c > ' ' && c < '\u0080') {
                    buf.append((char)(b & 0xFF));
                    continue;
                }
                buf.append('.');
            }
            return buf.toString();
        }

        private String getByteString(Byte b, int format) {
            String val;
            switch (format) {
                case 1: {
                    val = Integer.toString(b.byteValue());
                    break;
                }
                case 2: {
                    val = Integer.toBinaryString(b & 0xFF);
                    val = StringFormat.padIt((String)val, (int)8, (char)'\u0000', (boolean)true);
                    break;
                }
                case 3: {
                    val = Integer.toOctalString(b & 0xFF);
                    val = StringFormat.padIt((String)val, (int)3, (char)'\u0000', (boolean)true);
                    break;
                }
                default: {
                    val = Integer.toHexString(b & 0xFF).toUpperCase();
                    val = StringFormat.padIt((String)val, (int)2, (char)'\u0000', (boolean)true);
                }
            }
            return val;
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            Settings settings = data.getColumnSettings();
            Byte[] bytes = (Byte[])value;
            this.setText(this.formatBytes(bytes, settings));
            return label;
        }

        public String getFilterString(Byte[] t, Settings settings) {
            String formatted = this.formatBytes(t, settings);
            return formatted;
        }
    };

    public String getColumnDisplayName(Settings settings) {
        String offset;
        Object name = this.getColumnName();
        int byteCnt = BYTE_COUNT.getChoice(settings);
        if (byteCnt != 0) {
            name = (String)name + "[" + byteCnt + "]";
        }
        if (!"0".equals(offset = MEMORY_OFFSET.getDisplayValue(settings))) {
            name = (String)name + offset;
        }
        return name;
    }

    public String getColumnName() {
        return "Bytes";
    }

    public Byte[] getValue(Address rowObject, Settings settings, Program pgm, ServiceProvider serviceProvider) throws IllegalArgumentException {
        Address addr = rowObject;
        try {
            int offset = MEMORY_OFFSET.getOffset(settings);
            int byteCnt = BYTE_COUNT.getChoice(settings);
            byte[] bytes = null;
            if (offset != 0) {
                addr = addr.add((long)offset);
            }
            if (byteCnt == 0) {
                if (offset != 0) {
                    byteCnt = 1;
                } else {
                    CodeUnit cu = pgm.getListing().getCodeUnitContaining(addr);
                    if (cu == null) {
                        return new Byte[0];
                    }
                    if (cu instanceof Instruction) {
                        Instruction instr = (Instruction)cu;
                        bytes = instr.getParsedBytes();
                    } else {
                        bytes = cu.getBytes();
                    }
                }
            }
            if (bytes == null) {
                bytes = new byte[byteCnt];
                pgm.getMemory().getBytes(addr, bytes);
            }
            Byte[] bytesObj = new Byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                bytesObj[i] = bytes[i];
            }
            return bytesObj;
        }
        catch (MemoryAccessException memoryAccessException) {
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            // empty catch block
        }
        return new Byte[0];
    }

    public GColumnRenderer<Byte[]> getColumnRenderer() {
        return this.monospacedRenderer;
    }

    @Override
    public ProgramLocation getProgramLocation(Address rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
        Address address = rowObject;
        int offset = MEMORY_OFFSET.getOffset(settings);
        if (offset != 0) {
            try {
                address = address.addNoWrap((long)offset);
            }
            catch (AddressOverflowException addressOverflowException) {
                // empty catch block
            }
        }
        return new BytesFieldLocation(program, address);
    }

    public SettingsDefinition[] getSettingsDefinitions() {
        return SETTINGS_DEFS;
    }
}

