/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.jf.baksmali.Baksmali;
import org.jf.baksmali.DeodexCommand;
import org.jf.baksmali.DisassembleCommand;
import org.jf.baksmali.DumpCommand;
import org.jf.baksmali.HelpCommand;
import org.jf.baksmali.ListCommand;
import org.jf.util.jcommander.Command;
import org.jf.util.jcommander.ExtendedCommands;
import org.jf.util.jcommander.ExtendedParameters;

@ExtendedParameters(includeParametersInUsage=true, commandName="baksmali", postfixDescription="See baksmali help <command> for more information about a specific command")
public class Main
extends Command {
    public static final String VERSION = Main.loadVersion();
    @Parameter(names={"--help", "-h", "-?"}, help=true, description="Show usage information")
    private boolean help;
    @Parameter(names={"--version", "-v"}, help=true, description="Print the version of baksmali and then exit")
    public boolean version;
    private JCommander jc;

    public Main() {
        super((List)Lists.newArrayList());
    }

    public void run() {
    }

    protected JCommander getJCommander() {
        return this.jc;
    }

    public static void main(String[] args) {
        JCommander jc;
        Main main = new Main();
        main.jc = jc = new JCommander((Object)main);
        jc.setProgramName("baksmali");
        List commandHierarchy = main.getCommandHierarchy();
        ExtendedCommands.addExtendedCommand((JCommander)jc, (Command)new DisassembleCommand(commandHierarchy));
        ExtendedCommands.addExtendedCommand((JCommander)jc, (Command)new DeodexCommand(commandHierarchy));
        ExtendedCommands.addExtendedCommand((JCommander)jc, (Command)new DumpCommand(commandHierarchy));
        ExtendedCommands.addExtendedCommand((JCommander)jc, (Command)new HelpCommand(commandHierarchy));
        ExtendedCommands.addExtendedCommand((JCommander)jc, (Command)new HelpCommand.HlepCommand(commandHierarchy));
        ExtendedCommands.addExtendedCommand((JCommander)jc, (Command)new ListCommand(commandHierarchy));
        jc.parse(args);
        if (main.version) {
            Main.version();
        }
        if (jc.getParsedCommand() == null || main.help) {
            main.usage();
            return;
        }
        Command command = (Command)((JCommander)jc.getCommands().get(jc.getParsedCommand())).getObjects().get(0);
        command.run();
    }

    protected static void version() {
        System.out.println("baksmali " + VERSION + " (http://smali.org)");
        System.out.println("Copyright (C) 2010 Ben Gruver (JesusFreke@JesusFreke.com)");
        System.out.println("BSD license (http://www.opensource.org/licenses/bsd-license.php)");
        System.exit(0);
    }

    private static String loadVersion() {
        InputStream propertiesStream = Baksmali.class.getClassLoader().getResourceAsStream("baksmali.properties");
        String version = "[unknown version]";
        if (propertiesStream != null) {
            Properties properties = new Properties();
            try {
                properties.load(propertiesStream);
                version = properties.getProperty("application.version");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return version;
    }
}

