/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.exporter;

import ghidra.graph.exporter.AbstractAttributedGraphExporter;
import ghidra.service.graph.AttributedGraph;
import java.io.File;
import java.io.IOException;
import org.jgrapht.Graph;
import org.jgrapht.nio.json.JSONExporter;

public class JsonGraphExporter
extends AbstractAttributedGraphExporter {
    public void exportGraph(AttributedGraph graph, File file) throws IOException {
        JSONExporter exporter = new JSONExporter(this.vertexIdProvider);
        exporter.setVertexAttributeProvider(this::getAttributes);
        exporter.setEdgeAttributeProvider(this::getAttributes);
        exporter.setEdgeIdProvider(this.edgeIdProvider);
        try {
            exporter.exportGraph((Graph)graph, file);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String getFileExtension() {
        return "json";
    }

    public String getName() {
        return "JSON";
    }

    public String getDesciption() {
        return "JGraphT library export of a graph to a JSON file";
    }
}

