/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import docking.action.DockingActionIf;
import docking.widgets.EventTrigger;
import ghidra.graph.visualization.DefaultGraphDisplay;
import ghidra.graph.visualization.DefaultGraphDisplayProvider;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayListener;
import ghidra.service.graph.GraphDisplayOptions;
import ghidra.util.Swing;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Set;

public class DefaultGraphDisplayWrapper
implements GraphDisplay,
Comparable<DefaultGraphDisplayWrapper> {
    private DefaultGraphDisplay delegate = (DefaultGraphDisplay)Swing.runNow(() -> new DefaultGraphDisplay(displayProvider, id));

    DefaultGraphDisplayWrapper(DefaultGraphDisplayProvider displayProvider, int id) {
    }

    void restoreDefaultState() {
        Swing.runNow(() -> this.delegate.restoreToDefaultSetOfActions());
    }

    boolean isDelegate(DefaultGraphDisplay other) {
        return other == this.delegate;
    }

    public void setGraphDisplayListener(GraphDisplayListener listener) {
        Swing.runNow(() -> this.delegate.setGraphDisplayListener(listener));
    }

    public void setFocusedVertex(AttributedVertex vertex, EventTrigger eventTrigger) {
        Swing.runNow(() -> this.delegate.setFocusedVertex(vertex));
    }

    public AttributedGraph getGraph() {
        return (AttributedGraph)Swing.runNow(() -> this.delegate.getGraph());
    }

    public AttributedVertex getFocusedVertex() {
        return (AttributedVertex)Swing.runNow(() -> this.delegate.getFocusedVertex());
    }

    public void selectVertices(Set<AttributedVertex> vertexSet, EventTrigger eventTrigger) {
        Swing.runNow(() -> this.delegate.selectVertices(vertexSet, eventTrigger));
    }

    public Set<AttributedVertex> getSelectedVertices() {
        return (Set)Swing.runNow(() -> this.delegate.getSelectedVertices());
    }

    public void close() {
        Swing.runNow(() -> this.delegate.close());
    }

    public void setGraph(AttributedGraph graph, GraphDisplayOptions options, String title, boolean append, TaskMonitor monitor) {
        Swing.runNow(() -> this.delegate.setGraph(graph, options, title, append, monitor));
    }

    public void clear() {
        Swing.runNow(() -> this.delegate.clear());
    }

    public void updateVertexName(AttributedVertex vertex, String newName) {
        Swing.runNow(() -> this.delegate.updateVertexName(vertex, newName));
    }

    public String getGraphTitle() {
        return (String)Swing.runNow(() -> this.delegate.getGraphTitle());
    }

    public void addAction(DockingActionIf action) {
        Swing.runNow(() -> this.delegate.addAction(action));
    }

    public Collection<DockingActionIf> getActions() {
        return (Collection)Swing.runNow(() -> this.delegate.getActions());
    }

    @Override
    public int compareTo(DefaultGraphDisplayWrapper other) {
        return -(this.delegate.getId() - other.delegate.getId());
    }
}

