/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.framework.main.datatree.Cuttable;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DataTreeClipboardUtils;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.main.datatree.FrontEndProjectTreeContext;
import ghidra.framework.main.datatree.PasteFileTask;
import ghidra.framework.main.projectdata.actions.ProjectDataCopyCutBaseAction;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class ProjectDataPasteAction
extends ProjectDataCopyCutBaseAction {
    private static Icon ICON = new GIcon("icon.projectdata.paste");

    public ProjectDataPasteAction(String owner, String group) {
        super("Paste", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Paste"}, ICON, group));
        this.setKeyBindingData(new KeyBindingData('V', 128));
        this.setHelpLocation(new HelpLocation("FrontEndPlugin", "Paste"));
    }

    @Override
    protected void actionPerformed(FrontEndProjectTreeContext context) {
        GTreeNode node = (GTreeNode)context.getContextObject();
        DomainFolderNode destNode = this.getFolderForNode(node);
        this.paste(context.getTree(), destNode);
    }

    @Override
    protected boolean isEnabledForContext(FrontEndProjectTreeContext context) {
        if (!context.hasExactlyOneFileOrFolder()) {
            return false;
        }
        if (!context.isInActiveProject()) {
            return false;
        }
        GTreeNode node = (GTreeNode)context.getContextObject();
        DomainFolderNode destNode = this.getFolderForNode(node);
        return this.checkNodeForPaste((GTreeNode)destNode);
    }

    @Override
    protected boolean isAddToPopup(FrontEndProjectTreeContext context) {
        if (!context.hasOneOrMoreFilesAndFolders()) {
            return false;
        }
        return context.isInActiveProject();
    }

    private DomainFolderNode getFolderForNode(GTreeNode node) {
        if (node instanceof DomainFolderNode) {
            return (DomainFolderNode)node;
        }
        return (DomainFolderNode)node.getParent();
    }

    private boolean checkNodeForPaste(GTreeNode destNode) {
        List<GTreeNode> list = DataTreeClipboardUtils.getDataTreeNodesFromClipboard();
        for (GTreeNode node : list) {
            if (node.isAncestor(destNode)) continue;
            return true;
        }
        return false;
    }

    private void paste(DataTree tree, DomainFolderNode folderNode) {
        List<GTreeNode> list = DataTreeClipboardUtils.getDataTreeNodesFromClipboard();
        boolean isCutOperation = this.isCutOperation(list);
        this.checkPasteList(tree, (GTreeNode)folderNode, list, isCutOperation);
        if (!list.isEmpty()) {
            PasteFileTask task = new PasteFileTask(folderNode, list, isCutOperation);
            new TaskLauncher((Task)task, (Component)((Object)tree), 1000);
        } else {
            tree.removeSelectionPath(null);
            tree.setSelectionPath(null);
        }
    }

    private void checkPasteList(DataTree tree, GTreeNode destNode, List<GTreeNode> list, boolean isCutOperation) {
        if (list == null) {
            return;
        }
        boolean listChanged = this.removeDecendantsFromList(list);
        boolean resetClipboard = false;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            GTreeNode tnode = list.get(i);
            boolean removeNodeFromList = false;
            if (tnode.getParent() != null && isCutOperation && !destNode.equals((Object)tnode)) {
                if (destNode == tnode.getParent()) {
                    removeNodeFromList = true;
                    sb.append("File " + tnode.getName() + " already exists at " + tnode.getParent());
                } else if (tnode instanceof DomainFolderNode && destNode.isAncestor(tnode)) {
                    removeNodeFromList = true;
                }
            } else if (tnode.getParent() == null || destNode == tnode) {
                removeNodeFromList = true;
                if (destNode == tnode) {
                    sb.append("Cannot paste file to itself: " + destNode.getName());
                }
            }
            if (!removeNodeFromList) continue;
            list.remove(i);
            if (i > 0) {
                --i;
            }
            resetClipboard = true;
            if (tnode.getParent() == null || !(tnode instanceof Cuttable)) continue;
            ((Cuttable)tnode).setIsCut(false);
        }
        if ((resetClipboard || listChanged) && sb.length() > 0) {
            String title = isCutOperation ? "Cannot Move File(s)" : "Cannot Copy File(s)";
            String action = isCutOperation ? "moved" : "copied";
            Msg.showWarn(((Object)((Object)this)).getClass(), (Component)((Object)tree), (String)title, (Object)("The following file(s) could not be " + action + ":\n" + sb.toString()));
        }
    }

    private boolean removeDecendantsFromList(List<GTreeNode> list) {
        int i;
        ArrayList<GTreeNode> newList = new ArrayList<GTreeNode>();
        for (i = 0; i < list.size(); ++i) {
            GTreeNode destNode = list.get(i);
            for (int j = 0; j < list.size(); ++j) {
                GTreeNode node = list.get(j);
                if (destNode == node || !node.isAncestor(destNode)) continue;
                newList.add(node);
            }
        }
        for (i = 0; i < newList.size(); ++i) {
            list.remove(newList.get(i));
        }
        return newList.size() > 0;
    }

    private boolean isCutOperation(List<GTreeNode> list) {
        for (GTreeNode node : list) {
            if (!(node instanceof Cuttable) || !((Cuttable)node).isCut()) continue;
            return true;
        }
        return false;
    }
}

