/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool;

import ghidra.framework.plugintool.DeafultPluginPackagingProvider;
import ghidra.framework.plugintool.DefaultPluginInstaller;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInstaller;
import ghidra.framework.plugintool.PluginPackagingProvider;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginDescription;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.framework.plugintool.util.PluginPackage;
import ghidra.framework.plugintool.util.PluginPackageState;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import utility.function.Callback;
import utility.function.Dummy;

public class PluginConfigurationModel {
    private final PluginInstaller pluginInstaller;
    private PluginPackagingProvider pluginPackagingProvider;
    private Callback listener = Callback.dummy();
    private Map<PluginDescription, Plugin> loadedPluginMap = new HashMap<PluginDescription, Plugin>();
    private Set<PluginDescription> pluginsWithDependenciesSet = new HashSet<PluginDescription>();
    private List<PluginDescription> unStablePluginDescriptions;
    private PluginPackage unstablePackage;

    public PluginConfigurationModel(PluginTool tool) {
        this(new DefaultPluginInstaller(tool), new DeafultPluginPackagingProvider(tool.getPluginsConfiguration()));
    }

    public PluginConfigurationModel(PluginInstaller pluginInstaller, PluginPackagingProvider pluginPackagingProvider) {
        this.pluginInstaller = pluginInstaller;
        this.pluginPackagingProvider = pluginPackagingProvider;
        this.initLoadedPlugins();
        this.unstablePackage = pluginPackagingProvider.getUnstablePluginPackage();
        this.unStablePluginDescriptions = pluginPackagingProvider.getUnstablePluginDescriptions();
    }

    public void setChangeCallback(Callback listener) {
        this.listener = Dummy.ifNull((Callback)listener);
    }

    public List<PluginPackage> getPluginPackages() {
        List<PluginPackage> pluginPackages = this.pluginPackagingProvider.getPluginPackages();
        ArrayList<PluginPackage> packagesWithStablePlugins = new ArrayList<PluginPackage>();
        for (PluginPackage pluginPackage : pluginPackages) {
            if (this.pluginPackagingProvider.getPluginDescriptions(pluginPackage).size() <= 0) continue;
            packagesWithStablePlugins.add(pluginPackage);
        }
        if (!this.unStablePluginDescriptions.isEmpty()) {
            packagesWithStablePlugins.add(this.unstablePackage);
        }
        return packagesWithStablePlugins;
    }

    public List<PluginDescription> getPluginDescriptions(PluginPackage pluginPackage) {
        if (pluginPackage == this.unstablePackage) {
            return this.unStablePluginDescriptions;
        }
        return this.pluginPackagingProvider.getPluginDescriptions(pluginPackage);
    }

    private void initLoadedPlugins() {
        this.loadedPluginMap.clear();
        this.pluginsWithDependenciesSet.clear();
        List<Plugin> list = this.pluginInstaller.getManagedPlugins();
        for (Plugin plugin : list) {
            this.loadedPluginMap.put(this.getPluginDescription(plugin), plugin);
            this.findDependencies(plugin, list);
        }
    }

    private void findDependencies(Plugin plugin, List<Plugin> plugins) {
        for (Plugin p : plugins) {
            if (!p.dependsUpon(plugin)) continue;
            this.pluginsWithDependenciesSet.add(this.getPluginDescription(plugin));
        }
    }

    private PluginDescription getPluginDescription(Plugin plugin) {
        String className = plugin.getClass().getName();
        return this.pluginPackagingProvider.getPluginDescription(className);
    }

    public boolean isLoaded(PluginDescription pluginDescription) {
        return this.loadedPluginMap.containsKey(pluginDescription);
    }

    public PluginPackageState getPackageState(PluginPackage pluginPackage) {
        boolean someInTool = false;
        boolean someNotInTool = false;
        List<PluginDescription> pluginDescriptions = this.getPluginDescriptions(pluginPackage);
        for (PluginDescription pluginDescription : pluginDescriptions) {
            if (this.isLoaded(pluginDescription)) {
                someInTool = true;
                continue;
            }
            someNotInTool = true;
        }
        if (!someInTool) {
            return PluginPackageState.NO_PLUGINS_LOADED;
        }
        if (!someNotInTool) {
            return PluginPackageState.ALL_PLUGINS_LOADED;
        }
        return PluginPackageState.SOME_PLUGINS_LOADED;
    }

    public void addPlugin(PluginDescription pluginDescription) {
        try {
            String name = pluginDescription.getPluginClass().getName();
            this.pluginInstaller.addPlugins(Arrays.asList(name));
        }
        catch (PluginException e) {
            Msg.showError((Object)this, null, (String)"Error Loading Plugin", (Object)e.getMessage(), (Throwable)((Object)e));
        }
        this.initLoadedPlugins();
        this.listener.call();
    }

    public void removeAllPlugins(PluginPackage pluginPackage) {
        List<PluginDescription> pluginDescriptions = this.getPluginDescriptions(pluginPackage);
        ArrayList<Plugin> loadedPlugins = new ArrayList<Plugin>();
        for (PluginDescription pluginDescription : pluginDescriptions) {
            if (!this.isLoaded(pluginDescription)) continue;
            loadedPlugins.add(this.loadedPluginMap.get(pluginDescription));
        }
        this.pluginInstaller.removePlugins(loadedPlugins);
        this.initLoadedPlugins();
        this.listener.call();
    }

    public void addSupportedPlugins(PluginPackage pluginPackage) {
        PluginStatus activationLevel = pluginPackage.getActivationLevel();
        List<PluginDescription> pluginDescriptions = this.getPluginDescriptions(pluginPackage);
        ArrayList<String> pluginClasseNames = new ArrayList<String>();
        for (PluginDescription pluginDescription : pluginDescriptions) {
            PluginStatus status = pluginDescription.getStatus();
            if (status.compareTo(activationLevel) > 0 || this.isLoaded(pluginDescription)) continue;
            pluginClasseNames.add(pluginDescription.getPluginClass().getName());
        }
        try {
            this.pluginInstaller.addPlugins(pluginClasseNames);
        }
        catch (PluginException e) {
            Msg.showError((Object)this, null, (String)"Error Loading Plugin(s) ", (Object)e.getMessage(), (Throwable)((Object)e));
        }
        this.initLoadedPlugins();
        this.listener.call();
    }

    public boolean hasOnlyUnstablePlugins(PluginPackage pluginPackage) {
        List<PluginDescription> pluginDescriptions = this.getPluginDescriptions(pluginPackage);
        for (PluginDescription pluginDescription : pluginDescriptions) {
            PluginStatus status = pluginDescription.getStatus();
            if (status.compareTo(PluginStatus.UNSTABLE) >= 0) continue;
            return false;
        }
        return true;
    }

    public void removePlugin(PluginDescription pluginDescription) {
        Plugin plugin = this.loadedPluginMap.get(pluginDescription);
        if (plugin != null) {
            this.pluginInstaller.removePlugins(Arrays.asList(plugin));
        }
        this.initLoadedPlugins();
        this.listener.call();
    }

    public boolean hasDependencies(PluginDescription pluginDependency) {
        return this.pluginsWithDependenciesSet.contains(pluginDependency);
    }

    public List<PluginDescription> getDependencies(PluginDescription pd) {
        Plugin plugin = this.loadedPluginMap.get(pd);
        return plugin != null ? this.getDependencies(plugin, this.pluginInstaller.getManagedPlugins()) : Collections.emptyList();
    }

    private List<PluginDescription> getDependencies(Plugin plugin, List<Plugin> plugins) {
        HashSet<PluginDescription> set = new HashSet<PluginDescription>();
        for (Plugin p : plugins) {
            if (!p.dependsUpon(plugin)) continue;
            set.add(p.getPluginDescription());
        }
        return new ArrayList<PluginDescription>(set);
    }

    public List<PluginDescription> getAllPluginDescriptions() {
        return this.pluginPackagingProvider.getPluginDescriptions();
    }
}

