/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.util;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.util.PluginPackage;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.Msg;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class PluginDescription
implements Comparable<PluginDescription> {
    private static HashMap<Class<? extends Plugin>, PluginDescription> CACHE = new HashMap();
    private static final String DOTCLASS_EXT = ".class";
    private final Class<? extends Plugin> pluginClass;
    private final String name;
    private final String shortDescription;
    private final String description;
    private final String category;
    private final PluginStatus status;
    private final PluginPackage pluginPackage;
    private final URL url;
    private final boolean isSlowInstallation;
    private String moduleName;
    private final List<Class<?>> servicesRequired;
    private final List<Class<?>> servicesProvided;
    private final List<Class<? extends PluginEvent>> eventsConsumed;
    private final List<Class<? extends PluginEvent>> eventsProduced;

    public static PluginDescription getPluginDescription(Class<? extends Plugin> c) {
        PluginDescription cachedPD = CACHE.computeIfAbsent(c, PluginDescription::createPluginDescription);
        return cachedPD;
    }

    PluginDescription(Class<? extends Plugin> pluginClass, String pluginPackageName, String category, String shortDescription, String description, PluginStatus status, boolean isSlowInstallation, List<Class<?>> servicesRequired, List<Class<?>> servicesProvided, List<Class<? extends PluginEvent>> eventsConsumed, List<Class<? extends PluginEvent>> eventsProduced) {
        this.pluginClass = pluginClass;
        this.name = pluginClass.getSimpleName();
        this.pluginPackage = PluginPackage.getPluginPackage(pluginPackageName);
        this.category = category;
        this.shortDescription = shortDescription == null ? "no description" : shortDescription;
        this.status = status;
        this.description = description == null ? this.shortDescription : description;
        this.isSlowInstallation = isSlowInstallation;
        String pathName = pluginClass.getName().replace('.', '/') + DOTCLASS_EXT;
        this.url = pluginClass.getClassLoader().getResource(pathName);
        this.servicesRequired = servicesRequired;
        this.servicesProvided = servicesProvided;
        this.eventsConsumed = eventsConsumed;
        this.eventsProduced = eventsProduced;
    }

    public boolean isSlowInstallation() {
        return this.isSlowInstallation;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getSourceLocation() {
        String path = this.url.getFile();
        if ("jar".equals(this.url.getProtocol())) {
            String fileProtoPrefix;
            int i = path.indexOf(33);
            if (i >= 0) {
                path = path.substring(0, i);
            }
            if (path.startsWith(fileProtoPrefix = "file:")) {
                path = path.substring(fileProtoPrefix.length() + 1);
            }
            return path;
        }
        String classpath = this.pluginClass.getName();
        path = path.substring(0, path.length() - classpath.length() - DOTCLASS_EXT.length() - 1);
        return path;
    }

    public boolean isInCategory(String parentCategory) {
        return parentCategory.equals(this.category);
    }

    public String getName() {
        return this.name;
    }

    public String getModuleName() {
        if (this.moduleName == null) {
            ResourceFile moduleDir = Application.getModuleContainingClass((String)this.pluginClass.getName());
            this.moduleName = moduleDir == null ? "<No Module>" : moduleDir.getName();
        }
        return this.moduleName;
    }

    public Class<? extends Plugin> getPluginClass() {
        return this.pluginClass;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCategory() {
        return this.category;
    }

    public PluginStatus getStatus() {
        return this.status;
    }

    public PluginPackage getPluginPackage() {
        return this.pluginPackage;
    }

    public List<Class<?>> getServicesRequired() {
        return this.servicesRequired;
    }

    public List<Class<?>> getServicesProvided() {
        return this.servicesProvided;
    }

    public List<Class<? extends PluginEvent>> getEventsConsumed() {
        return this.eventsConsumed;
    }

    public List<Class<? extends PluginEvent>> getEventsProduced() {
        return this.eventsProduced;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pluginClass == null ? 0 : this.pluginClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginDescription)) {
            return false;
        }
        PluginDescription other = (PluginDescription)obj;
        return !(this.pluginClass == null ? other.pluginClass != null : !this.pluginClass.equals(other.pluginClass));
    }

    public String toString() {
        return this.pluginPackage + ":" + this.category + ":" + this.name;
    }

    @Override
    public int compareTo(PluginDescription other) {
        return this.name.compareTo(other.name);
    }

    @Deprecated
    public static PluginDescription createPluginDescription(Class<?> pluginClass, PluginStatus status, String pluginPackage, String category, String shortDescription, String description) {
        PluginDescription pd = PluginDescription.createPluginDescription(pluginClass, status, pluginPackage, category, shortDescription, description, false);
        return pd;
    }

    @Deprecated
    public static PluginDescription createPluginDescription(Class<?> pluginClassParam, PluginStatus status, String pluginPackage, String category, String shortDescription, String description, boolean isSlowInstallation) {
        if (!Plugin.class.isAssignableFrom(pluginClassParam)) {
            throw new IllegalArgumentException("Bad Plugin class type: " + pluginClassParam);
        }
        Class<?> pluginClass = pluginClassParam;
        return new PluginDescription(pluginClass, pluginPackage, category, shortDescription, description, status, isSlowInstallation, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    private static PluginDescription createPluginDescription(Class<? extends Plugin> c) {
        PluginDescription pd = PluginDescription.createPluginDescriptionFromAnnotation(c);
        if (pd == null) {
            pd = PluginDescription.createPluginDescriptionFromDeprecatedStaticMethod(c);
        }
        return pd != null ? pd : PluginDescription.createDefaultPluginDescription(c);
    }

    private static PluginDescription createPluginDescriptionFromAnnotation(Class<? extends Plugin> c) {
        PluginInfo pia = c.getAnnotation(PluginInfo.class);
        return pia != null ? new PluginDescription(c, pia.packageName(), pia.category(), pia.shortDescription(), pia.description(), pia.status(), pia.isSlowInstallation(), Arrays.asList(pia.servicesRequired()), Arrays.asList(pia.servicesProvided()), Arrays.asList(pia.eventsConsumed()), Arrays.asList(pia.eventsProduced())) : null;
    }

    @Deprecated
    private static PluginDescription createPluginDescriptionFromDeprecatedStaticMethod(Class<? extends Plugin> pluginClass) {
        try {
            Method method = pluginClass.getMethod("getPluginDescription", Class.class);
            if (method.getReturnType() == PluginDescription.class) {
                return (PluginDescription)method.invoke(null, pluginClass);
            }
            Msg.debug(PluginDescription.class, (Object)("Bad return type for getPluginDescription in " + pluginClass.getName()));
        }
        catch (Throwable e) {
            Msg.debug(PluginDescription.class, (Object)("Error getting plugin description for " + pluginClass.getName() + ": " + e.getMessage()));
        }
        return null;
    }

    private static PluginDescription createDefaultPluginDescription(Class<? extends Plugin> c) {
        return new PluginDescription(c, "Miscellaneous", "Unmanaged", null, null, PluginStatus.UNSTABLE, false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }
}

