/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.extensions;

import docking.widgets.table.GTable;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableSortState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.project.extensions.ExtensionDetails;
import ghidra.framework.project.extensions.ExtensionTableModel;
import ghidra.util.HelpLocation;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ExtensionTablePanel
extends JPanel {
    private GTableFilterPanel<ExtensionDetails> tableFilterPanel;
    private ExtensionTableModel tableModel;
    private GTable table;

    public ExtensionTablePanel(PluginTool tool) {
        super(new BorderLayout());
        this.tableModel = new ExtensionTableModel((ServiceProvider)tool);
        this.tableModel.setTableSortState(TableSortState.createDefaultSortState((int)1));
        this.table = new GTable((TableModel)((Object)this.tableModel));
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 300));
        this.table.setSelectionMode(0);
        JScrollPane sp = new JScrollPane((Component)this.table);
        sp.getViewport().setBackground(this.table.getBackground());
        this.add((Component)sp, "Center");
        this.tableFilterPanel = new GTableFilterPanel((JTable)this.table, (RowObjectTableModel)this.tableModel);
        this.add((Component)this.tableFilterPanel, "South");
        HelpService help = Help.getHelpService();
        help.registerHelp((Object)this.table, new HelpLocation("FrontEndPlugin", "Extensions"));
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setMaxWidth(25);
    }

    public void dispose() {
        this.tableFilterPanel.dispose();
        this.table.dispose();
    }

    public ExtensionTableModel getTableModel() {
        return this.tableModel;
    }

    public GTable getTable() {
        return this.table;
    }

    public ExtensionDetails getSelectedItem() {
        return (ExtensionDetails)this.tableFilterPanel.getSelectedItem();
    }

    public void refreshTable() {
        this.tableModel.refreshTable();
    }

    public GTableFilterPanel<ExtensionDetails> getFilterPanel() {
        return this.tableFilterPanel;
    }

    public void setExtensions(Set<ExtensionDetails> extensions) {
        this.tableModel.setModelData(new ArrayList<ExtensionDetails>(extensions));
    }
}

