/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.transform.shape;

import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Optional;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.PolarPoint;
import org.jungrapht.visualization.transform.HyperbolicTransformer;
import org.jungrapht.visualization.transform.Intersections;
import org.jungrapht.visualization.transform.Lens;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.jungrapht.visualization.transform.shape.ShapeFlatnessTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HyperbolicShapeTransformer
extends HyperbolicTransformer
implements ShapeFlatnessTransformer {
    private static final Logger log = LoggerFactory.getLogger(HyperbolicShapeTransformer.class);

    public static Builder<?, ?> builder(Lens lens) {
        return new Builder(lens);
    }

    public static Builder<?, ?> builder(Dimension dimension) {
        return new Builder(dimension);
    }

    protected HyperbolicShapeTransformer(Builder builder) {
        super(builder);
    }

    protected HyperbolicShapeTransformer(Lens lens, MutableTransformer delegate) {
        super(lens, delegate);
    }

    protected HyperbolicShapeTransformer(Dimension d, MutableTransformer delegate) {
        super(d, delegate);
    }

    @Override
    public Shape transform(Shape shape) {
        return this.transform(shape, 0.0f);
    }

    @Override
    public Shape transform(Shape shape, float flatness) {
        if (log.isTraceEnabled()) {
            log.trace("transforming {}", (Object)shape);
        }
        GeneralPath newPath = new GeneralPath();
        float[] coords = new float[6];
        PathIterator iterator = null;
        iterator = flatness == 0.0f ? shape.getPathIterator(null) : shape.getPathIterator(null, flatness);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    Point2D p = this._transform(new Point2D.Float(coords[0], coords[1]));
                    newPath.moveTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 1: {
                    Point2D p = this._transform(new Point2D.Float(coords[0], coords[1]));
                    newPath.lineTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 2: {
                    Point2D p = this._transform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this._transform(new Point2D.Float(coords[2], coords[3]));
                    newPath.quadTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY());
                    break;
                }
                case 3: {
                    Point2D p = this._transform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this._transform(new Point2D.Float(coords[2], coords[3]));
                    Point2D r = this._transform(new Point2D.Float(coords[4], coords[5]));
                    newPath.curveTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY(), (float)r.getX(), (float)r.getY());
                    break;
                }
                case 4: {
                    newPath.closePath();
                }
            }
            iterator.next();
        }
        return newPath;
    }

    @Override
    public Shape inverseTransform(Shape shape) {
        GeneralPath newPath = new GeneralPath();
        float[] coords = new float[6];
        PathIterator iterator = shape.getPathIterator(null);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    Point2D p = this._inverseTransform(new Point2D.Float(coords[0], coords[1]));
                    newPath.moveTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 1: {
                    Point2D p = this._inverseTransform(new Point2D.Float(coords[0], coords[1]));
                    newPath.lineTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 2: {
                    Point2D p = this._inverseTransform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this._inverseTransform(new Point2D.Float(coords[2], coords[3]));
                    newPath.quadTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY());
                    break;
                }
                case 3: {
                    Point2D p = this._inverseTransform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this._inverseTransform(new Point2D.Float(coords[2], coords[3]));
                    Point2D r = this._inverseTransform(new Point2D.Float(coords[4], coords[5]));
                    newPath.curveTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY(), (float)r.getX(), (float)r.getY());
                    break;
                }
                case 4: {
                    newPath.closePath();
                }
            }
            iterator.next();
        }
        if (log.isTraceEnabled()) {
            log.trace("hyperbolic shape bounds: {}", (Object)newPath.getBounds());
        }
        return newPath;
    }

    private Point2D _transform(Point2D graphPoint) {
        if (graphPoint == null) {
            return null;
        }
        Point2D lensCenterInLayoutCoordinates = this.lens.getCenter();
        RectangularShape lensShape = this.lens.getLensShape();
        double centerToCorner = this.lens.getCenterToCorner();
        double ratio = this.lens.getRatio();
        double dx = graphPoint.getX() - lensCenterInLayoutCoordinates.getX();
        double dy = graphPoint.getY() - lensCenterInLayoutCoordinates.getY();
        Point pointFromCenter = Point.of((double)(dx *= ratio), (double)dy);
        PolarPoint polar = PolarPoint.cartesianToPolar((Point)pointFromCenter);
        double polarPointAngle = polar.theta;
        double polarPointRadius = polar.radius;
        if (!lensShape.contains(graphPoint)) {
            return graphPoint;
        }
        double mag = Math.tan(1.5707963267948966 * (double)this.lens.getMagnification());
        polarPointRadius *= mag;
        polarPointRadius = Math.min(polarPointRadius, centerToCorner);
        polarPointRadius /= centerToCorner;
        polarPointRadius *= 1.5707963267948966;
        polarPointRadius = Math.abs(Math.atan(polarPointRadius));
        polarPointRadius *= centerToCorner;
        polarPointRadius = Math.min(polarPointRadius, centerToCorner);
        if (lensShape instanceof Ellipse2D) {
            double lensRadius = this.lens.getRadius();
            polarPointRadius = Math.min(polarPointRadius, lensRadius);
        } else if (lensShape instanceof Rectangle2D) {
            Rectangle2D lensRectangle;
            Point projectedPoint = PolarPoint.polarToCartesian((double)polarPointAngle, (double)polarPointRadius);
            Line2D.Double vector = new Line2D.Double(lensCenterInLayoutCoordinates.getX(), lensCenterInLayoutCoordinates.getY(), lensCenterInLayoutCoordinates.getX() + projectedPoint.x, lensCenterInLayoutCoordinates.getY() + projectedPoint.y);
            Optional<Point2D> intersectionPointOptional = Intersections.getIntersectionPoint((Line2D)vector, lensRectangle = (Rectangle2D)this.lens.getLensShape());
            if (intersectionPointOptional.isPresent()) {
                Point2D intersectionPoint = intersectionPointOptional.get();
                polarPointRadius = lensCenterInLayoutCoordinates.distance(intersectionPoint);
            }
        }
        Point projectedPoint = PolarPoint.polarToCartesian((double)polarPointAngle, (double)polarPointRadius);
        projectedPoint = Point.of((double)(projectedPoint.x / ratio), (double)projectedPoint.y);
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.x + lensCenterInLayoutCoordinates.getX(), projectedPoint.y + lensCenterInLayoutCoordinates.getY());
        return translatedBack;
    }

    private Point2D _inverseTransform(Point2D viewPoint) {
        viewPoint = this.delegate.inverseTransform(viewPoint);
        Point2D viewCenter = this.lens.getCenter();
        double viewRadius = this.lens.getRadius();
        double ratio = this.lens.getRatio();
        double dx = viewPoint.getX() - viewCenter.getX();
        double dy = viewPoint.getY() - viewCenter.getY();
        Point pointFromCenter = Point.of((double)(dx *= ratio), (double)dy);
        PolarPoint polar = PolarPoint.cartesianToPolar((Point)pointFromCenter);
        double radius = polar.radius;
        if (radius > viewRadius) {
            return viewPoint;
        }
        radius /= viewRadius;
        radius = Math.abs(Math.tan(radius));
        radius /= 1.5707963267948966;
        radius *= viewRadius;
        double mag = Math.tan(1.5707963267948966 * (double)this.lens.getMagnification());
        polar = polar.newRadius(radius /= mag);
        Point projectedPoint = PolarPoint.polarToCartesian((PolarPoint)polar);
        projectedPoint = Point.of((double)(projectedPoint.x / ratio), (double)projectedPoint.y);
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.x + viewCenter.getX(), projectedPoint.y + viewCenter.getY());
        return translatedBack;
    }

    public static class Builder<T extends HyperbolicShapeTransformer, B extends Builder<T, B>>
    extends HyperbolicTransformer.Builder<T, B> {
        public Builder(Lens lens) {
            super(lens);
        }

        public Builder(Dimension dimension) {
            super(dimension);
        }

        @Override
        public T build() {
            if (this.lens == null && this.dimension != null) {
                this.lens = new Lens();
            }
            return (T)new HyperbolicShapeTransformer(this);
        }
    }
}

