/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package agent.frida.manager.evt;

import agent.frida.frida.FridaProcessInfo;

/**
 * The event corresponding with FridaProcess.eBroadcastBitSTDERR & FridaProcess.eBroadcastBitSTDOUT 
 */
public class FridaConsoleOutputEvent extends AbstractFridaEvent<FridaProcessInfo> {

	private int mask;
	private String text;

	public FridaConsoleOutputEvent(int mask, String text) {
		super(null);
		this.mask = mask;
		this.text = text;
	}

	public String getOutput() {
		return text;
	}

	public int getMask() {
		return mask;
	}
}
