/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.cmd;

import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.feature.fid.db.FidQueryService;
import ghidra.feature.fid.service.FidSearchResult;
import ghidra.feature.fid.service.FidService;
import ghidra.feature.fid.service.MatchNameAnalysis;
import ghidra.feature.fid.service.NameVersions;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSetViewAdapter;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class ApplyFidEntriesCommand
extends BackgroundCommand {
    public static final String FID_CONFLICT = "FID_conflict:";
    public static final String FID_BOOKMARK_CATEGORY = "Function ID Analyzer";
    public static final String FIDCONFLICT_BOOKMARK_CATEGORY = "Function ID Conflict";
    public static final int MAGIC_MULTIPLE_MATCH_LIMIT = 10;
    public static final int MAGIC_MULTIPLE_LIBRARY_LIMIT = 5;
    public static final int MAX_PLATE_COMMENT_LINE_LENGTH = 58;
    private MatchNameAnalysis nameAnalysis = new MatchNameAnalysis();
    private AddressSet affectedLocations = new AddressSet();
    private TreeMap<String, List<Address>> multiMatchNames = new TreeMap();
    private LinkedList<Address> conflictFunctions = new LinkedList();
    private boolean alwaysApplyFidLabels;
    private float scoreThreshold;
    private float multiNameScoreThreshold;
    private boolean createBookmarksEnabled;

    public ApplyFidEntriesCommand(AddressSetView set, float scoreThreshold, float multiThreshold, boolean alwaysApplyFidLabels, boolean createBookmarksEnabled) {
        super("ApplyFidEntriesCommand", true, true, false);
        this.scoreThreshold = scoreThreshold;
        this.multiNameScoreThreshold = multiThreshold;
        this.alwaysApplyFidLabels = alwaysApplyFidLabels;
        this.createBookmarksEnabled = createBookmarksEnabled;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        FidService service = new FidService();
        if (!(obj instanceof Program)) return false;
        Program program = (Program)obj;
        if (!service.canProcess(program.getLanguage())) {
            return false;
        }
        try (FidQueryService fidQueryService = service.openFidQueryService(program.getLanguage(), false);){
            monitor.setMessage("FID Analysis");
            List<FidSearchResult> processProgram = service.processProgram(program, fidQueryService, this.scoreThreshold, monitor);
            if (processProgram == null) {
                boolean bl = false;
                return bl;
            }
            for (FidSearchResult entry : processProgram) {
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
                if (entry.function.isThunk()) continue;
                if (!entry.matches.isEmpty()) {
                    this.processMatches(entry, program, monitor);
                    continue;
                }
                Msg.trace((Object)((Object)this), (Object)("no results for function " + entry.function.getName() + " at " + entry.function.getEntryPoint()));
            }
            this.applyConflictLabels(program);
            return true;
        }
        catch (CancelledException e) {
            return false;
        }
        catch (VersionException | IOException e) {
            this.setStatusMsg(e.getMessage());
            return false;
        }
    }

    private void processMatches(FidSearchResult result, Program program, TaskMonitor monitor) throws CancelledException {
        Object bookmarkContents = null;
        Object plateCommentContents = null;
        if (result.matches.size() == 0) {
            return;
        }
        this.nameAnalysis.analyzeNames(result.matches, program, monitor);
        if (this.nameAnalysis.getMostOptimisticCount() > 1 && this.nameAnalysis.getOverallScore() < this.multiNameScoreThreshold) {
            return;
        }
        this.nameAnalysis.analyzeLibraries(result.matches, 5, monitor);
        String newFunctionName = null;
        if (this.nameAnalysis.numNames() == 1) {
            bookmarkContents = "Library Function - Single Match, ";
            plateCommentContents = "Library Function - Single Match";
            newFunctionName = this.nameAnalysis.getNameIterator().next();
        } else {
            bookmarkContents = "Library Function - Multiple Matches, ";
            plateCommentContents = "Library Function - Multiple Matches";
            if (this.nameAnalysis.getMostOptimisticCount() == 1) {
                newFunctionName = this.nameAnalysis.getMostOptimisticName();
                plateCommentContents = (String)plateCommentContents + " With Same Base Name";
                bookmarkContents = (String)bookmarkContents + "Same ";
            } else {
                plateCommentContents = (String)plateCommentContents + " With Different Base Names";
                bookmarkContents = (String)bookmarkContents + "Different ";
            }
        }
        plateCommentContents = this.generateComment((String)plateCommentContents, monitor);
        bookmarkContents = this.generateBookmark((String)bookmarkContents);
        this.applyMarkup(result.function, newFunctionName, (String)plateCommentContents, (String)bookmarkContents, monitor);
    }

    private String listNames(TaskMonitor monitor) throws CancelledException {
        StringBuilder buffer = new StringBuilder();
        int counter = 0;
        Iterator<String> iterator = this.nameAnalysis.getNameIterator();
        while (iterator.hasNext()) {
            monitor.checkCanceled();
            String display = iterator.next();
            NameVersions versions = this.nameAnalysis.getVersions(display);
            if (versions != null && versions.demangledFull != null) {
                display = versions.demangledFull;
            }
            buffer.append(' ');
            buffer.append(display);
            buffer.append('\n');
            if (++counter <= 3) continue;
            break;
        }
        if (iterator.hasNext()) {
            buffer.append("  " + this.nameAnalysis.numNames() + " names - too many to list\n");
        }
        return buffer.toString();
    }

    private String listLibraries(TaskMonitor monitor) throws CancelledException {
        StringBuilder buffer = new StringBuilder();
        if (this.nameAnalysis.numLibraries() == 1) {
            buffer.append("Library: ");
        } else {
            buffer.append("Libraries: ");
        }
        int counter = 0;
        if (this.nameAnalysis.numLibraries() < 5) {
            Iterator<String> iterator = this.nameAnalysis.getLibraryIterator();
            while (iterator.hasNext()) {
                monitor.checkCanceled();
                if (counter != 0) {
                    buffer.append(", ");
                }
                buffer.append(iterator.next());
                ++counter;
            }
        } else {
            buffer.append(this.nameAnalysis.numLibraries() + " - too many to list");
        }
        return buffer.toString();
    }

    private String generateComment(String header, TaskMonitor monitor) throws CancelledException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(header);
        buffer.append("\n");
        buffer.append(this.listNames(monitor));
        buffer.append("\n");
        buffer.append(this.listLibraries(monitor));
        return buffer.toString();
    }

    private String generateBookmark(String bookmark) {
        StringBuilder buffer = new StringBuilder();
        if (this.createBookmarksEnabled) {
            buffer.append(bookmark);
            buffer.append(" ");
            buffer.append(this.nameAnalysis.getNameIterator().next());
        }
        return buffer.toString();
    }

    private void applyMarkup(Function function, String newFunctionName, String plateCommentContents, String bookmarkContents, TaskMonitor monitor) throws CancelledException {
        if (!this.alwaysApplyFidLabels && this.hasUserOrImportedSymbols(function)) {
            return;
        }
        if (newFunctionName != null) {
            this.addFunctionLabel(function, newFunctionName, monitor);
        } else {
            this.addFunctionLabelMultipleMatches(function, monitor);
        }
        if (plateCommentContents != null && !plateCommentContents.equals("")) {
            function.setComment(plateCommentContents);
        }
        if (bookmarkContents != null && !bookmarkContents.equals("")) {
            function.getProgram().getBookmarkManager().setBookmark(function.getEntryPoint(), "Analysis", FID_BOOKMARK_CATEGORY, bookmarkContents);
        }
    }

    private boolean hasUserOrImportedSymbols(Function function) {
        Symbol[] symbols;
        Program program = function.getProgram();
        SymbolTable symbolTable = program.getSymbolTable();
        for (Symbol symbol : symbols = symbolTable.getSymbols(function.getEntryPoint())) {
            SourceType sourceType = symbol.getSource();
            if (sourceType != SourceType.USER_DEFINED && sourceType != SourceType.IMPORTED) continue;
            return true;
        }
        return false;
    }

    private void addFunctionLabel(Function function, String newFunctionName, TaskMonitor monitor) {
        this.removeConflictSymbols(function, newFunctionName, monitor);
        this.addSymbolToFunction(function, newFunctionName);
    }

    private int deleteSymbol(String matchName, Address addr, Program program) {
        Symbol[] symbols;
        int numSymbols = 0;
        block0: for (int i = 0; i < 2 && (numSymbols = (symbols = program.getSymbolTable().getSymbols(addr)).length) > 1; ++i) {
            for (Symbol sym : symbols) {
                if (!sym.getName().equals(matchName)) continue;
                if (!sym.isPrimary()) {
                    sym.delete();
                    --numSymbols;
                    continue block0;
                }
                Symbol otherSym = symbols[0];
                if (otherSym == sym) {
                    otherSym = symbols[1];
                }
                SetLabelPrimaryCmd cmd = new SetLabelPrimaryCmd(addr, otherSym.getName(), otherSym.getParentNamespace());
                cmd.applyTo((DomainObject)program);
                continue block0;
            }
        }
        return numSymbols;
    }

    private void removeConflictSymbols(Function function, String matchName, TaskMonitor monitor) {
        List<Address> list = this.multiMatchNames.get(matchName);
        if (list == null) {
            return;
        }
        Program program = function.getProgram();
        for (Address addr : list) {
            BookmarkManager bookmarkManager;
            Bookmark bookmark;
            int numSymbols = this.deleteSymbol(matchName, addr, program);
            if (numSymbols > 1 || (bookmark = (bookmarkManager = program.getBookmarkManager()).getBookmark(addr, "Analysis", FIDCONFLICT_BOOKMARK_CATEGORY)) == null) continue;
            bookmarkManager.removeBookmark(bookmark);
        }
    }

    private void addFunctionLabelMultipleMatches(Function function, TaskMonitor monitor) throws CancelledException {
        Program program = function.getProgram();
        Symbol symbol = function.getSymbol();
        boolean preexistingSymbol = symbol != null && symbol.getSource() != SourceType.DEFAULT;
        Set<String> unusedNames = this.getFIDNamesThatDontExistSomewhereElse(program, this.nameAnalysis.getNameIterator());
        Address addr = function.getEntryPoint();
        for (String functionName : unusedNames) {
            monitor.checkCanceled();
            this.addSymbolToFunction(function, functionName);
            List<Address> list = this.multiMatchNames.get(functionName);
            if (list == null) {
                list = new LinkedList<Address>();
                this.multiMatchNames.put(functionName, list);
            }
            list.add(addr);
        }
        if (unusedNames.size() > 1) {
            if (!preexistingSymbol) {
                this.conflictFunctions.add(addr);
            }
            if (this.createBookmarksEnabled) {
                BookmarkManager bookmarkManager = function.getProgram().getBookmarkManager();
                bookmarkManager.setBookmark(addr, "Analysis", FIDCONFLICT_BOOKMARK_CATEGORY, "Multiple likely matching functions");
            }
        }
    }

    private void applyConflictLabels(Program program) {
        SymbolTable symbolTable = program.getSymbolTable();
        for (Address addr : this.conflictFunctions) {
            Object baseName;
            Symbol[] symbols = symbolTable.getSymbols(addr);
            if (symbols.length <= 1) continue;
            Symbol symbol = null;
            for (Symbol symbol2 : symbols) {
                if (!symbol2.isPrimary()) continue;
                symbol = symbol2;
                break;
            }
            if (symbol == null || !symbol.isGlobal() || ((String)(baseName = symbol.getName())).startsWith(FID_CONFLICT)) continue;
            DemangledObject demangle = NameVersions.demangle(program, (String)baseName);
            if (demangle != null) {
                baseName = demangle.getName();
            }
            baseName = FID_CONFLICT + (String)baseName;
            try {
                symbol = symbolTable.createLabel(addr, (String)baseName, null, SourceType.ANALYSIS);
                SetLabelPrimaryCmd cmd = new SetLabelPrimaryCmd(addr, symbol.getName(), symbol.getParentNamespace());
                cmd.applyTo((DomainObject)program);
            }
            catch (InvalidInputException e) {
                Msg.warn(SymbolUtilities.class, (Object)("Invalid symbol name: \"" + (String)baseName + "\" at " + addr));
            }
        }
    }

    private Set<String> getFIDNamesThatDontExistSomewhereElse(Program program, Iterator<String> iter) {
        HashSet<String> unusedNames = new HashSet<String>();
        SymbolTable symbolTable = program.getSymbolTable();
        while (iter.hasNext()) {
            String name = iter.next();
            if (this.nameExistsSomewhereElse(symbolTable, name)) continue;
            unusedNames.add(name);
            if (unusedNames.size() <= 10) continue;
            break;
        }
        return unusedNames;
    }

    private static boolean containsPrimarySymbol(SymbolTable symTab, String name) {
        List syms = symTab.getSymbols(name, null);
        for (Symbol symbol : syms) {
            SymbolType type = symbol.getSymbolType();
            if (type != SymbolType.FUNCTION && type != SymbolType.LABEL || !symbol.isPrimary()) continue;
            return true;
        }
        return false;
    }

    private boolean nameExistsSomewhereElse(SymbolTable symTab, String baseName) {
        if (this.multiMatchNames.containsKey(baseName)) {
            return false;
        }
        if (ApplyFidEntriesCommand.containsPrimarySymbol(symTab, baseName)) {
            return true;
        }
        if (ApplyFidEntriesCommand.containsPrimarySymbol(symTab, "_" + baseName)) {
            return true;
        }
        return ApplyFidEntriesCommand.containsPrimarySymbol(symTab, "__" + baseName);
    }

    private void addSymbolToFunction(Function function, String name) {
        SymbolTable symbolTable = function.getProgram().getSymbolTable();
        Address address = function.getEntryPoint();
        try {
            symbolTable.createLabel(address, name, null, SourceType.ANALYSIS);
            this.affectedLocations.add(address);
        }
        catch (InvalidInputException e) {
            Msg.warn(SymbolUtilities.class, (Object)("Invalid symbol name: \"" + name + "\" at " + address));
        }
    }

    public AddressSetView getFIDLocations() {
        return new AddressSetViewAdapter((AddressSetView)this.affectedLocations);
    }
}

