/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AnalysisState;
import ghidra.app.plugin.core.analysis.AnalysisStateInfo;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.PdbUniversalAnalyzer;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.bin.format.pdb.PdbException;
import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.pdb.PdbLocator;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class PdbAnalyzer
extends AbstractAnalyzer {
    static final String NAME = "PDB MSDIA";
    static final boolean DEFAULT_ENABLEMENT = false;
    private static final String DESCRIPTION = "PDB Analyzer.\nRequires MS DIA-SDK for raw PDB processing (Windows only).\nAlso supports pre-processed XML files.";
    private static final String ERROR_TITLE = "Error in PDB Analyzer";
    private static final String SYMBOLPATH_OPTION_NAME = "Symbol Repository Path";
    private static final String SYMBOLPATH_OPTION_DESCRIPTION = "Directory path to root of Microsoft Symbol Repository Directory";
    private File symbolsRepositoryDir = PdbLocator.DEFAULT_SYMBOLS_DIR;
    private static final String OPTION_NAME_INCLUDE_PE_PDB_PATH = "Unsafe: Include PE PDB Path in PDB Search";
    private static final String OPTION_DESCRIPTION_INCLUDE_PE_PDB_PATH = "If checked, specifically searching for PDB in PE-Header-Specified Location.";
    private boolean includePeSpecifiedPdbPath = false;
    private long lastTransactionId = -1L;

    public PdbAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(false);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.after());
        this.setSupportsOneTimeAnalysis();
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        long txId = program.getCurrentTransaction().getID();
        if (txId == this.lastTransactionId) {
            return false;
        }
        this.lastTransactionId = txId;
        if (!set.contains((AddressSetView)program.getMemory())) {
            return false;
        }
        if (PdbParser.isAlreadyLoaded(program)) {
            if (!PdbUniversalAnalyzer.isEnabled(program)) {
                Msg.info((Object)((Object)this), (Object)"Skipping PDB analysis since it has previouslu run.");
                Msg.info((Object)((Object)this), (Object)">> Clear 'PDB Loaded' program property or use Load PDB action if additional PDB processing required.");
            }
            return true;
        }
        if (PdbUniversalAnalyzer.isEnabled(program)) {
            log.appendMsg(this.getName(), "Stopped: Cannot run with PDB Universal Analyzer enabled");
            return false;
        }
        File pdb = this.lookForPdb(program, log);
        if (pdb == null) {
            Msg.info((Object)((Object)this), (Object)"PDB analyzer failed to locate PDB file");
            return false;
        }
        Msg.info((Object)((Object)this), (Object)("PDB analyzer parsing file: " + pdb.getAbsolutePath()));
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager((Program)program);
        return this.parsePdb(pdb, program, mgr, monitor, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File lookForPdb(Program program, MessageLog log) {
        Object message = "";
        try {
            File pdb = PdbParser.findPDB(program, this.includePeSpecifiedPdbPath, this.symbolsRepositoryDir);
            if (pdb == null) {
                PdbMissingState missingState = (PdbMissingState)AnalysisStateInfo.getAnalysisState((Program)program, PdbMissingState.class);
                if (missingState != null) {
                    File file = null;
                    return file;
                }
                AnalysisStateInfo.putAnalysisState((Program)program, (AnalysisState)new PdbMissingState());
                String pdbName = program.getOptions("Program Information").getString("PDB File", (String)null);
                message = StringUtils.isBlank((CharSequence)pdbName) ? "Program has no associated PDB file." : "Unable to locate PDB file \"" + pdbName + "\" with matching GUID.";
                message = SystemUtilities.isInHeadlessMode() ? (String)message + "\n Use a script to set the PDB file location. I.e.,\n    setAnalysisOption(currentProgram, \"PDB.Symbol Repository Path\", \"/path/to/pdb/folder\");\n This must be done using a pre-script (prior to analysis)." : (String)message + "\n You may set the PDB \"Symbol Repository Path\"\n using \"Edit->Options for [program]\" prior to analysis.\nIt is important that a PDB is used during initial analysis \nif available.";
            }
            File file = pdb;
            return file;
        }
        finally {
            if (((String)message).length() > 0) {
                log.appendMsg(this.getName(), (String)message);
                log.setStatus((String)message);
            }
        }
    }

    boolean parsePdb(File pdb, Program program, AutoAnalysisManager mgr, TaskMonitor monitor, MessageLog log) {
        DataTypeManagerService dataTypeManagerService = mgr.getDataTypeManagerService();
        PdbParser parser = new PdbParser(pdb, program, dataTypeManagerService, true, monitor);
        try {
            parser.parse();
            parser.openDataTypeArchives();
            parser.applyTo(log);
            return true;
        }
        catch (PdbException e) {
            String message = e.getMessage();
            log.appendMsg(this.getName(), message);
            log.setStatus(message);
            return false;
        }
        catch (CancelledException e) {
            return false;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            Msg.showError((Object)((Object)this), null, (String)ERROR_TITLE, (Object)msg, (Throwable)e);
            return false;
        }
    }

    public boolean canAnalyze(Program program) {
        return "Portable Executable (PE)".equals(program.getExecutableFormat());
    }

    public void registerOptions(Options options, Program program) {
        this.symbolsRepositoryDir = PdbLocator.getDefaultPdbSymbolsDir();
        options.registerOption(SYMBOLPATH_OPTION_NAME, OptionType.FILE_TYPE, (Object)this.symbolsRepositoryDir, null, SYMBOLPATH_OPTION_DESCRIPTION);
        options.registerOption(OPTION_NAME_INCLUDE_PE_PDB_PATH, (Object)this.includePeSpecifiedPdbPath, null, OPTION_DESCRIPTION_INCLUDE_PE_PDB_PATH);
    }

    public void optionsChanged(Options options, Program program) {
        File symbolsDir = options.getFile(SYMBOLPATH_OPTION_NAME, this.symbolsRepositoryDir);
        if (!symbolsDir.equals(this.symbolsRepositoryDir)) {
            this.symbolsRepositoryDir = symbolsDir;
            PdbLocator.setDefaultPdbSymbolsDir(symbolsDir);
        }
        this.includePeSpecifiedPdbPath = options.getBoolean(OPTION_NAME_INCLUDE_PE_PDB_PATH, this.includePeSpecifiedPdbPath);
    }

    private static class PdbMissingState
    implements AnalysisState {
        private PdbMissingState() {
        }
    }
}

