/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractModuleInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.SectionContribution600;
import java.util.Objects;

public class ModuleInformation600
extends AbstractModuleInformation {
    private AbstractPdb pdb;

    public ModuleInformation600(AbstractPdb pdb) {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
        this.sectionContribution = new SectionContribution600();
    }

    @Override
    protected void parseAdditionals(PdbByteReader reader) throws PdbException {
        this.ecSymbolicInformationEnabled = (this.spare & 1) == 1;
        this.spare >>= 1;
        this.nameIndexSourceFile = reader.parseUnsignedIntVal();
        this.nameIndexCompilerPdbPath = reader.parseUnsignedIntVal();
        this.moduleName = reader.parseNullTerminatedString(this.pdb.getPdbReaderOptions().getOneByteCharset());
        this.objectFileName = reader.parseNullTerminatedString(this.pdb.getPdbReaderOptions().getOneByteCharset());
    }

    @Override
    protected String dumpAdditionals() {
        StringBuilder builder = new StringBuilder();
        builder.append("\nnameIndexSourceFile: ");
        builder.append(this.nameIndexSourceFile);
        builder.append("\nnameIndexCompilerPdbPath: ");
        builder.append(this.nameIndexCompilerPdbPath);
        return builder.toString();
    }
}

