/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.program.model.data.CharsetInfo;
import java.nio.charset.Charset;
import java.util.List;

public class PdbReaderOptions
extends Exception {
    private static final String DEFAULT_ONE_BYTE_CHARSET_NAME = "UTF-8";
    private static final String DEFAULT_TWO_BYTE_CHARSET_NAME = "UTF-16";
    private static List<String> oneByteCharsetNames = CharsetInfo.getInstance().getCharsetNamesWithCharSize(1);
    private static List<String> twoByteCharsetNames = CharsetInfo.getInstance().getCharsetNamesWithCharSize(2);
    private String oneByteCharsetName = "UTF-8";
    private String twoByteCharsetName = "UTF-16";
    private Charset oneByteCharset;
    private Charset twoByteCharset;

    public PdbReaderOptions() {
        this.setOneByteCharsetForName(this.oneByteCharsetName);
        this.setWideCharCharsetForName(this.twoByteCharsetName);
    }

    public static List<String> getOneByteCharsetNames() {
        return oneByteCharsetNames;
    }

    public static List<String> getTwoByteCharsetNames() {
        return twoByteCharsetNames;
    }

    public PdbReaderOptions setOneByteCharsetForName(String name) {
        if (!oneByteCharsetNames.contains(name)) {
            throw new IllegalArgumentException("Unknown OneByteCharset: " + name);
        }
        this.oneByteCharset = Charset.forName(name);
        this.oneByteCharsetName = name;
        return this;
    }

    public PdbReaderOptions setWideCharCharsetForName(String name) {
        if (!twoByteCharsetNames.contains(name)) {
            throw new IllegalArgumentException("Unknown TwoByteCharset: " + name);
        }
        this.twoByteCharset = Charset.forName(name);
        this.twoByteCharsetName = name;
        return this;
    }

    public String getOneByteCharsetName() {
        return this.oneByteCharsetName;
    }

    public String getTwoByteCharsetName() {
        return this.twoByteCharsetName;
    }

    public String getWideCharCharsetName() {
        return this.twoByteCharsetName;
    }

    public Charset getOneByteCharset() {
        return this.oneByteCharset;
    }

    public Charset getTwoByteCharset() {
        return this.twoByteCharset;
    }

    public Charset getWideCharCharset() {
        return this.twoByteCharset;
    }
}

