/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RegisterName;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ProcedureFlags;

public abstract class AbstractManagedProcedureMsSymbol
extends AbstractMsSymbol {
    protected long parentPointer;
    protected long endPointer;
    protected long nextPointer;
    protected long procedureLength;
    protected long debugStartOffset;
    protected long debugEndOffset;
    protected long token;
    protected long symbolOffset;
    protected int symbolSegment;
    protected ProcedureFlags procedureFlags;
    protected int registerIndexContainingReturnValue;
    protected RegisterName registerContainingReturnValue;
    protected String name;

    public AbstractManagedProcedureMsSymbol(AbstractPdb pdb, PdbByteReader reader, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.parentPointer = reader.parseUnsignedIntVal();
        this.endPointer = reader.parseUnsignedIntVal();
        this.nextPointer = reader.parseUnsignedIntVal();
        this.procedureLength = reader.parseUnsignedIntVal();
        this.debugStartOffset = reader.parseUnsignedIntVal();
        this.debugEndOffset = reader.parseUnsignedIntVal();
        this.token = reader.parseUnsignedIntVal();
        this.symbolOffset = reader.parseUnsignedIntVal();
        this.symbolSegment = pdb.parseSegment(reader);
        this.procedureFlags = new ProcedureFlags(reader);
        this.registerIndexContainingReturnValue = reader.parseUnsignedShortVal();
        this.registerContainingReturnValue = new RegisterName(pdb, this.registerIndexContainingReturnValue);
        this.name = reader.parseString(pdb, strType);
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: [%04X:%08X], Length: %08X, Token: %s, ", this.getSymbolTypeName(), this.symbolSegment, this.symbolOffset, this.procedureLength, this.token));
        builder.append(this.name);
        builder.append(String.format("   Parent: %08X, End: %08X, Next: %08X\n", this.parentPointer, this.endPointer, this.nextPointer));
        builder.append(String.format("   Debug start: %08X, Debug end: %08X\n", this.debugStartOffset, this.debugEndOffset));
        builder.append(String.format("   %s\n", this.procedureFlags));
        builder.append(String.format("   Return Reg: %s\n", this.registerContainingReturnValue));
    }
}

