/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractParsableItem;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;

public class FunctionMsAttributes
extends AbstractParsableItem {
    private static final String HAS_CPP_STYLE_RETURN_UDT_STRING = "return UDT (C++ style)";
    private static final String INSTANCE_CONSTRUCTOR_STRING = "instance constructor";
    private static final String INSTANCE_CONSTRUCTOR_VIRTUAL_BASE_STRING = "instance constructor of a class with virtual base";
    private boolean hasCPPStyleReturnUDT;
    private boolean isInstanceConstructor;
    private boolean isInstanceConstructorOfClassWithVirtualBases;

    public FunctionMsAttributes(PdbByteReader reader) throws PdbException {
        int attributes = reader.parseUnsignedByteVal();
        this.processAttributes(attributes);
    }

    @Override
    public void emit(StringBuilder builder) {
        DelimiterState ds = new DelimiterState("", "|");
        builder.append(ds.out(this.hasCPPStyleReturnUDT, HAS_CPP_STYLE_RETURN_UDT_STRING));
        builder.append(ds.out(this.isInstanceConstructor, INSTANCE_CONSTRUCTOR_STRING));
        builder.append(ds.out(this.isInstanceConstructorOfClassWithVirtualBases, INSTANCE_CONSTRUCTOR_VIRTUAL_BASE_STRING));
    }

    private void processAttributes(int attributes) {
        this.hasCPPStyleReturnUDT = (attributes & 1) == 1;
        this.isInstanceConstructor = ((attributes >>= 1) & 1) == 1;
        this.isInstanceConstructorOfClassWithVirtualBases = ((attributes >>= 1) & 1) == 1;
    }
}

