/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb;

import docking.widgets.OptionDialog;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbIdentifiers;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.datatype.microsoft.GUID;
import ghidra.app.util.importer.LibrarySearchPathManager;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.pdb.PdbProgramAttributes;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.preferences.Preferences;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PdbLocator {
    public static final boolean onWindows = Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.WINDOWS;
    private static final File USER_HOME = new File(System.getProperty("user.home"));
    public static final File DEFAULT_SYMBOLS_DIR = onWindows ? new File("C:\\Symbols") : new File(USER_HOME, "Symbols");
    public static final File WINDOWS_SYMBOLS_DIR = onWindows ? new File("C:/WINDOWS/Symbols") : null;
    public static final String PDB_SYMBOLS_DIR_PREFERENCE = "PDB Storage Directory";
    private File symbolsRepositoryDir;
    private Map<String, PdbIdentifiers> identifiersByFilePath = new HashMap<String, PdbIdentifiers>();

    public PdbLocator(File symbolsRepositoryDir) {
        this.symbolsRepositoryDir = symbolsRepositoryDir;
    }

    public String findPdb(Program program, PdbProgramAttributes programAttributes, boolean userInteractive, boolean includePeSpecifiedPdbPath, TaskMonitor monitor, MessageLog log, String messagePrefix) throws CancelledException {
        List<String> orderedListOfExistingFileNames = this.lookForPdb(program, includePeSpecifiedPdbPath, log, messagePrefix);
        if (orderedListOfExistingFileNames.isEmpty()) {
            String message = "Cannot find candidate PDB files.";
            log.appendMsg(messagePrefix, message);
            return null;
        }
        String pdbFilename = null;
        try {
            pdbFilename = this.choosePdb(orderedListOfExistingFileNames, programAttributes, monitor, log, messagePrefix);
        }
        catch (PdbException e) {
            String message = "Could not find appropriate PDB file.  Detailed issues may follow:\n" + e.toString();
            log.appendMsg(messagePrefix, message);
            return null;
        }
        return pdbFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> lookForPdb(Program program, boolean includePeSpecifiedPdbPath, MessageLog log, String messagePrefix) {
        Object message = "";
        try {
            List<String> orderedListOfExistingFileNames = PdbLocator.findPDB(new PdbProgramAttributes(program), includePeSpecifiedPdbPath, this.symbolsRepositoryDir);
            if (orderedListOfExistingFileNames.isEmpty()) {
                String pdbName = program.getOptions("Program Information").getString("PDB File", (String)null);
                message = pdbName == null ? "Program has no associated PDB file." : "Unable to locate PDB file \"" + pdbName + "\" with matching GUID.";
                if (SystemUtilities.isInHeadlessMode()) {
                    message = (String)message + "\n Use a script to set the PDB Symbol Location. I.e.,\n    setAnalysisOption(currentProgram, \"PDB.Symbol Repository Path\", \"/path/to/pdb/folder\");\n This must be done using a pre-script (prior to analysis).";
                } else {
                    message = (String)message + "\n You can manually load PDBs using the \"File->Load PDB File...\" action.";
                    if (pdbName != null) {
                        message = (String)message + "\n Alternatively, you may set the PDB Symbol Repository Path\n using \"Edit->Options for [program]\" prior to analysis.";
                    }
                }
            }
            List<String> list = orderedListOfExistingFileNames;
            return list;
        }
        catch (PdbException pe) {
            message = (String)message + pe.getMessage();
        }
        finally {
            if (((String)message).length() > 0) {
                log.appendMsg(messagePrefix, (String)message);
                log.setStatus((String)message);
            }
        }
        return null;
    }

    private String choosePdb(List<String> orderedListOfExistingFileNames, PdbProgramAttributes programAttributes, TaskMonitor monitor, MessageLog log, String messagePrefix) throws PdbException, CancelledException {
        String choice = this.findMatchingPdb(orderedListOfExistingFileNames, programAttributes, monitor);
        if (choice == null) {
            String message = this.getNoMatchMessage(programAttributes, monitor);
            log.appendMsg(message);
        }
        return choice;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findMatchingPdb(List<String> orderedListOfExistingFileNames, PdbProgramAttributes programAttributes, TaskMonitor monitor) throws PdbException, CancelledException {
        Object message = "";
        Iterator<String> iterator = orderedListOfExistingFileNames.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                if (((String)message).isEmpty()) return null;
                throw new PdbException((String)message);
            }
            String filepath = iterator.next();
            monitor.checkCanceled();
            monitor.setMessage("Attempting to find/process PDB file " + filepath + "...");
            try {
                AbstractPdb tryPdb = PdbParser.parse(filepath, new PdbReaderOptions(), monitor);
                try {
                    PdbIdentifiers identifiers = tryPdb.getIdentifiers();
                    this.identifiersByFilePath.put(filepath, identifiers);
                    if (!PdbLocator.verifyPdbSignature(programAttributes, identifiers)) continue;
                    monitor.setMessage("Parsing validated PDB file " + filepath + ".");
                    String string = filepath;
                    return string;
                }
                finally {
                    if (tryPdb == null) continue;
                    tryPdb.close();
                }
            }
            catch (Exception e) {
                if (e.getClass().equals(FileNotFoundException.class)) continue;
                message = (String)message + "Exception for attempted PDB " + filepath + ": " + e.toString();
                continue;
            }
            break;
        }
    }

    private String userSelectPdb(PdbProgramAttributes programAttributes, String messagePrefix, MessageLog log, TaskMonitor monitor) throws CancelledException {
        String[] fileNames = new String[this.identifiersByFilePath.size()];
        String[] fileIdents = new String[this.identifiersByFilePath.size()];
        int i = 0;
        for (Map.Entry<String, PdbIdentifiers> entry : this.identifiersByFilePath.entrySet()) {
            monitor.checkCanceled();
            fileNames[i] = entry.getKey();
            fileIdents[i++] = PdbLocator.formatPdbIdentifiers(entry.getKey(), entry.getValue()).toString();
        }
        Object message = "Could not match program with PDB.\n";
        if (this.identifiersByFilePath.size() != 0) {
            message = (String)message + "PDB File Options (Name Signature Age GUID):\n";
            for (String fileIdent : fileIdents) {
                message = (String)message + fileIdent + "\n";
            }
        }
        if (SystemUtilities.isInHeadlessMode()) {
            message = "In Headless mode... skipping PDB processing.\n";
            log.appendMsg(messagePrefix, (String)message);
            log.setStatus((String)message);
            return null;
        }
        String string = "Choose PDB or Cancel (for: " + PdbLocator.formatPdbIdentifiers(programAttributes) + ")";
        String userChoice = OptionDialog.showInputChoiceDialog(null, (String)string, (String)"Choose", (String[])fileIdents, (String)fileIdents[0], (int)0);
        if (userChoice == null) {
            return null;
        }
        for (i = 0; i < fileIdents.length; ++i) {
            if (!userChoice.contentEquals(fileIdents[i])) continue;
            message = "User PDB Choice: " + userChoice;
            Msg.info((Object)this, (Object)message);
            return fileNames[i];
        }
        return null;
    }

    private String getNoMatchMessage(PdbProgramAttributes programAttributes, TaskMonitor monitor) throws CancelledException {
        StringBuilder builder = new StringBuilder();
        builder.append("ERROR: Could not run PDB Analyzer because a matched PDB was not found.\n");
        builder.append("PDB specification from PE header:\n");
        builder.append((CharSequence)PdbLocator.formatPdbIdentifiers(programAttributes));
        builder.append("Discovered non-matches:\n");
        for (Map.Entry<String, PdbIdentifiers> entry : this.identifiersByFilePath.entrySet()) {
            monitor.checkCanceled();
            builder.append((CharSequence)PdbLocator.formatPdbIdentifiers(entry.getKey(), entry.getValue()));
        }
        return builder.toString();
    }

    public static StringBuilder formatPdbIdentifiers(PdbProgramAttributes attributes) {
        Integer signature = attributes.getPdbSignature() == null ? null : Integer.valueOf(attributes.getPdbSignature());
        return PdbLocator.formatPdbIdentifiers(attributes.getPdbFile(), signature, Integer.valueOf(attributes.getPdbAge(), 16), attributes.getPdbGuid());
    }

    public static StringBuilder formatPdbIdentifiers(String file, PdbIdentifiers identifiers) {
        return PdbLocator.formatPdbIdentifiers(file, identifiers.getSignature(), identifiers.getAge(), identifiers.getGuid().toString());
    }

    private static StringBuilder formatPdbIdentifiers(String file, Integer signature, int age, String guidString) {
        StringBuilder builder = new StringBuilder();
        builder.append("  Location: ").append(file);
        if (signature != null) {
            builder.append(String.format("; Signature: 0X%08X", signature));
        }
        builder.append("; Age: 0x");
        builder.append(Integer.toHexString(age));
        if (guidString != null) {
            builder.append("; GUID: ");
            builder.append(guidString);
        }
        builder.append('\n');
        return builder;
    }

    private static List<String> findPDB(PdbProgramAttributes pdbAttributes, boolean includePeSpecifiedPdbPath, File symbolsRepositoryDir) throws PdbException {
        HashSet<String> guidSubdirPaths = new HashSet<String>();
        String guidAgeString = pdbAttributes.getGuidAgeCombo();
        if (guidAgeString == null) {
            throw new PdbException("Incomplete PDB information (GUID/Signature and/or age) associated with this program.\nEither the program is not a PE, or it was not compiled with debug information.");
        }
        List<String> potentialPdbNames = pdbAttributes.getPotentialPdbFilenames();
        for (String potentialName : potentialPdbNames) {
            guidSubdirPaths.add(File.separator + potentialName + File.separator + guidAgeString);
        }
        return PdbLocator.checkPathsForPdb(symbolsRepositoryDir, guidSubdirPaths, potentialPdbNames, pdbAttributes, includePeSpecifiedPdbPath);
    }

    private static List<String> checkPathsForPdb(File symbolsRepositoryDir, Set<String> guidSubdirPaths, List<String> potentialPdbNames, PdbProgramAttributes pdbAttributes, boolean includePeSpecifiedPdbPath) {
        Set<File> symbolsRepoPaths = PdbLocator.getSymbolsRepositoryPaths(symbolsRepositoryDir, guidSubdirPaths);
        Set<File> predefinedPaths = PdbLocator.getPredefinedPaths(guidSubdirPaths, pdbAttributes, includePeSpecifiedPdbPath);
        ArrayList<String> orderedListOfExistingFileNames = new ArrayList<String>();
        if (!symbolsRepoPaths.isEmpty()) {
            orderedListOfExistingFileNames.addAll(PdbLocator.checkSpecificPathsForPdb(symbolsRepoPaths, potentialPdbNames));
        }
        orderedListOfExistingFileNames.addAll(PdbLocator.checkSpecificPathsForPdb(predefinedPaths, potentialPdbNames));
        return orderedListOfExistingFileNames;
    }

    private static List<String> checkSpecificPathsForPdb(Set<File> paths, List<String> potentialPdbNames) {
        List<String> orderedListOfExistingFileNames = PdbLocator.checkForPDBorXML(paths, potentialPdbNames);
        return orderedListOfExistingFileNames;
    }

    private static Set<File> getSymbolsRepositoryPaths(File symbolsRepositoryDir, Set<String> guidSubdirPaths) {
        LinkedHashSet<File> symbolsRepoPaths = new LinkedHashSet<File>();
        if (symbolsRepositoryDir != null && symbolsRepositoryDir.isDirectory()) {
            for (String guidSubdir : guidSubdirPaths) {
                File testDir = new File(symbolsRepositoryDir, guidSubdir);
                if (!testDir.isDirectory()) continue;
                symbolsRepoPaths.add(testDir);
            }
            symbolsRepoPaths.add(symbolsRepositoryDir);
        }
        return symbolsRepoPaths;
    }

    private static Set<File> getPredefinedPaths(Set<String> guidSubdirPaths, PdbProgramAttributes pdbAttributes, boolean includePeSpecifiedPdbPath) {
        LinkedHashSet<File> predefinedPaths = new LinkedHashSet<File>();
        PdbLocator.getPathsFromAttributes(pdbAttributes, includePeSpecifiedPdbPath, predefinedPaths);
        PdbLocator.getSymbolPaths(DEFAULT_SYMBOLS_DIR, guidSubdirPaths, predefinedPaths);
        PdbLocator.getSymbolPaths(WINDOWS_SYMBOLS_DIR, guidSubdirPaths, predefinedPaths);
        PdbLocator.getLibraryPaths(guidSubdirPaths, predefinedPaths);
        return predefinedPaths;
    }

    private static void getLibraryPaths(Set<String> guidSubdirPaths, Set<File> predefinedPaths) {
        String[] libraryPaths;
        for (String path : libraryPaths = LibrarySearchPathManager.getLibraryPaths()) {
            File libFile = new File(path);
            if (!libFile.isDirectory()) continue;
            predefinedPaths.add(libFile);
            for (String guidSubdir : guidSubdirPaths) {
                File subDir = new File(path, guidSubdir);
                if (!subDir.isDirectory()) continue;
                predefinedPaths.add(subDir);
            }
        }
    }

    private static void getSymbolPaths(File symbolsDir, Set<String> guidSubdirPaths, Set<File> predefinedPaths) {
        if (symbolsDir == null || !symbolsDir.isDirectory()) {
            return;
        }
        predefinedPaths.add(symbolsDir);
        String specialPdbPath = symbolsDir.getAbsolutePath();
        for (String guidSubdir : guidSubdirPaths) {
            File testDir = new File(specialPdbPath + guidSubdir);
            if (!testDir.isDirectory()) continue;
            predefinedPaths.add(testDir);
        }
    }

    private static void getPathsFromAttributes(PdbProgramAttributes pdbAttributes, boolean includePeSpecifiedPdbPath, Set<File> predefinedPaths) {
        if (pdbAttributes != null) {
            File parentDir;
            String currentPath = pdbAttributes.getPdbFile();
            if (currentPath != null && includePeSpecifiedPdbPath && (parentDir = new File(currentPath).getParentFile()) != null && parentDir.exists()) {
                predefinedPaths.add(parentDir);
            }
            if ((currentPath = pdbAttributes.getExecutablePath()) != null && !currentPath.equals("unknown") && (parentDir = new File(currentPath).getParentFile()) != null && parentDir.exists()) {
                predefinedPaths.add(parentDir);
            }
        }
    }

    private static List<String> checkForPDBorXML(Set<File> potentialPdbDirs, List<String> potentialPdbNames) {
        ArrayList<String> orderedListOfExistingFileNames = new ArrayList<String>();
        for (File pdbPath : potentialPdbDirs) {
            for (String filename : potentialPdbNames) {
                File file = new File(pdbPath, filename);
                if (!file.isFile()) continue;
                orderedListOfExistingFileNames.add(file.getAbsolutePath());
            }
        }
        return orderedListOfExistingFileNames;
    }

    public static boolean verifyPdbSignature(PdbProgramAttributes programAttributes, PdbIdentifiers identifiers) throws PdbException {
        int attributesAge;
        String attributesGuidString = programAttributes.getPdbGuid();
        if (attributesGuidString == null) {
            String attributesSignatureString = programAttributes.getPdbSignature();
            if (attributesSignatureString == null) {
                throw new PdbException("No PDB GUID or Signature in file.\n Cannot match.");
            }
            int attributesSignature = Integer.parseInt(attributesSignatureString);
            if (attributesSignature != identifiers.getSignature()) {
                return false;
            }
        } else {
            GUID pdbGuid = identifiers.getGuid();
            if (!attributesGuidString.equals(pdbGuid.toString())) {
                return false;
            }
        }
        return (attributesAge = Integer.parseInt(programAttributes.getPdbAge(), 16)) == identifiers.getAge();
    }

    public static File getDefaultPdbSymbolsDir() {
        File pdbDirectory;
        String pdbStorageLocation = Preferences.getProperty((String)PDB_SYMBOLS_DIR_PREFERENCE, null, (boolean)true);
        File defaultSymbolsDir = DEFAULT_SYMBOLS_DIR;
        if (pdbStorageLocation != null && (pdbDirectory = new File(pdbStorageLocation)).isDirectory()) {
            defaultSymbolsDir = pdbDirectory;
        }
        return defaultSymbolsDir;
    }

    public static void setDefaultPdbSymbolsDir(File symbolsDir) {
        Preferences.setProperty((String)PDB_SYMBOLS_DIR_PREFERENCE, (String)symbolsDir.getAbsolutePath());
        Preferences.store();
    }
}

