/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.pdb.pdbapplicator.ObjectOrientedClassLayout;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorRestrictions;

public class PdbApplicatorOptions {
    public static final boolean DEFAULT_APPLY_CODE_SCOPE_BLOCK_COMMENTS = false;
    public static final boolean DEFAULT_APPLY_INSTRUCTION_LABELS = false;
    public static final PdbApplicatorRestrictions DEFAULT_RESTRICTIONS = PdbApplicatorRestrictions.NONE;
    public static final boolean DEFAULT_REMAP_ADDRESSES_USING_EXISTING_SYMBOLS = false;
    public static final boolean DEFAULT_ALLOW_DEMOTE_PRIMARY_MANGLED_SYMBOLS = true;
    public static final boolean DEFAULT_APPLY_FUNCTION_VARIABLES = false;
    public static final ObjectOrientedClassLayout DEFAULT_CLASS_LAYOUT = ObjectOrientedClassLayout.MEMBERS_ONLY;
    private boolean applyCodeScopeBlockComments;
    private boolean applyInstructionLabels;
    private PdbApplicatorRestrictions restrictions;
    private boolean remapAddressesUsingExistingPublicSymbols;
    private boolean allowDemotePrimaryMangledSymbols;
    private boolean applyFunctionVariables;
    private ObjectOrientedClassLayout classLayout;

    public PdbApplicatorOptions() {
        this.restoreDefaults();
    }

    public void restoreDefaults() {
        this.applyCodeScopeBlockComments = false;
        this.applyInstructionLabels = false;
        this.restrictions = DEFAULT_RESTRICTIONS;
        this.remapAddressesUsingExistingPublicSymbols = false;
        this.allowDemotePrimaryMangledSymbols = true;
        this.applyFunctionVariables = false;
        this.classLayout = DEFAULT_CLASS_LAYOUT;
    }

    public void setApplyCodeScopeBlockComments(boolean applyCodeScopeBlockComments) {
        this.applyCodeScopeBlockComments = applyCodeScopeBlockComments;
    }

    public boolean applyCodeScopeBlockComments() {
        return this.applyCodeScopeBlockComments;
    }

    public void setApplyInstructionLabels(boolean applyInstructionLabels) {
        this.applyInstructionLabels = applyInstructionLabels;
    }

    public boolean applyInstructionLabels() {
        return this.applyInstructionLabels;
    }

    public void setRestrictions(PdbApplicatorRestrictions restrictions) {
        this.restrictions = restrictions;
    }

    public PdbApplicatorRestrictions getRestrictions() {
        return this.restrictions;
    }

    public void setRemapAddressUsingExistingPublicSymbols(boolean enable) {
        this.remapAddressesUsingExistingPublicSymbols = enable;
    }

    public boolean remapAddressUsingExistingPublicSymbols() {
        return this.remapAddressesUsingExistingPublicSymbols;
    }

    public void setAllowDemotePrimaryMangledSymbols(boolean enable) {
        this.allowDemotePrimaryMangledSymbols = enable;
    }

    public boolean allowDemotePrimaryMangledSymbols() {
        return this.allowDemotePrimaryMangledSymbols;
    }

    public void setApplyFunctionVariables(boolean applyFunctionVariables) {
        this.applyFunctionVariables = applyFunctionVariables;
    }

    public boolean applyFunctionVariables() {
        return this.applyFunctionVariables;
    }

    public void setClassLayout(ObjectOrientedClassLayout classLayout) {
        this.classLayout = classLayout;
    }

    public ObjectOrientedClassLayout getClassLayout() {
        return this.classLayout;
    }
}

