/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;

public class ClangFieldToken
extends ClangToken {
    private DataType datatype = null;
    private int offset;

    public ClangFieldToken(ClangNode par) {
        super(par);
    }

    public DataType getDataType() {
        return this.datatype;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public void restoreFromXML(XmlElement el, XmlElement end, PcodeFactory pfactory) {
        String offsetstring;
        super.restoreFromXML(el, end, pfactory);
        String datatypestring = el.getAttribute("name");
        if (datatypestring != null) {
            this.datatype = pfactory.getDataTypeManager().findBaseType(datatypestring, el.getAttribute("id"));
        }
        if ((offsetstring = el.getAttribute("off")) != null) {
            this.offset = SpecXmlUtils.decodeInt((String)offsetstring);
        }
    }
}

