/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import generic.jar.ResourceFile;
import ghidra.app.decompiler.DecompileCallback;
import ghidra.app.decompiler.DecompileDebug;
import ghidra.app.decompiler.DecompileException;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompileProcess;
import ghidra.app.decompiler.DecompileProcessFactory;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.DecompilerDisposer;
import ghidra.app.decompiler.LimitedByteBuffer;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.lang.BasicCompilerSpec;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.SleighLanguageDescription;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.BlockGraph;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.TaskMonitor;
import ghidra.xml.XmlPullParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import org.xml.sax.ErrorHandler;

public class DecompInterface {
    protected Program program = null;
    private SleighLanguage pcodelanguage = null;
    private PcodeDataTypeManager dtmanage = null;
    protected String decompileMessage = "";
    protected BasicCompilerSpec compilerSpec = null;
    protected DecompileProcess decompProcess;
    protected DecompileCallback decompCallback = null;
    private DecompileDebug debug = null;
    protected CancelledListener monitorListener = new CancelledListener(){

        public void cancelled() {
            DecompInterface.this.stopProcess();
        }
    };
    private String actionname = "decompile";
    private DecompileOptions xmlOptions = null;
    private boolean printSyntaxTree = true;
    private boolean printCCode = true;
    private boolean sendParamMeasures = false;
    private boolean jumpLoad = false;

    public synchronized void enableDebug(File debugfile) {
        this.debug = new DecompileDebug(debugfile);
    }

    public boolean debugEnabled() {
        return this.debug != null;
    }

    public String getSimplificationStyle() {
        return this.actionname;
    }

    public Program getProgram() {
        return this.program;
    }

    public Language getLanguage() {
        return this.pcodelanguage;
    }

    public PcodeDataTypeManager getDataTypeManager() {
        return this.dtmanage;
    }

    public String getLastMessage() {
        return this.decompileMessage;
    }

    private boolean isErrorMessage() {
        if (this.decompileMessage == null || this.decompileMessage.length() == 0) {
            return false;
        }
        return this.decompileMessage.toLowerCase().indexOf("warning") == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fileToString(ResourceFile file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getInputStream()));){
            StringBuffer buffer = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            String string = buffer.toString();
            return string;
        }
    }

    protected void initializeProcess() throws IOException, DecompileException {
        if (this.decompCallback == null) {
            throw new IOException("Program not opened in decompiler");
        }
        if (this.decompProcess == null) {
            this.decompProcess = DecompileProcessFactory.get();
        } else if (!this.decompProcess.isReady()) {
            DecompileProcessFactory.release(this.decompProcess);
            this.decompProcess = DecompileProcessFactory.get();
        }
        long uniqueBase = 0x10000000L;
        String tspec = this.pcodelanguage.buildTranslatorTag(this.program.getAddressFactory(), uniqueBase, null);
        String coretypes = this.dtmanage.buildCoreTypes();
        SleighLanguageDescription sleighdescription = (SleighLanguageDescription)this.pcodelanguage.getLanguageDescription();
        ResourceFile pspecfile = sleighdescription.getSpecFile();
        String pspecxml = DecompInterface.fileToString(pspecfile);
        String cspecxml = this.compilerSpec.getCompilerSpecString();
        this.decompCallback.setNativeMessage(null);
        this.decompProcess.registerProgram(this.decompCallback, pspecxml, cspecxml, tspec, coretypes);
        String nativeMessage = this.decompCallback.getNativeMessage();
        if (nativeMessage != null && nativeMessage.length() != 0) {
            throw new IOException("Could not register program: " + nativeMessage);
        }
        if (this.xmlOptions != null) {
            this.decompProcess.setMaxResultSize(this.xmlOptions.getMaxPayloadMBytes());
            if (!this.decompProcess.sendCommand1Param("setOptions", this.xmlOptions.getXML(this)).toString().equals("t")) {
                throw new IOException("Did not accept decompiler options");
            }
        }
        if (this.actionname == null) {
            throw new IOException("Decompile action not specified");
        }
        if (!this.actionname.equals("decompile") && !this.decompProcess.sendCommand2Params("setAction", this.actionname, "").toString().equals("t")) {
            throw new IOException("Could not set decompile action");
        }
        if (!this.printSyntaxTree && !this.decompProcess.sendCommand2Params("setAction", "", "notree").toString().equals("t")) {
            throw new IOException("Could not turn off syntax tree");
        }
        if (!this.printCCode && !this.decompProcess.sendCommand2Params("setAction", "", "noc").toString().equals("t")) {
            throw new IOException("Could not turn off C printing");
        }
        if (this.sendParamMeasures && !this.decompProcess.sendCommand2Params("setAction", "", "parammeasures").toString().equals("t")) {
            throw new IOException("Could not turn on sending of parameter measures");
        }
        if (this.jumpLoad && !this.decompProcess.sendCommand2Params("setAction", "", "jumpload").toString().equals("t")) {
            throw new IOException("Could not turn on jumptable loads");
        }
    }

    protected void verifyProcess() throws IOException, DecompileException {
        if (this.decompProcess == null || !this.decompProcess.isReady()) {
            this.initializeProcess();
        }
        if (!this.decompProcess.isReady()) {
            throw new IOException("Unable to restart decompiler process");
        }
    }

    public synchronized boolean openProgram(Program prog) {
        this.decompileMessage = "";
        this.program = prog;
        Language lang = prog.getLanguage();
        if (!lang.supportsPcode()) {
            this.decompileMessage = "Language does not support PCode.";
            return false;
        }
        this.pcodelanguage = (SleighLanguage)lang;
        CompilerSpec spec = prog.getCompilerSpec();
        if (!(spec instanceof BasicCompilerSpec)) {
            this.decompileMessage = "Language has unsupported compiler spec: " + spec.getClass().getName();
            return false;
        }
        this.compilerSpec = (BasicCompilerSpec)spec;
        this.dtmanage = new PcodeDataTypeManager(prog);
        try {
            this.decompCallback = new DecompileCallback(prog, (Language)this.pcodelanguage, this.program.getCompilerSpec(), this.dtmanage);
            this.initializeProcess();
            if (!this.decompProcess.isReady()) {
                throw new IOException("Unable to start decompiler process");
            }
            this.decompileMessage = this.decompCallback.getNativeMessage();
            if (!this.isErrorMessage()) {
                return true;
            }
        }
        catch (Exception ex) {
            this.decompileMessage = ex.getMessage();
            if (this.decompProcess == null) {
                return false;
            }
            this.stopProcess();
        }
        this.program = null;
        this.decompCallback = null;
        return false;
    }

    public synchronized void closeProgram() {
        this.decompileMessage = "";
        if (this.program != null) {
            this.program = null;
            this.decompCallback = null;
            try {
                if (this.decompProcess != null && this.decompProcess.isReady()) {
                    this.decompProcess.deregisterProgram();
                    DecompileProcessFactory.release(this.decompProcess);
                }
            }
            catch (IOException iOException) {
            }
            catch (DecompileException decompileException) {
                // empty catch block
            }
            this.stopProcess();
        }
    }

    public synchronized boolean setSimplificationStyle(String actionstring) {
        this.actionname = actionstring;
        if (this.decompProcess == null) {
            return true;
        }
        try {
            this.verifyProcess();
            return this.decompProcess.sendCommand2Params("setAction", actionstring, "").toString().equals("t");
        }
        catch (IOException iOException) {
        }
        catch (DecompileException decompileException) {
            // empty catch block
        }
        this.stopProcess();
        return false;
    }

    public synchronized boolean toggleSyntaxTree(boolean val) {
        this.printSyntaxTree = val;
        if (this.decompProcess == null) {
            return true;
        }
        String printstring = val ? "tree" : "notree";
        try {
            this.verifyProcess();
            return this.decompProcess.sendCommand2Params("setAction", "", printstring).toString().equals("t");
        }
        catch (IOException iOException) {
        }
        catch (DecompileException decompileException) {
            // empty catch block
        }
        this.stopProcess();
        return false;
    }

    public synchronized boolean toggleCCode(boolean val) {
        this.printCCode = val;
        if (this.decompProcess == null) {
            return true;
        }
        String printstring = val ? "c" : "noc";
        try {
            this.verifyProcess();
            return this.decompProcess.sendCommand2Params("setAction", "", printstring).toString().equals("t");
        }
        catch (IOException iOException) {
        }
        catch (DecompileException decompileException) {
            // empty catch block
        }
        this.stopProcess();
        return false;
    }

    public synchronized boolean toggleParamMeasures(boolean val) {
        this.sendParamMeasures = val;
        if (this.decompProcess == null) {
            return true;
        }
        String printstring = val ? "parammeasures" : "noparammeasures";
        try {
            this.verifyProcess();
            return this.decompProcess.sendCommand2Params("setAction", "", printstring).toString().equals("t");
        }
        catch (IOException iOException) {
        }
        catch (DecompileException decompileException) {
            // empty catch block
        }
        this.stopProcess();
        return false;
    }

    public synchronized boolean toggleJumpLoads(boolean val) {
        this.jumpLoad = val;
        if (this.decompProcess == null) {
            return true;
        }
        String jumpstring = val ? "jumpload" : "nojumpload";
        try {
            this.verifyProcess();
            return this.decompProcess.sendCommand2Params("setAction", "", jumpstring).toString().equals("t");
        }
        catch (IOException iOException) {
        }
        catch (DecompileException decompileException) {
            // empty catch block
        }
        this.stopProcess();
        return false;
    }

    public synchronized boolean setOptions(DecompileOptions xmloptions) {
        this.xmlOptions = xmloptions;
        this.decompileMessage = "";
        if (this.decompProcess == null) {
            return true;
        }
        try {
            this.verifyProcess();
            this.decompProcess.setMaxResultSize(this.xmlOptions.getMaxPayloadMBytes());
            return this.decompProcess.sendCommand1Param("setOptions", xmloptions.getXML(this)).toString().equals("t");
        }
        catch (IOException iOException) {
        }
        catch (DecompileException decompileException) {
            // empty catch block
        }
        this.stopProcess();
        return false;
    }

    public synchronized DecompileOptions getOptions() {
        return this.xmlOptions;
    }

    public synchronized int flushCache() {
        int res = -1;
        try {
            if (this.decompProcess != null && this.decompProcess.isReady()) {
                String retval = this.decompProcess.sendCommand("flushNative").toString();
                return Integer.parseInt(retval);
            }
        }
        catch (IOException iOException) {
        }
        catch (DecompileException decompileException) {
            // empty catch block
        }
        this.stopProcess();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BlockGraph structureGraph(BlockGraph ingraph, AddressFactory factory, int timeoutSecs, TaskMonitor monitor) {
        this.decompileMessage = "";
        if (monitor != null && monitor.isCancelled()) {
            return null;
        }
        if (monitor != null) {
            monitor.addCancelledListener(this.monitorListener);
        }
        LimitedByteBuffer res = null;
        BlockGraph resgraph = null;
        try {
            StringWriter writer = new StringWriter();
            ingraph.saveXml((Writer)writer);
            this.verifyProcess();
            res = this.decompProcess.sendCommand1ParamTimeout("structureGraph", writer.toString(), timeoutSecs);
            this.decompileMessage = this.decompCallback.getNativeMessage();
            if (res != null) {
                XmlPullParser parser = HighFunction.stringTree((InputStream)res.getInputStream(), (ErrorHandler)HighFunction.getErrorHandler((Object)this, (String)"Results for structureGraph command"));
                resgraph = new BlockGraph();
                resgraph.restoreXml(parser, factory);
                resgraph.transferObjectRef(ingraph);
            }
        }
        catch (Exception ex) {
            this.decompileMessage = "Exception while graph structuring: " + ex.getMessage() + "\n";
        }
        finally {
            if (monitor != null) {
                monitor.removeCancelledListener(this.monitorListener);
            }
        }
        return resgraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DecompileResults decompileFunction(Function func, int timeoutSecs, TaskMonitor monitor) {
        DecompileProcess.DisposeState processState;
        this.decompileMessage = "";
        if (monitor != null && monitor.isCancelled()) {
            return null;
        }
        LimitedByteBuffer res = null;
        if (monitor != null) {
            monitor.addCancelledListener(this.monitorListener);
        }
        if (this.program == null) {
            return new DecompileResults(func, (Language)this.pcodelanguage, null, this.dtmanage, this.decompileMessage, null, DecompileProcess.DisposeState.DISPOSED_ON_CANCEL);
        }
        try {
            Address funcEntry = func.getEntryPoint();
            if (this.debug != null) {
                this.debug.setFunction(func);
            }
            this.decompCallback.setFunction(func, funcEntry, this.debug);
            String addrstring = Varnode.buildXMLAddress((Address)funcEntry);
            this.verifyProcess();
            res = this.decompProcess.sendCommand1ParamTimeout("decompileAt", addrstring.toString(), timeoutSecs);
            this.decompileMessage = this.decompCallback.getNativeMessage();
        }
        catch (Exception ex) {
            this.decompileMessage = "Exception while decompiling " + func.getEntryPoint() + ": " + ex.getMessage() + "\n";
        }
        finally {
            if (monitor != null) {
                monitor.removeCancelledListener(this.monitorListener);
            }
        }
        if (this.debug != null) {
            this.debug.shutdown((Language)this.pcodelanguage, this.xmlOptions.getXML(this));
            this.debug = null;
        }
        if (this.decompProcess != null) {
            processState = this.decompProcess.getDisposeState();
            if (this.decompProcess.getDisposeState() == DecompileProcess.DisposeState.NOT_DISPOSED) {
                this.flushCache();
            }
        } else {
            processState = DecompileProcess.DisposeState.DISPOSED_ON_CANCEL;
        }
        ByteArrayInputStream stream = null;
        if (res != null) {
            stream = res.getInputStream();
        }
        return new DecompileResults(func, (Language)this.pcodelanguage, (CompilerSpec)this.compilerSpec, this.dtmanage, this.decompileMessage, stream, processState);
    }

    public void stopProcess() {
        if (this.decompProcess != null) {
            this.decompProcess.dispose();
        }
    }

    public void resetDecompiler() {
        this.stopProcess();
        try {
            this.initializeProcess();
        }
        catch (DecompileException | IOException e) {
            this.decompileMessage = "Exception while resetting decompiler: " + e.getMessage() + "\n";
        }
    }

    public void dispose() {
        if (this.program == null) {
            if (this.decompProcess != null) {
                DecompileProcessFactory.release(this.decompProcess);
            }
            return;
        }
        DecompilerDisposer.dispose(this);
    }

    void disposeCallback() {
        this.closeProgram();
    }

    public CompilerSpec getCompilerSpec() {
        return this.compilerSpec;
    }
}

