/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.WrappingVerticalLayoutTextField;
import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.HighlightFactory;
import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.ClangFieldElement;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;

public class ClangTextField
extends WrappingVerticalLayoutTextField {
    private List<ClangToken> tokenList;
    private FieldElement lineNumberFieldElement;

    private static FieldElement createSingleLineElement(FieldElement[] textElements) {
        return new CompositeFieldElement(textElements, 0, textElements.length);
    }

    private static int calculateXPositionWithLineNumberOffset(int initialX, FieldElement lineNumberElement) {
        return initialX + lineNumberElement.getStringWidth();
    }

    private static int calculateWidthFromXPosition(int initialX, FieldElement lineNumberElement, int initialWidth) {
        return initialWidth - ClangTextField.calculateXPositionWithLineNumberOffset(initialX, lineNumberElement);
    }

    public ClangTextField(List<ClangToken> tokenList, FieldElement[] fieldElements, FieldElement lineNumberFieldElement, int x, int width, HighlightFactory hlFactory) {
        super(ClangTextField.createSingleLineElement(fieldElements), ClangTextField.calculateXPositionWithLineNumberOffset(x, lineNumberFieldElement), ClangTextField.calculateWidthFromXPosition(x, lineNumberFieldElement, width), 30, hlFactory);
        this.tokenList = tokenList;
        this.lineNumberFieldElement = lineNumberFieldElement;
    }

    public ClangToken getToken(FieldLocation loc) {
        if (loc == null) {
            return null;
        }
        FieldElement clickedObject = this.getClickedObject(loc);
        if (clickedObject instanceof ClangFieldElement) {
            ClangFieldElement element = (ClangFieldElement)clickedObject;
            return element.getToken();
        }
        int index = this.getTokenIndex(loc);
        return this.tokenList.get(index);
    }

    int getNextTokenIndexStartingAfter(FieldLocation location) {
        int n = 0;
        for (int i = 0; i < this.tokenList.size(); ++i) {
            if (location.col == n) {
                return i;
            }
            ClangToken token = this.tokenList.get(i);
            int length = n + token.getText().length();
            if (length >= location.col) {
                return i + 1;
            }
            n = length;
        }
        return this.tokenList.size();
    }

    int getTokenIndex(FieldLocation location) {
        int n = 0;
        for (int i = 0; i < this.tokenList.size(); ++i) {
            if (location.col == n) {
                return i;
            }
            ClangToken token = this.tokenList.get(i);
            int length = n + token.getText().length();
            if (length > location.col) {
                return i;
            }
            n = length;
        }
        return this.tokenList.size() - 1;
    }

    FieldElement getClickedObject(FieldLocation fieldLocation) {
        return this.getFieldElement(fieldLocation.row, fieldLocation.col);
    }

    List<ClangToken> getTokens() {
        return this.tokenList;
    }

    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle clip, FieldBackgroundColorManager selectionMap, RowColLocation cursorLoc, int rowHeight) {
        if (context.isPrinting() || context.isTextCopying()) {
            this.printTextWithoutLineNumbers(c, g, context, clip, selectionMap, cursorLoc, rowHeight);
            return;
        }
        this.lineNumberFieldElement.paint(c, g, 0, 0);
        super.paint(c, g, context, clip, selectionMap, cursorLoc, rowHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printTextWithoutLineNumbers(JComponent c, Graphics g, PaintContext context, Rectangle clip, FieldBackgroundColorManager selectionMap, RowColLocation cursorLoc, int rowHeight) {
        int oringalStartX = this.startX;
        try {
            this.stripLineNumbersAndLayoutText();
            super.paint(c, g, context, clip, selectionMap, cursorLoc, rowHeight);
        }
        finally {
            this.reapplyLineNumbersAndLayoutText(oringalStartX);
        }
    }

    private void stripLineNumbersAndLayoutText() {
        this.startX -= this.lineNumberFieldElement.getStringWidth();
    }

    private void reapplyLineNumbersAndLayoutText(int originalStartX) {
        this.startX = originalStartX;
    }

    public int getLineNumberWidth() {
        return this.lineNumberFieldElement.getStringWidth();
    }

    public int getLineNumber() {
        String text = this.lineNumberFieldElement.getText().trim();
        return Integer.parseInt(text);
    }
}

