/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.hover.DecompilerHoverService;
import ghidra.app.plugin.core.hover.AbstractConfigurableHover;
import ghidra.app.util.ToolTipUtils;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighConstant;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HTMLUtilities;
import javax.swing.JComponent;

public class FunctionSignatureDecompilerHover
extends AbstractConfigurableHover
implements DecompilerHoverService {
    private static final String NAME = "Function Signature Display";
    private static final String DESCRIPTION = "Show function signatures when hovering over a function name.";
    private static final int PRIORITY = 20;

    protected FunctionSignatureDecompilerHover(PluginTool tool) {
        super(tool, 20);
    }

    public void initializeOptions() {
        this.options = this.tool.getOptions("Decompiler Popups");
        this.options.registerOption(NAME, (Object)true, null, DESCRIPTION);
        this.setOptions((Options)this.options, NAME);
        this.options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void setOptions(Options options, String optionName) {
        if (optionName.equals(NAME)) {
            this.enabled = options.getBoolean(NAME, true);
        }
    }

    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        if (!this.enabled) {
            return null;
        }
        if (!(field instanceof ClangTextField)) {
            return null;
        }
        ClangToken token = ((ClangTextField)field).getToken(fieldLocation);
        if (token instanceof ClangFuncNameToken) {
            String name = token.getText();
            Symbol symbol = this.getSymbolForLocation(program, name);
            if (symbol == null) {
                return null;
            }
            if (symbol.getSymbolType() == SymbolType.FUNCTION) {
                Function function = program.getFunctionManager().getFunctionAt(symbol.getAddress());
                String content = ToolTipUtils.getToolTipText((Function)function, (boolean)false);
                return this.createTooltipComponent(content);
            }
        } else if (token instanceof ClangVariableToken) {
            Varnode vn = ((ClangVariableToken)token).getVarnode();
            if (vn == null) {
                return null;
            }
            if (!(vn.getHigh() instanceof HighConstant)) {
                return null;
            }
            HighConstant hv = (HighConstant)vn.getHigh();
            long offset = vn.getOffset();
            int sz = vn.getSize();
            boolean isSigned = true;
            if (hv.getDataType() instanceof AbstractIntegerDataType) {
                isSigned = ((AbstractIntegerDataType)hv.getDataType()).isSigned();
            }
            if (sz > 8) {
                return null;
            }
            Scalar scalar = new Scalar(sz * 8, offset, isSigned);
            long scalarLong = scalar.getValue();
            AddressFactory factory = program.getAddressFactory();
            AddressSpace space = factory.getDefaultAddressSpace();
            try {
                Address asAddress = factory.getAddress(space.getSpaceID(), scalarLong);
                Function function = program.getListing().getFunctionAt(asAddress);
                if (function != null) {
                    String content = ToolTipUtils.getToolTipText((Function)function, (boolean)false);
                    content = content.replaceFirst("<HTML>", "<HTML>" + HTMLUtilities.italic((String)HTMLUtilities.bold((String)"Reference to Function")) + "<br/><br/>");
                    return this.createTooltipComponent(content);
                }
            }
            catch (AddressOutOfBoundsException ex) {
                return null;
            }
        }
        return null;
    }

    private Symbol getSymbolForLocation(Program program, String symName) {
        SymbolTable symTable = program.getSymbolTable();
        SymbolIterator symbols = symTable.getSymbols(symName);
        for (Symbol symbol : symbols) {
            if (symbol.getSymbolType() != SymbolType.FUNCTION) continue;
            return symbol;
        }
        return null;
    }
}

