/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.plugin.core.decompile.DecompilePlugin;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.util.datatype.DataTypeSelectionDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.GlobalSymbolMap;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.LocalSymbolMap;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.data.DataTypeParser;

public abstract class AbstractDecompilerAction
extends DockingAction {
    AbstractDecompilerAction(String name) {
        super(name, DecompilePlugin.class.getSimpleName());
    }

    public boolean isValidContext(ActionContext context) {
        return context instanceof DecompilerActionContext;
    }

    public boolean isEnabledForContext(ActionContext context) {
        DecompilerActionContext decompilerContext = (DecompilerActionContext)context;
        return decompilerContext.checkActionEnablement(() -> this.isEnabledForDecompilerContext(decompilerContext));
    }

    public void actionPerformed(ActionContext context) {
        DecompilerActionContext decompilerContext = (DecompilerActionContext)context;
        decompilerContext.performAction(() -> this.decompilerActionPerformed(decompilerContext));
    }

    private static HighSymbol findHighSymbol(Address addr, HighFunction highFunction) {
        HighSymbol highSymbol = null;
        if (addr.isStackAddress()) {
            LocalSymbolMap lsym = highFunction.getLocalSymbolMap();
            highSymbol = lsym.findLocal(addr, null);
        } else {
            GlobalSymbolMap gsym = highFunction.getGlobalSymbolMap();
            highSymbol = gsym.getSymbol(addr);
        }
        return highSymbol;
    }

    public static HighSymbol findHighSymbolFromToken(ClangToken token, HighFunction highFunction) {
        if (highFunction == null) {
            return null;
        }
        HighVariable variable = token.getHighVariable();
        HighSymbol highSymbol = null;
        if (variable == null) {
            Function function = highFunction.getFunction();
            if (function == null) {
                return null;
            }
            Address storageAddress = AbstractDecompilerAction.getStorageAddress(token, function.getProgram());
            if (storageAddress == null) {
                return null;
            }
            highSymbol = AbstractDecompilerAction.findHighSymbol(storageAddress, highFunction);
        } else {
            highSymbol = variable.getSymbol();
        }
        return highSymbol;
    }

    private static Address getStorageAddress(ClangToken tokenAtCursor, Program program) {
        Varnode vnode = tokenAtCursor.getVarnode();
        Address storageAddress = null;
        if (vnode != null) {
            storageAddress = vnode.getAddress();
        } else if (tokenAtCursor instanceof ClangVariableToken) {
            PcodeOp op = ((ClangVariableToken)tokenAtCursor).getPcodeOp();
            storageAddress = HighFunctionDBUtil.getSpacebaseReferenceAddress((Program)program, (PcodeOp)op);
        }
        return storageAddress;
    }

    public static Structure getStructDataType(ClangToken tok) {
        ClangFieldToken fieldtok = (ClangFieldToken)tok;
        DataType dt = fieldtok.getDataType();
        if (dt == null) {
            return null;
        }
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        if (dt instanceof Structure) {
            return (Structure)dt;
        }
        return null;
    }

    protected static boolean checkFullCommit(HighSymbol highSymbol, HighFunction hfunction) {
        if (highSymbol != null && !highSymbol.isParameter()) {
            return false;
        }
        Function function = hfunction.getFunction();
        Parameter[] parameters = function.getParameters();
        LocalSymbolMap localSymbolMap = hfunction.getLocalSymbolMap();
        int numParams = localSymbolMap.getNumParams();
        if (numParams != parameters.length) {
            return true;
        }
        for (int i = 0; i < numParams; ++i) {
            HighSymbol param = localSymbolMap.getParamSymbol(i);
            if (param.getCategoryIndex() != i) {
                return true;
            }
            VariableStorage storage = param.getStorage();
            if (0 == storage.compareTo(parameters[i].getVariableStorage())) continue;
            return true;
        }
        return false;
    }

    public DataType chooseDataType(PluginTool tool, Program program, DataType currentDataType) {
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        DataTypeSelectionDialog chooserDialog = new DataTypeSelectionDialog(tool, (DataTypeManager)dataTypeManager, Integer.MAX_VALUE, DataTypeParser.AllowedDataTypes.FIXED_LENGTH);
        chooserDialog.setInitialDataType(currentDataType);
        tool.showDialog((DialogComponentProvider)chooserDialog);
        return chooserDialog.getUserChosenDataType();
    }

    protected abstract boolean isEnabledForDecompilerContext(DecompilerActionContext var1);

    protected abstract void decompilerActionPerformed(DecompilerActionContext var1);
}

