/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.util.AddEditDialog;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunctionShellSymbol;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.util.HelpLocation;
import ghidra.util.UndefinedFunction;

public class RenameFunctionAction
extends AbstractDecompilerAction {
    public RenameFunctionAction() {
        super("Rename Function");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRenameFunction"));
        this.setKeyBindingData(new KeyBindingData(76, 0));
        this.setPopupMenuData(new MenuData(new String[]{"Rename Function"}, "Decompile"));
    }

    private Function getFunction(DecompilerActionContext context) {
        Program program = context.getProgram();
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor instanceof ClangFuncNameToken) {
            return DecompilerUtils.getFunction(program, (ClangFuncNameToken)tokenAtCursor);
        }
        HighSymbol highSymbol = RenameFunctionAction.findHighSymbolFromToken(tokenAtCursor, context.getHighFunction());
        if (highSymbol instanceof HighFunctionShellSymbol) {
            return (Function)highSymbol.getSymbol().getObject();
        }
        return null;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function func = this.getFunction(context);
        return func != null && !(func instanceof UndefinedFunction);
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Program program = context.getProgram();
        Function function = this.getFunction(context);
        AddEditDialog dialog = new AddEditDialog("Edit Function Name", context.getTool());
        dialog.editLabel(function.getSymbol(), program);
    }
}

