/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.DialogComponentProvider;
import docking.widgets.dialogs.InputDialog;
import docking.widgets.dialogs.InputDialogListener;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.awt.Component;

public abstract class RenameTask {
    protected String newName = null;
    protected String oldName;
    protected String errorMsg = null;
    protected PluginTool tool;
    protected Program program;
    protected DecompilerPanel decompilerPanel;
    protected ClangToken tokenAtCursor;

    public RenameTask(PluginTool tool, Program program, DecompilerPanel panel, ClangToken token, String old) {
        this.tool = tool;
        this.program = program;
        this.decompilerPanel = panel;
        this.tokenAtCursor = token;
        this.oldName = old;
    }

    public abstract String getTransactionName();

    public abstract boolean isValid(String var1);

    public abstract void commit() throws DuplicateNameException, InvalidInputException;

    public String getNewName() {
        return this.newName;
    }

    private boolean runDialog(boolean oldNameIsCancel) {
        InputDialogListener listener = new InputDialogListener(){

            public boolean inputIsValid(InputDialog dialog) {
                String name = dialog.getValue();
                if (name == null || name.length() == 0) {
                    dialog.setStatusText("Cannot have empty name");
                    return false;
                }
                if (name.equals(RenameTask.this.oldName)) {
                    RenameTask.this.newName = name;
                    return true;
                }
                boolean res = RenameTask.this.isValid(name);
                if (!res) {
                    dialog.setStatusText(RenameTask.this.errorMsg);
                }
                return res;
            }
        };
        String label = "Rename " + this.oldName + ":";
        InputDialog renameVarDialog = new InputDialog(this.getTransactionName(), new String[]{label}, new String[]{this.oldName}, true, listener);
        this.tool.showDialog((DialogComponentProvider)renameVarDialog);
        if (renameVarDialog.isCanceled()) {
            return false;
        }
        return !oldNameIsCancel || !this.newName.equals(this.oldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask(boolean oldNameIsCancel) {
        boolean dialogres = this.runDialog(oldNameIsCancel);
        if (dialogres) {
            int transaction = this.program.startTransaction(this.getTransactionName());
            boolean commit = false;
            try {
                this.commit();
                commit = true;
            }
            catch (DuplicateNameException e) {
                Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Rename Failed", (Object)e.getMessage());
            }
            catch (InvalidInputException e) {
                Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Rename Failed", (Object)e.getMessage());
            }
            finally {
                this.program.endTransaction(transaction, commit);
                this.decompilerPanel.tokenRenamed(this.tokenAtCursor, this.getNewName());
            }
        }
    }

    public static boolean isSymbolInFunction(Function function, String name) {
        SymbolTable symbolTable = function.getProgram().getSymbolTable();
        return !symbolTable.getSymbols(name, (Namespace)function).isEmpty();
    }
}

