/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import java.awt.Component;

public class RetypeFieldAction
extends AbstractDecompilerAction {
    public RetypeFieldAction() {
        super("Retype Field");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRetypeField"));
        this.setPopupMenuData(new MenuData(new String[]{"Retype Field"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(76, 128));
    }

    private static int getEndComponentIndex(Structure struct, DataTypeComponent comp, DataType newtype) {
        int newlen = newtype.getLength();
        if (newlen <= 0) {
            return -1;
        }
        DataType curtype = comp.getDataType();
        newlen -= curtype.getLength();
        int index = comp.getOrdinal();
        while (newlen > 0) {
            if (++index >= struct.getNumComponents()) {
                return -1;
            }
            comp = struct.getComponent(index);
            curtype = comp.getDataType();
            if (curtype != DataType.DEFAULT) {
                return -1;
            }
            newlen -= curtype.getLength();
        }
        return index;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFieldToken) {
            Structure dt = RetypeFieldAction.getStructDataType(tokenAtCursor);
            return dt != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Program program = context.getProgram();
        PluginTool tool = context.getTool();
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        DataType dataType = null;
        Structure struct = RetypeFieldAction.getStructDataType(tokenAtCursor);
        int offset = ((ClangFieldToken)tokenAtCursor).getOffset();
        if (struct == null) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Retype Failed", (Object)"Failed to re-type structure");
            return;
        }
        if (offset < 0 || offset >= struct.getLength()) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Retype Failed", (Object)("Failed to re-type structure: " + struct.getName()));
            return;
        }
        DataTypeComponent comp = struct.getComponentAt(offset);
        dataType = comp == null ? this.chooseDataType(tool, program, DataType.DEFAULT) : this.chooseDataType(tool, program, comp.getDataType());
        if (dataType == null) {
            return;
        }
        boolean successfulMod = false;
        if (comp == null) {
            if (!struct.isNotYetDefined()) {
                Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Retype Failed", (Object)("Could not find component of '" + struct.getName() + "' to retype"));
                return;
            }
            int transaction = program.startTransaction("Retype Structure Field");
            try {
                if (dataType.getDataTypeManager() != dataTypeManager) {
                    dataType = dataTypeManager.resolve(dataType, null);
                }
                struct.insert(0, dataType);
                successfulMod = true;
            }
            finally {
                program.endTransaction(transaction, successfulMod);
            }
            return;
        }
        int transaction = program.startTransaction("Retype Structure Field");
        try {
            if (dataType.getDataTypeManager() != dataTypeManager) {
                dataType = dataTypeManager.resolve(dataType, null);
            }
            int startind = comp.getOrdinal();
            int endind = RetypeFieldAction.getEndComponentIndex(struct, comp, dataType);
            if (endind < 0) {
                Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Retype Failed", (Object)("Failed to re-type structure '" + struct.getName() + "': Datatype did not fit"));
                return;
            }
            for (int i = endind; i > startind; --i) {
                struct.clearComponent(i);
            }
            struct.replaceAtOffset(comp.getOffset(), dataType, dataType.getLength(), comp.getFieldName(), comp.getComment());
            successfulMod = true;
        }
        finally {
            program.endTransaction(transaction, successfulMod);
        }
    }
}

