/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.exporter;

import generic.cache.BasicFactory;
import generic.cache.CachingPool;
import generic.cache.CountingBasicFactory;
import generic.concurrent.QCallback;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.DecompiledFunction;
import ghidra.app.decompiler.parallel.ChunkingParallelDecompiler;
import ghidra.app.decompiler.parallel.ParallelDecompiler;
import ghidra.app.util.DomainObjectService;
import ghidra.app.util.Option;
import ghidra.app.util.OptionException;
import ghidra.app.util.exporter.Exporter;
import ghidra.app.util.exporter.ExporterException;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.util.OptionsService;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeWriter;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.FunctionTagManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CppExporter
extends Exporter {
    public static final String SPLIT_FILE = "Split each function into individual file";
    public static final String CREATE_C_FILE = "Create C File (.c)";
    public static final String CREATE_HEADER_FILE = "Create Header File (.h)";
    public static final String USE_CPP_STYLE_COMMENTS = "Use C++ Style comments (//)";
    public static final String EMIT_TYPE_DEFINITONS = "Emit data-type definitions";
    public static final String FUNCTION_TAG_FILTERS = "Function tags to filter";
    public static final String FUNCTION_TAG_EXCLUDE = "Function tags excluded";
    private static String EOL = System.getProperty("line.separator");
    private boolean isCreateHeaderFile = false;
    private boolean isCreateCFile = true;
    private boolean isUseCppStyleComments = true;
    private boolean emitDataTypeDefinitions = true;
    private String tagOptions = "";
    private ArrayList<FunctionTag> tagList = null;
    private boolean tagsExclude = true;
    private DecompileOptions options;
    private boolean userSuppliedOptions = false;

    public CppExporter() {
        super("C/C++", "c", new HelpLocation("ExporterPlugin", "c_cpp"));
    }

    public CppExporter(DecompileOptions options) {
        this();
        this.options = options;
        this.userSuppliedOptions = true;
    }

    public CppExporter(boolean createHeader, boolean createFile, boolean emitTypes, boolean excludeTags, String tags) {
        this();
        this.isCreateHeaderFile = createHeader;
        this.isCreateCFile = createFile;
        this.emitDataTypeDefinitions = emitTypes;
        this.tagsExclude = excludeTags;
        if (tags != null) {
            this.tagOptions = tags;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean export(File file, DomainObject domainObj, AddressSetView addrSet, TaskMonitor monitor) throws IOException, ExporterException {
        if (!(domainObj instanceof Program)) {
            this.log.appendMsg("Unsupported type: " + domainObj.getClass().getName());
            return false;
        }
        Program program = (Program)domainObj;
        this.configureOptions(program);
        this.configureFunctionTags(program);
        if (addrSet == null) {
            addrSet = program.getMemory();
        }
        File header = this.getHeaderFile(file);
        PrintWriter headerWriter = null;
        if (this.isCreateHeaderFile) {
            headerWriter = new PrintWriter(header);
        }
        PrintWriter cFileWriter = null;
        if (this.isCreateCFile) {
            cFileWriter = new PrintWriter(file);
        }
        CachingPool decompilerPool = new CachingPool((BasicFactory)new DecompilerFactory(program));
        ParallelDecompilerCallback callback = new ParallelDecompilerCallback((CachingPool<DecompInterface>)decompilerPool);
        ChunkingTaskMonitor chunkingMonitor = new ChunkingTaskMonitor(monitor);
        ChunkingParallelDecompiler<CPPResult> parallelDecompiler = ParallelDecompiler.createChunkingParallelDecompiler(callback, (TaskMonitor)chunkingMonitor);
        try {
            if (this.emitDataTypeDefinitions) {
                this.writeProgramDataTypes(program, header, headerWriter, cFileWriter, (TaskMonitor)chunkingMonitor);
            }
            chunkingMonitor.checkCanceled();
            this.decompileAndExport(addrSet, program, headerWriter, cFileWriter, parallelDecompiler, chunkingMonitor);
            boolean bl = true;
            return bl;
        }
        catch (CancelledException e) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)"Error in parallel decompile task", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            decompilerPool.dispose();
            parallelDecompiler.dispose();
            if (headerWriter != null) {
                headerWriter.close();
            }
            if (cFileWriter != null) {
                cFileWriter.close();
            }
        }
    }

    private void decompileAndExport(AddressSetView addrSet, Program program, PrintWriter headerWriter, PrintWriter cFileWriter, ChunkingParallelDecompiler<CPPResult> parallelDecompiler, ChunkingTaskMonitor chunkingMonitor) throws InterruptedException, Exception, CancelledException {
        int functionCount = program.getFunctionManager().getFunctionCount();
        chunkingMonitor.doInitialize(functionCount);
        Listing listing = program.getListing();
        FunctionIterator iterator = listing.getFunctions(addrSet, true);
        ArrayList<Function> functions = new ArrayList<Function>();
        int i = 0;
        while (iterator.hasNext()) {
            block7: {
                Function currentFunction;
                block6: {
                    if (i % 10000 == 0) {
                        List<CPPResult> results = parallelDecompiler.decompileFunctions(functions);
                        this.writeResults(results, headerWriter, cFileWriter, (TaskMonitor)chunkingMonitor);
                        functions.clear();
                    }
                    currentFunction = (Function)iterator.next();
                    if (this.tagList == null) break block6;
                    Set tags = currentFunction.getTags();
                    boolean hasTag = false;
                    for (FunctionTag tag : this.tagList) {
                        if (!tags.contains(tag)) continue;
                        hasTag = true;
                        break;
                    }
                    if (this.tagsExclude == hasTag) break block7;
                }
                functions.add(currentFunction);
            }
            ++i;
        }
        List<CPPResult> results = parallelDecompiler.decompileFunctions(functions);
        this.writeResults(results, headerWriter, cFileWriter, (TaskMonitor)chunkingMonitor);
    }

    private void writeResults(List<CPPResult> results, PrintWriter headerWriter, PrintWriter cFileWriter, TaskMonitor monitor) throws CancelledException {
        monitor.checkCanceled();
        Collections.sort(results);
        StringBuilder headers = new StringBuilder();
        StringBuilder bodies = new StringBuilder();
        for (CPPResult entry : results) {
            String bodyCode;
            monitor.checkCanceled();
            if (entry == null) continue;
            String headerCode = entry.getHeaderCode();
            if (headerCode != null) {
                headers.append(headerCode);
                headers.append(EOL);
            }
            if ((bodyCode = entry.getBodyCode()) == null) continue;
            bodies.append(bodyCode);
            bodies.append(EOL);
        }
        monitor.checkCanceled();
        if (headerWriter != null) {
            headerWriter.println(headers.toString());
        }
        if (cFileWriter != null) {
            cFileWriter.print(bodies.toString());
        }
    }

    private void configureOptions(Program program) {
        if (!this.userSuppliedOptions) {
            this.options = new DecompileOptions();
            if (this.provider != null) {
                OptionsService service = (OptionsService)this.provider.getService(OptionsService.class);
                if (service != null) {
                    ToolOptions opt = service.getOptions("Decompiler");
                    this.options.grabFromToolAndProgram(null, opt, program);
                }
            } else {
                this.options.grabFromProgram(program);
            }
            if (this.isUseCppStyleComments) {
                this.options.setCommentStyle(DecompileOptions.CommentStyleEnum.CPPStyle);
            } else {
                this.options.setCommentStyle(DecompileOptions.CommentStyleEnum.CStyle);
            }
        }
    }

    private void configureFunctionTags(Program program) {
        FunctionManager functionManager;
        if (this.tagOptions != null && this.tagOptions.length() != 0 && (functionManager = program.getFunctionManager()) instanceof FunctionManagerDB) {
            FunctionTagManager tagManager = ((FunctionManagerDB)functionManager).getFunctionTagManager();
            String[] split = this.tagOptions.split(",");
            this.tagList = new ArrayList();
            for (String tag : split) {
                FunctionTag functionTag = tagManager.getFunctionTag(tag.trim());
                if (functionTag == null) continue;
                this.tagList.add(functionTag);
            }
            if (this.tagList.isEmpty()) {
                this.tagList = null;
            }
        }
    }

    private void writeProgramDataTypes(Program program, File header, PrintWriter headerWriter, PrintWriter cFileWriter, TaskMonitor monitor) throws IOException, CancelledException {
        if (headerWriter != null) {
            ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
            DataTypeWriter dataTypeWriter = new DataTypeWriter((DataTypeManager)dtm, (Writer)headerWriter, this.isUseCppStyleComments);
            headerWriter.write(CppExporter.getFakeCTypeDefinitions(dtm.getDataOrganization()));
            dataTypeWriter.write((DataTypeManager)dtm, monitor);
            headerWriter.println("");
            headerWriter.println("");
            if (cFileWriter != null) {
                cFileWriter.println("#include \"" + header.getName() + "\"");
            }
        } else if (cFileWriter != null) {
            ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
            DataTypeWriter dataTypeWriter = new DataTypeWriter((DataTypeManager)dtm, (Writer)cFileWriter, this.isUseCppStyleComments);
            dataTypeWriter.write((DataTypeManager)dtm, monitor);
        }
        if (cFileWriter != null) {
            cFileWriter.println("");
            cFileWriter.println("");
        }
    }

    private File getHeaderFile(File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        return new File(file.getParent(), name + ".h");
    }

    public List<Option> getOptions(DomainObjectService domainObjectService) {
        ArrayList<Option> list = new ArrayList<Option>();
        list.add(new Option(CREATE_HEADER_FILE, (Object)this.isCreateHeaderFile));
        list.add(new Option(CREATE_C_FILE, (Object)this.isCreateCFile));
        list.add(new Option(USE_CPP_STYLE_COMMENTS, (Object)this.isUseCppStyleComments));
        list.add(new Option(EMIT_TYPE_DEFINITONS, (Object)this.emitDataTypeDefinitions));
        list.add(new Option(FUNCTION_TAG_FILTERS, (Object)this.tagOptions));
        list.add(new Option(FUNCTION_TAG_EXCLUDE, (Object)this.tagsExclude));
        return list;
    }

    public void setOptions(List<Option> options) throws OptionException {
        for (Option option : options) {
            String optName = option.getName();
            try {
                if (optName.equals(CREATE_HEADER_FILE)) {
                    this.isCreateHeaderFile = (Boolean)option.getValue();
                    continue;
                }
                if (optName.equals(CREATE_C_FILE)) {
                    this.isCreateCFile = (Boolean)option.getValue();
                    continue;
                }
                if (optName.equals(SPLIT_FILE)) continue;
                if (optName.equals(USE_CPP_STYLE_COMMENTS)) {
                    this.isUseCppStyleComments = (Boolean)option.getValue();
                    continue;
                }
                if (optName.equals(EMIT_TYPE_DEFINITONS)) {
                    this.emitDataTypeDefinitions = (Boolean)option.getValue();
                    continue;
                }
                if (optName.equals(FUNCTION_TAG_FILTERS)) {
                    this.tagOptions = (String)option.getValue();
                    continue;
                }
                if (optName.equals(FUNCTION_TAG_EXCLUDE)) {
                    this.tagsExclude = (Boolean)option.getValue();
                    continue;
                }
                throw new OptionException("Unknown option: " + optName);
            }
            catch (ClassCastException e) {
                throw new OptionException("Invalid type for option: " + optName + " - " + e.getMessage());
            }
        }
    }

    private static String getBuiltInDeclaration(String typeName, String ctypeName) {
        return "#define " + typeName + "   " + ctypeName + EOL;
    }

    private static String getBuiltInDeclaration(String typeName, int typeLen, boolean signed, DataOrganization dataOrganization) {
        return CppExporter.getBuiltInDeclaration(typeName, dataOrganization.getIntegerCTypeApproximation(typeLen, signed));
    }

    private static String getFakeCTypeDefinitions(DataOrganization dataOrganization) {
        int n;
        StringWriter writer = new StringWriter();
        for (n = 9; n <= 16; ++n) {
            writer.write(CppExporter.getBuiltInDeclaration("unkbyte" + n, n, false, dataOrganization));
        }
        writer.write(EOL);
        for (n = 9; n <= 16; ++n) {
            writer.write(CppExporter.getBuiltInDeclaration("unkuint" + n, n, false, dataOrganization));
        }
        writer.write(EOL);
        for (n = 9; n <= 16; ++n) {
            writer.write(CppExporter.getBuiltInDeclaration("unkint" + n, n, true, dataOrganization));
        }
        writer.write(EOL);
        writer.write(CppExporter.getBuiltInDeclaration("unkfloat1", "float"));
        writer.write(CppExporter.getBuiltInDeclaration("unkfloat2", "float"));
        writer.write(CppExporter.getBuiltInDeclaration("unkfloat3", "float"));
        writer.write(CppExporter.getBuiltInDeclaration("unkfloat5", "double"));
        writer.write(CppExporter.getBuiltInDeclaration("unkfloat6", "double"));
        writer.write(CppExporter.getBuiltInDeclaration("unkfloat7", "double"));
        writer.write(CppExporter.getBuiltInDeclaration("unkfloat9", "long double"));
        writer.write(CppExporter.getBuiltInDeclaration("unkfloat11", "long double"));
        writer.write(CppExporter.getBuiltInDeclaration("unkfloat12", "long double"));
        writer.write(CppExporter.getBuiltInDeclaration("unkfloat13", "long double"));
        writer.write(CppExporter.getBuiltInDeclaration("unkfloat14", "long double"));
        writer.write(CppExporter.getBuiltInDeclaration("unkfloat15", "long double"));
        writer.write(CppExporter.getBuiltInDeclaration("unkfloat16", "long double"));
        writer.write(EOL);
        writer.write(CppExporter.getBuiltInDeclaration("BADSPACEBASE", "void"));
        writer.write(CppExporter.getBuiltInDeclaration("code", "void"));
        writer.write(EOL);
        return writer.toString();
    }

    private class ChunkingTaskMonitor
    extends TaskMonitorAdapter {
        private TaskMonitor monitor;

        ChunkingTaskMonitor(TaskMonitor monitor) {
            this.monitor = monitor;
        }

        void doInitialize(long value) {
            this.monitor.initialize(value);
        }

        public void setProgress(long value) {
            this.monitor.setProgress(value);
        }

        public void checkCanceled() throws CancelledException {
            this.monitor.checkCanceled();
        }

        public void setMessage(String message) {
            this.monitor.setMessage(message);
        }

        public synchronized void addCancelledListener(CancelledListener listener) {
            this.monitor.addCancelledListener(listener);
        }

        public synchronized void removeCancelledListener(CancelledListener listener) {
            this.monitor.removeCancelledListener(listener);
        }
    }

    private class ParallelDecompilerCallback
    implements QCallback<Function, CPPResult> {
        private CachingPool<DecompInterface> pool;

        ParallelDecompilerCallback(CachingPool<DecompInterface> decompilerPool) {
            this.pool = decompilerPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CPPResult process(Function function, TaskMonitor monitor) throws Exception {
            if (monitor.isCancelled()) {
                return null;
            }
            DecompInterface decompiler = (DecompInterface)this.pool.get();
            try {
                CPPResult result;
                CPPResult cPPResult = result = this.doWork(function, decompiler, monitor);
                return cPPResult;
            }
            finally {
                this.pool.release((Object)decompiler);
            }
        }

        private CPPResult doWork(Function function, DecompInterface decompiler, TaskMonitor monitor) {
            Address entryPoint = function.getEntryPoint();
            CodeUnit codeUnitAt = function.getProgram().getListing().getCodeUnitAt(entryPoint);
            if (codeUnitAt == null || !(codeUnitAt instanceof Instruction)) {
                return new CPPResult(entryPoint, function.getPrototypeString(false, false), null);
            }
            monitor.setMessage("Decompiling " + function.getName());
            DecompileResults dr = decompiler.decompileFunction(function, CppExporter.this.options.getDefaultTimeout(), monitor);
            String errorMessage = dr.getErrorMessage();
            if (!"".equals(errorMessage)) {
                Msg.warn((Object)((Object)CppExporter.this), (Object)("Error decompiling: " + errorMessage));
                if (CppExporter.this.options.isWARNCommentIncluded()) {
                    monitor.incrementProgress(1L);
                    return new CPPResult(entryPoint, null, "/*" + EOL + "Unable to decompile '" + function.getName() + "'" + EOL + "Cause: " + errorMessage + EOL + "*/" + EOL);
                }
                return null;
            }
            DecompiledFunction decompiledFunction = dr.getDecompiledFunction();
            return new CPPResult(entryPoint, decompiledFunction.getSignature(), decompiledFunction.getC());
        }
    }

    private class DecompilerFactory
    extends CountingBasicFactory<DecompInterface> {
        private Program program;

        DecompilerFactory(Program program) {
            this.program = program;
        }

        public DecompInterface doCreate(int itemNumber) throws IOException {
            DecompInterface decompiler = new DecompInterface();
            decompiler.setOptions(CppExporter.this.options);
            decompiler.openProgram(this.program);
            decompiler.toggleSyntaxTree(false);
            return decompiler;
        }

        public void doDispose(DecompInterface decompiler) {
            decompiler.dispose();
        }
    }

    private class CPPResult
    implements Comparable<CPPResult> {
        private Address address;
        private String bodyCode;
        private String headerCode;

        CPPResult(Address address, String headerCode, String bodyCode) {
            this.address = address;
            this.headerCode = headerCode;
            this.bodyCode = bodyCode;
        }

        String getHeaderCode() {
            return this.headerCode;
        }

        String getBodyCode() {
            return this.bodyCode;
        }

        @Override
        public int compareTo(CPPResult other) {
            return this.address.compareTo((Object)other.address);
        }
    }
}

