/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization;

import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.ToolTipManager;
import org.jgrapht.Graph;
import org.jungrapht.visualization.DefaultVisualizationServer;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationModel;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.GraphMouseListener;
import org.jungrapht.visualization.control.ModalGraphMouse;
import org.jungrapht.visualization.control.MouseListenerTranslator;
import org.jungrapht.visualization.control.MultiSelectionStrategy;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.util.Pair;
import org.jungrapht.visualization.layout.model.LayoutModel;

class DefaultVisualizationViewer<V, E>
extends DefaultVisualizationServer<V, E>
implements VisualizationViewer<V, E> {
    protected Function<V, String> vertexToolTipFunction;
    protected Function<E, String> edgeToolTipFunction;
    protected Function<MouseEvent, String> mouseEventToolTipFunction;
    protected VisualizationViewer.GraphMouse graphMouse;
    protected Supplier<MultiSelectionStrategy> multiSelectionStrategySupplier;
    protected MouseListener requestFocusListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            DefaultVisualizationViewer.this.requestFocusInWindow();
        }
    };

    protected DefaultVisualizationViewer(VisualizationViewer.Builder builder) {
        this(builder.graph, builder.visualizationModel, builder.initialDimensionFunction, builder.graphMouse, builder.multiSelectionStrategySupplier, builder.layoutAlgorithm, builder.layoutSize, builder.viewSize);
    }

    protected DefaultVisualizationViewer(Graph<V, E> graph, VisualizationModel<V, E> visualizationModel, Function<Graph<V, ?>, Pair<Integer>> initialDimensionFunction, VisualizationViewer.GraphMouse graphMouse, Supplier<MultiSelectionStrategy> multiSelectionStrategySupplier, LayoutAlgorithm<V> layoutAlgorithm, Dimension layoutSize, Dimension viewSize) {
        super(graph, visualizationModel, initialDimensionFunction, layoutAlgorithm, layoutSize, viewSize);
        this.addMouseListener(this.requestFocusListener);
        this.setMultiSelectionStrategySupplier(multiSelectionStrategySupplier);
        this.setGraphMouse(graphMouse);
        if (graphMouse instanceof ModalGraphMouse) {
            this.addKeyListener(((ModalGraphMouse)graphMouse).getModeKeyListener());
        }
    }

    @Override
    public void setMultiSelectionStrategySupplier(Supplier<MultiSelectionStrategy> multiSelectionStrategySupplier) {
        this.multiSelectionStrategySupplier = multiSelectionStrategySupplier;
    }

    @Override
    public Supplier<MultiSelectionStrategy> getMultiSelectionStrategySupplier() {
        return this.multiSelectionStrategySupplier;
    }

    @Override
    public void setGraphMouse(VisualizationViewer.GraphMouse graphMouse) {
        MouseWheelListener[] mwl;
        MouseMotionListener[] mml;
        MouseListener[] ml;
        this.graphMouse = graphMouse;
        if (!this.graphMouse.isPluginsLoaded()) {
            this.graphMouse.loadPlugins();
        }
        for (MouseListener aMl : ml = this.getMouseListeners()) {
            if (!(aMl instanceof VisualizationViewer.GraphMouse)) continue;
            this.removeMouseListener(aMl);
        }
        for (MouseMotionListener aMml : mml = this.getMouseMotionListeners()) {
            if (!(aMml instanceof VisualizationViewer.GraphMouse)) continue;
            this.removeMouseMotionListener(aMml);
        }
        for (MouseWheelListener aMwl : mwl = this.getMouseWheelListeners()) {
            if (!(aMwl instanceof VisualizationViewer.GraphMouse)) continue;
            this.removeMouseWheelListener(aMwl);
        }
        this.addMouseListener(graphMouse);
        this.addMouseMotionListener(graphMouse);
        this.addMouseWheelListener(graphMouse);
        if (graphMouse instanceof ModalGraphMouse) {
            this.addKeyListener(((ModalGraphMouse)graphMouse).getModeKeyListener());
        }
    }

    @Override
    public VisualizationViewer.GraphMouse getGraphMouse() {
        return this.graphMouse;
    }

    @Override
    public void addGraphMouseListener(GraphMouseListener<V> graphMouseListener) {
        this.addMouseListener(new MouseListenerTranslator(graphMouseListener, this));
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
    }

    @Override
    public void setEdgeToolTipFunction(Function<E, String> edgeToolTipFunction) {
        this.edgeToolTipFunction = edgeToolTipFunction;
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public void setMouseEventToolTipFunction(Function<MouseEvent, String> mouseEventToolTipFunction) {
        this.mouseEventToolTipFunction = mouseEventToolTipFunction;
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public void setVertexToolTipFunction(Function<V, String> vertexToolTipFunction) {
        this.vertexToolTipFunction = vertexToolTipFunction;
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        LayoutModel layoutModel = this.getVisualizationModel().getLayoutModel();
        Point2D p = null;
        if (this.vertexToolTipFunction != null) {
            p = this.getTransformSupport().inverseTransform(this, event.getPoint());
            Object vertex = this.getPickSupport().getVertex(layoutModel, p.getX(), p.getY());
            if (vertex != null) {
                return this.vertexToolTipFunction.apply(vertex);
            }
        }
        if (this.edgeToolTipFunction != null) {
            Object edge;
            if (p == null) {
                p = this.renderContext.getMultiLayerTransformer().inverseTransform(MultiLayerTransformer.Layer.VIEW, event.getPoint());
            }
            if ((edge = this.getPickSupport().getEdge(layoutModel, p.getX(), p.getY())) != null) {
                return this.edgeToolTipFunction.apply(edge);
            }
        }
        if (this.mouseEventToolTipFunction != null) {
            return this.mouseEventToolTipFunction.apply(event);
        }
        return super.getToolTipText(event);
    }
}

