/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization;

import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jgrapht.Graph;
import org.jungrapht.visualization.DefaultVisualizationViewer;
import org.jungrapht.visualization.VisualizationModel;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.control.DefaultGraphMouse;
import org.jungrapht.visualization.control.GraphMouseListener;
import org.jungrapht.visualization.control.MultiSelectionStrategy;

public interface VisualizationViewer<V, E>
extends VisualizationServer<V, E> {
    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public static <V, E> Builder<V, E, ?, ?> builder(Graph<V, E> graph) {
        return new Builder(graph);
    }

    public static <V, E> Builder<V, E, ?, ?> builder(VisualizationModel<V, E> visualizationModel) {
        return new Builder(visualizationModel);
    }

    public void setGraphMouse(GraphMouse var1);

    public GraphMouse getGraphMouse();

    public void addGraphMouseListener(GraphMouseListener<V> var1);

    public void addKeyListener(KeyListener var1);

    public void setEdgeToolTipFunction(Function<E, String> var1);

    public void setMouseEventToolTipFunction(Function<MouseEvent, String> var1);

    public void setVertexToolTipFunction(Function<V, String> var1);

    public String getToolTipText(MouseEvent var1);

    public void setToolTipText(String var1);

    public Supplier<MultiSelectionStrategy> getMultiSelectionStrategySupplier();

    public void setMultiSelectionStrategySupplier(Supplier<MultiSelectionStrategy> var1);

    public static interface GraphMouse
    extends MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        default public void loadPlugins() {
        }

        default public void setPluginsLoaded() {
        }

        default public boolean isPluginsLoaded() {
            return false;
        }
    }

    public static class Builder<V, E, T extends DefaultVisualizationViewer<V, E>, B extends Builder<V, E, T, B>>
    extends VisualizationServer.Builder<V, E, T, B> {
        private static final String ARBITRARY_SHAPE_SELECTION = "jungrapht.arbitraryShapeSelection";
        protected GraphMouse graphMouse = new DefaultGraphMouse();
        protected Supplier<MultiSelectionStrategy> multiSelectionStrategySupplier = () -> Boolean.parseBoolean(System.getProperty(ARBITRARY_SHAPE_SELECTION, "false")) ? MultiSelectionStrategy.arbitrary() : MultiSelectionStrategy.rectangular();

        protected Builder() {
        }

        public B graphMouse(GraphMouse graphMouse) {
            this.graphMouse = graphMouse;
            return (B)((Builder)this.self());
        }

        public B multiSelectionStrategySupplier(Supplier<MultiSelectionStrategy> multiSelectionStrategySupplier) {
            this.multiSelectionStrategySupplier = multiSelectionStrategySupplier;
            return (B)((Builder)this.self());
        }

        protected Builder(Graph<V, E> graph) {
            super(graph);
        }

        protected Builder(VisualizationModel<V, E> visualizationModel) {
            super(visualizationModel);
        }

        @Override
        public T build() {
            return (T)new DefaultVisualizationViewer(this);
        }
    }
}

