/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.annotations;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Set;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.util.ArrowFactory;

public class SelectedVertexPaintable<V>
implements VisualizationServer.Paintable {
    private final VisualizationServer<V, ?> visualizationServer;
    private Shape selectionShape;
    private Paint selectionPaint;

    public static <V> Builder<V> builder(VisualizationServer<V, ?> visualizationServer) {
        return new Builder<V>(visualizationServer);
    }

    private SelectedVertexPaintable(Builder<V> builder) {
        this(builder.visualizationServer, builder.selectionShape, builder.selectionPaint);
    }

    private SelectedVertexPaintable(VisualizationServer<V, ?> visualizationServer, Shape shape, Paint selectionPaint) {
        this.visualizationServer = visualizationServer;
        this.selectionShape = shape;
        this.selectionPaint = selectionPaint;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Paint oldPaint = g2d.getPaint();
        AffineTransform oldTransform = g2d.getTransform();
        g2d.setPaint(this.selectionPaint);
        g2d.setTransform(new AffineTransform());
        Set selectedVertices = this.visualizationServer.getSelectedVertexState().getSelected();
        LayoutModel<V> layoutModel = this.visualizationServer.getVisualizationModel().getLayoutModel();
        MultiLayerTransformer multiLayerTransformer = this.visualizationServer.getRenderContext().getMultiLayerTransformer();
        for (Object vertex : selectedVertices) {
            Point location = (Point)layoutModel.apply(vertex);
            Point2D viewLocation = multiLayerTransformer.transform(location.x, location.y);
            AffineTransform rotationTransform = AffineTransform.getRotateInstance(2.356194490192345);
            AffineTransform translateTransform = AffineTransform.getTranslateInstance(viewLocation.getX(), viewLocation.getY());
            AffineTransform transform = new AffineTransform();
            transform.concatenate(translateTransform);
            transform.concatenate(rotationTransform);
            Shape shape = transform.createTransformedShape(this.selectionShape);
            g2d.draw(shape);
            g2d.fill(shape);
        }
        g2d.setPaint(oldPaint);
        g2d.setTransform(oldTransform);
    }

    @Override
    public boolean useTransform() {
        return false;
    }

    public static class Builder<V> {
        private final VisualizationServer<V, ?> visualizationServer;
        private Shape selectionShape = ArrowFactory.getNotchedArrow(20.0f, 24.0f, 8.0f);
        private Paint selectionPaint = Color.red;

        public Builder selectionShape(Shape selectionShape) {
            this.selectionShape = selectionShape;
            return this;
        }

        public Builder selectionPaint(Paint selectionPaint) {
            this.selectionPaint = selectionPaint;
            return this;
        }

        public SelectedVertexPaintable<V> build() {
            return new SelectedVertexPaintable(this);
        }

        private Builder(VisualizationServer<V, ?> visualizationServer) {
            this.visualizationServer = visualizationServer;
        }
    }
}

