/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.GraphMousePlugin;

public class PluggableGraphMouse
implements VisualizationViewer.GraphMouse {
    MouseListener[] mouseListeners;
    MouseMotionListener[] mouseMotionListeners;
    MouseWheelListener[] mouseWheelListeners;
    Set<GraphMousePlugin> mousePluginList = new LinkedHashSet<GraphMousePlugin>();
    Set<MouseMotionListener> mouseMotionPluginList = new LinkedHashSet<MouseMotionListener>();
    Set<MouseWheelListener> mouseWheelPluginList = new LinkedHashSet<MouseWheelListener>();

    public void add(GraphMousePlugin plugin) {
        if (plugin instanceof MouseListener) {
            this.mousePluginList.add(plugin);
            this.mouseListeners = null;
        }
        if (plugin instanceof MouseMotionListener) {
            this.mouseMotionPluginList.add((MouseMotionListener)((Object)plugin));
            this.mouseMotionListeners = null;
        }
        if (plugin instanceof MouseWheelListener) {
            this.mouseWheelPluginList.add((MouseWheelListener)((Object)plugin));
            this.mouseWheelListeners = null;
        }
    }

    public void remove(GraphMousePlugin plugin) {
        boolean wasThere;
        if (plugin instanceof MouseListener && (wasThere = this.mousePluginList.remove(plugin))) {
            this.mouseListeners = null;
        }
        if (plugin instanceof MouseMotionListener && (wasThere = this.mouseMotionPluginList.remove(plugin))) {
            this.mouseMotionListeners = null;
        }
        if (plugin instanceof MouseWheelListener && (wasThere = this.mouseWheelPluginList.remove(plugin))) {
            this.mouseWheelListeners = null;
        }
    }

    private void checkMouseListeners() {
        if (this.mouseListeners == null) {
            this.mouseListeners = this.mousePluginList.toArray(new MouseListener[0]);
        }
    }

    private void checkMouseMotionListeners() {
        if (this.mouseMotionListeners == null) {
            this.mouseMotionListeners = this.mouseMotionPluginList.toArray(new MouseMotionListener[0]);
        }
    }

    private void checkMouseWheelListeners() {
        if (this.mouseWheelListeners == null) {
            this.mouseWheelListeners = this.mouseWheelPluginList.toArray(new MouseWheelListener[0]);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.checkMouseListeners();
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mouseClicked(e);
            if (e.isConsumed()) break;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkMouseListeners();
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mousePressed(e);
            if (e.isConsumed()) break;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkMouseListeners();
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mouseReleased(e);
            if (e.isConsumed()) break;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.checkMouseListeners();
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mouseEntered(e);
            if (e.isConsumed()) break;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.checkMouseListeners();
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mouseExited(e);
            if (e.isConsumed()) break;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.checkMouseMotionListeners();
        for (MouseMotionListener mouseMotionListener : this.mouseMotionListeners) {
            mouseMotionListener.mouseDragged(e);
            if (e.isConsumed()) break;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.checkMouseMotionListeners();
        for (MouseMotionListener mouseMotionListener : this.mouseMotionListeners) {
            mouseMotionListener.mouseMoved(e);
            if (e.isConsumed()) break;
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.checkMouseWheelListeners();
        for (MouseWheelListener mouseWheelListener : this.mouseWheelListeners) {
            mouseWheelListener.mouseWheelMoved(e);
            if (e.isConsumed()) break;
        }
    }
}

