/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.SatelliteVisualizationViewer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AnimatedPickingGraphMousePlugin;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;

public class SatelliteAnimatedPickingGraphMousePlugin<V, E>
extends AnimatedPickingGraphMousePlugin<V, E>
implements MouseListener,
MouseMotionListener {
    public SatelliteAnimatedPickingGraphMousePlugin() {
        this(1152);
    }

    public SatelliteAnimatedPickingGraphMousePlugin(int selectionModifiers) {
        super(selectionModifiers);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        VisualizationViewer vv;
        if (e.getModifiersEx() == this.modifiers && (vv = (VisualizationViewer)e.getSource()) instanceof SatelliteVisualizationViewer) {
            VisualizationViewer vvMaster = ((SatelliteVisualizationViewer)vv).getMaster();
            if (this.vertex != null) {
                LayoutModel layoutModel = vvMaster.getVisualizationModel().getLayoutModel();
                Point q = (Point)layoutModel.apply(this.vertex);
                Point2D lvc = vvMaster.getRenderContext().getMultiLayerTransformer().inverseTransform(MultiLayerTransformer.Layer.LAYOUT, vvMaster.getCenter());
                double dx = (lvc.getX() - q.x) / 10.0;
                double dy = (lvc.getY() - q.y) / 10.0;
                Runnable animator = () -> {
                    for (int i = 0; i < 10; ++i) {
                        vvMaster.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT).translate(dx, dy);
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                };
                Thread thread = new Thread(animator);
                thread.start();
            }
        }
    }
}

