/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.event.MouseWheelEvent;
import org.jungrapht.visualization.SatelliteVisualizationViewer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.ScalingControl;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;

public class SatelliteScalingGraphMousePlugin
extends ScalingGraphMousePlugin {
    public SatelliteScalingGraphMousePlugin(ScalingControl scaler, int modifiers) {
        super(scaler, modifiers);
    }

    public SatelliteScalingGraphMousePlugin(ScalingControl scaler, int modifiers, float in, float out) {
        super(scaler, modifiers, in, out);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            VisualizationViewer vv;
            ScalingControl scalingControl = this.scaler;
            float xin = this.in;
            float yin = this.in;
            float xout = this.out;
            float yout = this.out;
            if ((e.getModifiersEx() & 0x80) == 128) {
                yout = 1.0f;
                yin = 1.0f;
                scalingControl = this.layoutScalingControl;
            }
            if ((e.getModifiersEx() & 0x200) == 512) {
                xout = 1.0f;
                xin = 1.0f;
                scalingControl = this.layoutScalingControl;
            }
            if ((vv = (VisualizationViewer)e.getSource()) instanceof SatelliteVisualizationViewer) {
                VisualizationViewer vvMaster = ((SatelliteVisualizationViewer)vv).getMaster();
                int amount = e.getWheelRotation();
                if (amount < 0) {
                    scalingControl.scale(vvMaster, xin, yin, vvMaster.getCenter());
                } else if (amount > 0) {
                    scalingControl.scale(vvMaster, xout, yout, vvMaster.getCenter());
                }
                e.consume();
                vv.repaint();
            }
        }
    }
}

