/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.SatelliteVisualizationViewer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.TranslatingGraphMousePlugin;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.jungrapht.visualization.util.AWT;
import org.jungrapht.visualization.util.VertexLocationAnimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SatelliteTranslatingGraphMousePlugin
extends TranslatingGraphMousePlugin {
    private static final Logger log = LoggerFactory.getLogger(SatelliteTranslatingGraphMousePlugin.class);

    public SatelliteTranslatingGraphMousePlugin() {
    }

    public SatelliteTranslatingGraphMousePlugin(int modifiers) {
        super(modifiers);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        VisualizationViewer vvMaster = ((SatelliteVisualizationViewer)vv).getMaster();
        Point p = e.getPoint();
        Point2D layoutPoint = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(p);
        VertexLocationAnimator.jumpPointToCenter(vvMaster, AWT.convert(layoutPoint));
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            if (vv instanceof SatelliteVisualizationViewer) {
                VisualizationViewer vvMaster = ((SatelliteVisualizationViewer)vv).getMaster();
                MutableTransformer modelTransformerMaster = vvMaster.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
                vv.setCursor(Cursor.getPredefinedCursor(13));
                try {
                    Point2D q = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(this.down);
                    Point2D p = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(e.getPoint());
                    float dx = (float)(p.getX() - q.getX());
                    float dy = (float)(p.getY() - q.getY());
                    modelTransformerMaster.translate(-dx, -dy);
                    this.down.x = e.getX();
                    this.down.y = e.getY();
                }
                catch (RuntimeException ex) {
                    log.error("down = {}, e = {}", (Object)this.down, (Object)e);
                    throw ex;
                }
            }
            e.consume();
        }
    }
}

