/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.jungrapht.visualization.control.LayoutScalingControl;
import org.jungrapht.visualization.control.ScalingControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalingGraphMousePlugin
extends AbstractGraphMousePlugin
implements MouseWheelListener {
    private static final Logger log = LoggerFactory.getLogger(ScalingGraphMousePlugin.class);
    protected float in = 1.1f;
    protected float out = 0.9090909f;
    protected boolean zoomAtMouse = true;
    protected ScalingControl scaler;
    protected ScalingControl layoutScalingControl = new LayoutScalingControl();

    public ScalingGraphMousePlugin(ScalingControl scaler, int modifiers) {
        this(scaler, modifiers, 1.1f, 0.9090909f);
    }

    public ScalingGraphMousePlugin(ScalingControl scaler, int modifiers, float in, float out) {
        super(modifiers);
        this.scaler = scaler;
        this.in = in;
        this.out = out;
    }

    public void setZoomAtMouse(boolean zoomAtMouse) {
        this.zoomAtMouse = zoomAtMouse;
    }

    @Override
    public boolean checkModifiers(MouseEvent e) {
        return e.getModifiersEx() == this.modifiers || (e.getModifiersEx() & this.modifiers) != 0 || e.getModifiersEx() == 128 || e.getModifiersEx() == 512;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            ScalingControl scalingControl = this.scaler;
            float xin = this.in;
            float yin = this.in;
            float xout = this.out;
            float yout = this.out;
            if ((e.getModifiersEx() & 0x80) == 128) {
                yout = 1.0f;
                yin = 1.0f;
                scalingControl = this.layoutScalingControl;
            }
            if ((e.getModifiersEx() & 0x200) == 512) {
                xout = 1.0f;
                xin = 1.0f;
                scalingControl = this.layoutScalingControl;
            }
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            Point mouse = e.getPoint();
            int amount = e.getWheelRotation();
            if (this.zoomAtMouse) {
                if (amount < 0) {
                    scalingControl.scale(vv, xin, yin, mouse);
                } else if (amount > 0) {
                    scalingControl.scale(vv, xout, yout, mouse);
                }
            } else {
                Point2D center = vv.getCenter();
                if (amount < 0) {
                    scalingControl.scale(vv, xin, yin, center);
                } else if (amount > 0) {
                    scalingControl.scale(vv, xout, yout, center);
                }
            }
            e.consume();
            vv.repaint();
        }
    }

    public float getIn() {
        return this.in;
    }

    public void setIn(float in) {
        this.in = in;
    }

    public float getOut() {
        return this.out;
    }

    public void setOut(float out) {
        this.out = out;
    }

    public ScalingControl getScaler() {
        return this.scaler;
    }

    public void setScaler(ScalingControl scaler) {
        this.scaler = scaler;
    }
}

