/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import javax.swing.JComponent;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationModel;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.control.MultiSelectionStrategy;
import org.jungrapht.visualization.control.TransformSupport;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.selection.MutableSelectedState;
import org.jungrapht.visualization.selection.ShapePickSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectingGraphMousePlugin<V, E>
extends AbstractGraphMousePlugin.Selecting
implements MouseListener,
MouseMotionListener {
    private static final Logger log = LoggerFactory.getLogger(SelectingGraphMousePlugin.class);
    private static final int TOO_CLOSE_LIMIT = 5;
    private static final String PICK_AREA_SIZE = "jungrapht.pickAreaSize";
    protected int pickSize = Integer.getInteger("jungrapht.pickAreaSize", 4);
    protected V vertex;
    protected E edge;
    protected boolean locked;
    protected int selectionModifiers;
    protected int addToSelectionModifiers;
    protected Shape viewRectangle;
    protected Shape layoutTargetShape = this.viewRectangle = new Rectangle2D.Float();
    protected VisualizationServer.Paintable lensPaintable;
    protected Rectangle2D footprintRectangle = new Rectangle2D.Float();
    protected VisualizationServer.Paintable pickFootprintPaintable;
    protected Color lensColor = Color.cyan;
    protected Point2D deltaDown;
    protected MultiSelectionStrategy multiSelectionStrategy;

    public SelectingGraphMousePlugin() {
        this(1024, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), 64);
    }

    public SelectingGraphMousePlugin(int modifiers, int selectionModifiers, int addToSelectionModifiers) {
        super(modifiers);
        this.selectionModifiers = selectionModifiers;
        this.addToSelectionModifiers = addToSelectionModifiers;
        this.lensPaintable = new LensPaintable();
        this.pickFootprintPaintable = new FootprintPaintable();
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    public Color getLensColor() {
        return this.lensColor;
    }

    public void setLensColor(Color lensColor) {
        this.lensColor = lensColor;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.down = e.getPoint();
        log.trace("mouse pick at screen coords {}", (Object)e.getPoint());
        this.deltaDown = this.down;
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        this.multiSelectionStrategy = vv.getMultiSelectionStrategySupplier().get();
        TransformSupport transformSupport = vv.getTransformSupport();
        LayoutModel layoutModel = vv.getVisualizationModel().getLayoutModel();
        GraphElementAccessor pickSupport = vv.getPickSupport();
        MutableSelectedState selectedVertexState = vv.getSelectedVertexState();
        MutableSelectedState selectedEdgeState = vv.getSelectedEdgeState();
        this.viewRectangle = this.multiSelectionStrategy.getInitialShape(e.getPoint());
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        this.footprintRectangle = new Rectangle2D.Float((float)e.getPoint().x - (float)(this.pickSize / 2), (float)e.getPoint().y - (float)(this.pickSize / 2), this.pickSize, this.pickSize);
        vv.addPostRenderPaintable(this.pickFootprintPaintable);
        vv.repaint();
        this.updatePickingTargets(vv, multiLayerTransformer, this.down, this.down);
        Point2D layoutPoint = transformSupport.inverseTransform(vv, this.down);
        log.trace("layout coords of mouse click {}", (Object)layoutPoint);
        if (e.getModifiersEx() == (this.modifiers | this.selectionModifiers)) {
            ShapePickSupport shapePickSupport;
            if (pickSupport instanceof ShapePickSupport) {
                shapePickSupport = (ShapePickSupport)pickSupport;
                this.vertex = shapePickSupport.getVertex(layoutModel, this.footprintRectangle);
            } else {
                this.vertex = pickSupport.getVertex(layoutModel, layoutPoint.getX(), layoutPoint.getY());
            }
            if (this.vertex != null) {
                log.trace("mousePressed set the vertex to {}", this.vertex);
                if (!selectedVertexState.isSelected(this.vertex)) {
                    selectedVertexState.clear();
                    selectedVertexState.select(this.vertex);
                }
                e.consume();
                return;
            }
            if (pickSupport instanceof ShapePickSupport) {
                shapePickSupport = (ShapePickSupport)pickSupport;
                this.edge = shapePickSupport.getEdge(layoutModel, this.footprintRectangle);
            } else {
                this.edge = pickSupport.getEdge(layoutModel, layoutPoint.getX(), layoutPoint.getY());
            }
            if (this.edge != null) {
                log.trace("mousePressed set the edge to {}", this.edge);
                if (!selectedEdgeState.isSelected(this.edge)) {
                    selectedEdgeState.clear();
                    selectedEdgeState.select(this.edge);
                }
                e.consume();
                return;
            }
            selectedEdgeState.clear();
            selectedVertexState.clear();
            vv.addPostRenderPaintable(this.lensPaintable);
            return;
        }
        if (e.getModifiersEx() == (this.modifiers | this.selectionModifiers | this.addToSelectionModifiers)) {
            vv.addPostRenderPaintable(this.lensPaintable);
            this.vertex = pickSupport.getVertex(layoutModel, layoutPoint.getX(), layoutPoint.getY());
            if (this.vertex != null) {
                log.trace("mousePressed set the vertex to {}", this.vertex);
                if (selectedVertexState.isSelected(this.vertex)) {
                    selectedVertexState.deselect(this.vertex);
                } else {
                    selectedVertexState.select(this.vertex);
                }
                e.consume();
                return;
            }
            this.edge = pickSupport.getEdge(layoutModel, layoutPoint.getX(), layoutPoint.getY());
            if (this.edge != null) {
                log.trace("mousePressed set the edge to {}", this.edge);
                if (selectedEdgeState.isSelected(this.edge)) {
                    selectedEdgeState.deselect(this.edge);
                } else {
                    selectedEdgeState.select(this.edge);
                }
                e.consume();
                return;
            }
        } else {
            this.down = null;
        }
        if (this.vertex != null) {
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        java.awt.Point out = e.getPoint();
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        if (e.getModifiersEx() == (this.selectionModifiers | this.addToSelectionModifiers)) {
            if (this.down != null && this.vertex == null && this.multiSelectionMayProceed(this.layoutTargetShape.getBounds2D())) {
                this.pickContainedVertices(vv, this.layoutTargetShape, false);
            }
        } else if (e.getModifiersEx() == this.selectionModifiers && this.down != null && this.vertex == null && this.multiSelectionMayProceed(this.layoutTargetShape.getBounds2D())) {
            this.pickContainedVertices(vv, this.layoutTargetShape, true);
        }
        log.trace("down:{} out:{}", (Object)this.down, (Object)out);
        if (this.vertex != null && !this.down.equals(out)) {
            this.multiSelectionStrategy.closeShape();
            Point2D graphPoint = multiLayerTransformer.inverseTransform(out);
            log.trace("p in graph coords is {}", (Object)graphPoint);
            Point2D graphDown = multiLayerTransformer.inverseTransform(this.deltaDown);
            log.trace("graphDown (down in graph coords) is {}", (Object)graphDown);
            VisualizationModel visualizationModel = vv.getVisualizationModel();
            LayoutModel layoutModel = visualizationModel.getLayoutModel();
            double dx = graphPoint.getX() - graphDown.getX();
            double dy = graphPoint.getY() - graphDown.getY();
            log.trace("dx, dy: {},{}", (Object)dx, (Object)dy);
            MutableSelectedState ps = vv.getSelectedVertexState();
            for (Object v : ps.getSelected()) {
                Point vp = (Point)layoutModel.apply(v);
                vp = vp.add(dx, dy);
                layoutModel.set(v, vp);
            }
            this.deltaDown = out;
        }
        this.down = null;
        this.vertex = null;
        this.edge = null;
        this.layoutTargetShape = multiLayerTransformer.inverseTransform(this.viewRectangle);
        vv.removePostRenderPaintable(this.lensPaintable);
        vv.removePostRenderPaintable(this.pickFootprintPaintable);
        vv.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        log.trace("mouseDragged");
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        if (!this.locked) {
            MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
            java.awt.Point p = e.getPoint();
            log.trace("view p for drag event is {}", (Object)p);
            log.trace("down is {}", (Object)this.down);
            if (this.vertex != null) {
                Point2D graphPoint = multiLayerTransformer.inverseTransform(p);
                log.trace("p in graph coords is {}", (Object)graphPoint);
                Point2D graphDown = multiLayerTransformer.inverseTransform(this.deltaDown);
                log.trace("graphDown (down in graph coords) is {}", (Object)graphDown);
                VisualizationModel visualizationModel = vv.getVisualizationModel();
                LayoutModel layoutModel = visualizationModel.getLayoutModel();
                double dx = graphPoint.getX() - graphDown.getX();
                double dy = graphPoint.getY() - graphDown.getY();
                log.trace("dx, dy: {},{}", (Object)dx, (Object)dy);
                MutableSelectedState ps = vv.getSelectedVertexState();
                for (Object v : ps.getSelected()) {
                    Point vp = (Point)layoutModel.apply(v);
                    vp = vp.add(dx, dy);
                    layoutModel.set(v, vp);
                }
                this.deltaDown = p;
            } else if (this.down != null) {
                java.awt.Point out = e.getPoint();
                this.multiSelectionStrategy.updateShape(this.down, out);
                this.layoutTargetShape = multiLayerTransformer.inverseTransform(this.viewRectangle);
            }
            if (this.vertex != null) {
                e.consume();
            }
            vv.repaint();
        }
    }

    private boolean tooClose(Point2D p, Point2D q) {
        return Math.abs(p.getX() - q.getX()) < 5.0 && Math.abs(p.getY() - q.getY()) < 5.0;
    }

    private boolean multiSelectionMayProceed(Rectangle2D targetShape) {
        return !targetShape.isEmpty();
    }

    protected Point2D inverseTransform(VisualizationViewer<V, E> vv, Point2D p) {
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        return multiLayerTransformer.inverseTransform(p);
    }

    protected Shape transform(VisualizationViewer<V, E> vv, Shape shape) {
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        return multiLayerTransformer.transform(shape);
    }

    protected void updatePickingTargets(VisualizationViewer vv, MultiLayerTransformer multiLayerTransformer, Point2D down, Point2D out) {
        this.multiSelectionStrategy.updateShape(down, down);
        this.layoutTargetShape = multiLayerTransformer.inverseTransform(this.viewRectangle);
    }

    protected void pickContainedVertices(VisualizationViewer<V, E> vv, Shape pickTarget, boolean clear) {
        MutableSelectedState selectedVertexState = vv.getSelectedVertexState();
        GraphElementAccessor pickSupport = vv.getPickSupport();
        LayoutModel layoutModel = vv.getVisualizationModel().getLayoutModel();
        Collection picked = pickSupport.getVertices(layoutModel, pickTarget);
        if (clear) {
            selectedVertexState.clear();
        }
        selectedVertexState.select(picked);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(this.cursor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    class FootprintPaintable
    implements VisualizationServer.Paintable {
        FootprintPaintable() {
        }

        @Override
        public void paint(Graphics g) {
            Color oldColor = g.getColor();
            g.setColor(SelectingGraphMousePlugin.this.lensColor);
            ((Graphics2D)g).draw(SelectingGraphMousePlugin.this.footprintRectangle);
            g.setColor(oldColor);
        }

        @Override
        public boolean useTransform() {
            return true;
        }
    }

    class LensPaintable
    implements VisualizationServer.Paintable {
        LensPaintable() {
        }

        @Override
        public void paint(Graphics g) {
            Color oldColor = g.getColor();
            g.setColor(SelectingGraphMousePlugin.this.lensColor);
            ((Graphics2D)g).draw(SelectingGraphMousePlugin.this.viewRectangle);
            g.setColor(oldColor);
        }

        @Override
        public boolean useTransform() {
            return false;
        }
    }
}

