/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewTranslatingGraphMousePlugin
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    private static final Logger log = LoggerFactory.getLogger(ViewTranslatingGraphMousePlugin.class);

    public ViewTranslatingGraphMousePlugin() {
        this(1024);
    }

    public ViewTranslatingGraphMousePlugin(int modifiers) {
        super(modifiers);
        this.cursor = Cursor.getPredefinedCursor(13);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        this.down = e.getPoint();
        if (accepted) {
            vv.setCursor(this.cursor);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        this.down = null;
        vv.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            MutableTransformer viewTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW);
            vv.setCursor(this.cursor);
            try {
                Point2D q = viewTransformer.inverseTransform(this.down);
                Point2D p = viewTransformer.inverseTransform(e.getPoint());
                float dx = (float)(p.getX() - q.getX());
                float dy = (float)(p.getY() - q.getY());
                viewTransformer.translate(dx, dy);
                this.down.x = e.getX();
                this.down.y = e.getY();
            }
            catch (RuntimeException ex) {
                log.error("down = {}, e = {}", (Object)this.down, (Object)e);
                throw ex;
            }
            e.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

