/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.decorators;

import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jungrapht.visualization.util.ImageShapeUtils;

public class IconShapeFunction<T>
implements Function<T, Shape> {
    protected Map<Image, Shape> shapeMap = new HashMap<Image, Shape>();
    protected Function<T, Icon> iconFunction;
    protected Function<Image, Shape> shapeFunction = this.shapeMap::get;
    protected Function<T, Shape> delegate;

    public IconShapeFunction(Function<T, Shape> delegate) {
        this.delegate = delegate;
    }

    public Function<T, Shape> getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Function<T, Shape> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Shape apply(T t) {
        Icon icon = this.iconFunction.apply(t);
        if (icon instanceof ImageIcon) {
            Image image = ((ImageIcon)icon).getImage();
            Shape shape = this.shapeMap.get(image);
            if (shape == null && (shape = ImageShapeUtils.getShape(image, 30)).getBounds().getWidth() > 0.0 && shape.getBounds().getHeight() > 0.0) {
                int width = image.getWidth(null);
                int height = image.getHeight(null);
                AffineTransform transform = AffineTransform.getTranslateInstance(-width / 2, -height / 2);
                shape = transform.createTransformedShape(shape);
                this.shapeMap.put(image, shape);
            }
            return shape;
        }
        return this.delegate.apply(t);
    }

    public void setIconFunction(Function<T, Icon> iconFunction) {
        this.iconFunction = iconFunction;
    }

    public Function<Image, Shape> getShapeFunction() {
        return this.shapeFunction::apply;
    }

    public void setShapeFunction(Function<Image, Shape> shapeFunction) {
        this.shapeFunction = shapeFunction;
    }
}

