/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.renderers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jgrapht.Graph;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.decorators.ArticulatedEdgeShapeFunction;
import org.jungrapht.visualization.decorators.EdgeShape;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.transform.shape.GraphicsDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeayweightEdgeLabelRenderer<V, E>
implements Renderer.EdgeLabel<V, E> {
    private static final Logger log = LoggerFactory.getLogger(HeayweightEdgeLabelRenderer.class);

    public Component prepareRenderer(RenderContext<V, E> renderContext, Object value, boolean isSelected, E edge) {
        return renderContext.getEdgeLabelRenderer().getEdgeLabelRendererComponent(renderContext.getScreenDevice(), value, renderContext.getEdgeFontFunction().apply(edge), isSelected, edge);
    }

    @Override
    public void labelEdge(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e, String label) {
        Shape edgeShape;
        ArticulatedEdgeShapeFunction articulatedEdgeShapeFunction;
        Function edgeArticulationFunction;
        if (label == null || label.length() == 0) {
            return;
        }
        Object v1 = layoutModel.getGraph().getEdgeSource(e);
        Object v2 = layoutModel.getGraph().getEdgeTarget(e);
        Predicate<V> vertexIncludePredicate = renderContext.getVertexIncludePredicate();
        if (!vertexIncludePredicate.test(v1) || !vertexIncludePredicate.test(v2)) {
            return;
        }
        Point p1 = (Point)layoutModel.apply(v1);
        Point p2 = (Point)layoutModel.apply(v2);
        BiFunction<Graph<V, E>, E, Shape> edgeShapeFunction = renderContext.getEdgeShapeFunction();
        if (edgeShapeFunction instanceof ArticulatedEdgeShapeFunction && (edgeArticulationFunction = (articulatedEdgeShapeFunction = (ArticulatedEdgeShapeFunction)edgeShapeFunction).getEdgeArticulationFunction()).apply(e).size() > 0 && (edgeShape = this.getArticulatedEdgeShape(renderContext, layoutModel, e)) instanceof Path2D) {
            float[] seg = new float[6];
            Path2D path = (Path2D)edgeShape;
            PathIterator i = path.getPathIterator(null, 1.0);
            while (!i.isDone()) {
                int ret = i.currentSegment(seg);
                if (ret == 1) {
                    log.trace("p2 was {} now {}", (Object)p2, (Object)Point.of((double)seg[0], (double)seg[1]));
                    p2 = Point.of((double)seg[0], (double)seg[1]);
                    break;
                }
                i.next();
            }
        }
        Point2D p2d1 = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, p1.x, p1.y);
        Point2D p2d2 = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, p2.x, p2.y);
        float x1 = (float)p2d1.getX();
        float y1 = (float)p2d1.getY();
        float x2 = (float)p2d2.getX();
        float y2 = (float)p2d2.getY();
        GraphicsDecorator g = renderContext.getGraphicsContext();
        float distX = x2 - x1;
        float distY = y2 - y1;
        double totalLength = Math.sqrt(distX * distX + distY * distY);
        float closeness = renderContext.getEdgeLabelCloseness();
        int posX = (int)(x1 + closeness * distX);
        int posY = (int)(y1 + closeness * distY);
        int xDisplacement = (int)((double)renderContext.getLabelOffset() * ((double)distY / totalLength));
        int yDisplacement = (int)((double)renderContext.getLabelOffset() * ((double)(-distX) / totalLength));
        Component component = this.prepareRenderer(renderContext, label, renderContext.getSelectedEdgeState().isSelected(e), e);
        Dimension d = component.getPreferredSize();
        Shape edgeShape2 = renderContext.getEdgeShapeFunction().apply(layoutModel.getGraph(), e);
        double parallelOffset = 1.0;
        parallelOffset += (double)renderContext.getParallelEdgeIndexFunction().apply(layoutModel.getGraph(), e).intValue();
        parallelOffset *= (double)d.height;
        if (edgeShape2 instanceof Ellipse2D) {
            parallelOffset += edgeShape2.getBounds().getHeight();
            parallelOffset = -parallelOffset;
        }
        AffineTransform old = g.getTransform();
        AffineTransform xform = new AffineTransform(old);
        xform.translate(posX + xDisplacement, posY + yDisplacement);
        double dx = x2 - x1;
        double dy = y2 - y1;
        if (renderContext.getEdgeLabelRenderer().isRotateEdgeLabels()) {
            double theta = Math.atan2(dy, dx);
            if (dx < 0.0) {
                theta += Math.PI;
            }
            xform.rotate(theta);
        }
        if (dx < 0.0) {
            parallelOffset = -parallelOffset;
        }
        xform.translate(-d.width / 2, -((double)d.height / 2.0 - parallelOffset));
        g.setTransform(xform);
        g.draw(component, renderContext.getRendererPane(), 0, 0, d.width, d.height, true);
        g.setTransform(old);
    }

    private Shape getArticulatedEdgeShape(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e) {
        Object v1 = layoutModel.getGraph().getEdgeSource(e);
        Object v2 = layoutModel.getGraph().getEdgeTarget(e);
        Point p1 = (Point)layoutModel.apply(v1);
        Point p2 = (Point)layoutModel.apply(v2);
        float x1 = (float)p1.x;
        float y1 = (float)p1.y;
        float x2 = (float)p2.x;
        float y2 = (float)p2.y;
        Shape s2 = renderContext.getVertexShapeFunction().apply(v2);
        BiFunction<Graph<V, E>, E, Shape> edgeShapeFunction = renderContext.getEdgeShapeFunction();
        Shape edgeShape = edgeShapeFunction instanceof EdgeShape.ArticulatedLine ? renderContext.getEdgeShapeFunction().apply(layoutModel.getGraph(), e) : EdgeShape.line().apply(layoutModel.getGraph(), e);
        AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
        float dx = x2 - x1;
        float dy = y2 - y1;
        float thetaRadians = (float)Math.atan2(dy, dx);
        xform.rotate(thetaRadians);
        float dist = (float)Math.sqrt(dx * dx + dy * dy);
        if (edgeShape instanceof Path2D) {
            xform.scale(dist, dist);
        } else {
            xform.scale(dist, 1.0);
        }
        return xform.createTransformedShape(edgeShape);
    }
}

