/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.spatial;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jungrapht.visualization.VisualizationModel;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.layout.event.LayoutVertexPositionChange;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.spatial.AbstractSpatial;
import org.jungrapht.visualization.spatial.Spatial;
import org.jungrapht.visualization.spatial.rtree.LeafNode;
import org.jungrapht.visualization.spatial.rtree.Node;
import org.jungrapht.visualization.spatial.rtree.RTree;
import org.jungrapht.visualization.spatial.rtree.SplitterContext;
import org.jungrapht.visualization.spatial.rtree.TreeNode;
import org.jungrapht.visualization.util.BoundingRectangleCollector;
import org.jungrapht.visualization.util.RadiusGraphElementAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpatialRTree<T, NT>
extends AbstractSpatial<T, NT>
implements Spatial<T> {
    private static final Logger log = LoggerFactory.getLogger(SpatialRTree.class);
    protected SplitterContext<T> splitterContext;
    protected RTree<T> rtree;
    protected BoundingRectangleCollector<T> boundingRectangleCollector;
    protected boolean reinsert;

    protected SpatialRTree(LayoutModel<NT> layoutModel, SplitterContext<T> splitterContext, boolean reinsert) {
        super(layoutModel);
        this.splitterContext = splitterContext;
        this.reinsert = reinsert;
    }

    public boolean isReinsert() {
        return this.reinsert;
    }

    public void setReinsert(boolean reinsert) {
        this.reinsert = reinsert;
    }

    protected abstract List<Shape> collectGrids(List<Shape> var1, RTree<T> var2);

    @Override
    public Rectangle2D getLayoutArea() {
        return this.rectangle;
    }

    @Override
    public void setBounds(Rectangle2D bounds) {
        this.rectangle = bounds;
    }

    @Override
    public List<Shape> getGrid() {
        if (this.gridCache == null) {
            if (log.isTraceEnabled()) {
                log.trace("getting Grid from tree size {}", (Object)this.rtree.count());
            }
            if (!this.isActive()) {
                return Collections.singletonList(this.getLayoutArea());
            }
            ArrayList<Shape> areas = new ArrayList<Shape>();
            this.gridCache = this.collectGrids(areas, this.rtree);
            if (log.isTraceEnabled()) {
                log.trace("getGrid got {} and {}", (Object)areas.size(), (Object)this.gridCache.size());
            }
            return this.gridCache;
        }
        return this.gridCache;
    }

    @Override
    public void clear() {
        this.rtree = RTree.create();
    }

    @Override
    public Set<LeafNode<T>> getContainingLeafs(double x, double y) {
        if (!this.isActive() || this.rtree.getRoot().isEmpty()) {
            return Collections.emptySet();
        }
        Node theRoot = this.rtree.getRoot().get();
        return theRoot.getContainingLeafs(new HashSet(), x, y);
    }

    @Override
    public Set<LeafNode<T>> getContainingLeafs(Point2D p) {
        return this.getContainingLeafs(p.getX(), p.getY());
    }

    @Override
    public LeafNode<T> getContainingLeaf(Object element) {
        if (this.rtree.getRoot().isEmpty()) {
            return null;
        }
        Node<Object> theRoot = this.rtree.getRoot().get();
        return theRoot.getContainingLeaf(element);
    }

    protected void recalculate(Collection<T> elements) {
        try {
            log.trace("start recalculate");
            this.clear();
            if (this.boundingRectangleCollector != null) {
                for (T element : elements) {
                    this.rtree = RTree.add(this.rtree, this.splitterContext, element, this.boundingRectangleCollector.getForElement(element));
                    if (!log.isTraceEnabled()) continue;
                    log.trace("added {} got {} nodes in {}", new Object[]{element, this.rtree.count(), this.rtree});
                }
                if (this.reinsert) {
                    if (log.isTraceEnabled()) {
                        log.trace("before reinsert node count: {}", (Object)this.rtree.count());
                    }
                    this.rtree = RTree.reinsert(this.rtree, this.splitterContext);
                    if (log.isTraceEnabled()) {
                        log.trace("after reinsert node count: {}", (Object)this.rtree.count());
                    }
                }
            } else {
                log.trace("got no rectangles");
            }
            log.trace("end recalculate");
        }
        catch (Exception ex) {
            log.debug("unstable RTree got exception: {}", (Throwable)ex);
        }
    }

    protected void bulkInsert(Collection<T> elements) {
        log.trace("start bulk insert");
        this.clear();
        if (this.boundingRectangleCollector != null) {
            ArrayList entryList = new ArrayList();
            for (T element : elements) {
                entryList.add(new AbstractMap.SimpleEntry<T, Rectangle2D>(element, this.boundingRectangleCollector.getForElement(element)));
            }
            this.rtree = RTree.bulkAdd(this.rtree, this.splitterContext, entryList);
        } else {
            log.trace("got no rectangles");
        }
        log.trace("end recalculate");
    }

    public String toString() {
        return this.rtree.toString();
    }

    public static class Edges<E, V>
    extends SpatialRTree<E, V>
    implements Spatial<E>,
    LayoutVertexPositionChange.Listener<V> {
        private static final Logger log = LoggerFactory.getLogger(Edges.class);
        GraphElementAccessor<V, E> graphElementAccessor;
        VisualizationModel<V, E> visualizationModel;

        public static Builder builder() {
            return new Builder();
        }

        Edges(Builder<E, V> builder) {
            this(builder.visualizationModel, builder.boundingRectangleCollector, builder.splitterContext, builder.reinsert);
        }

        Edges(VisualizationModel<V, E> visualizationModel, BoundingRectangleCollector<E> boundingRectangleCollector, SplitterContext<E> splitterContext, boolean reinsert) {
            super(visualizationModel.getLayoutModel(), splitterContext, reinsert);
            this.visualizationModel = visualizationModel;
            this.boundingRectangleCollector = boundingRectangleCollector;
            this.graphElementAccessor = new RadiusGraphElementAccessor();
            this.rtree = RTree.create();
            this.recalculate();
        }

        @Override
        public Set<E> getVisibleElements(Shape shape) {
            if (!this.isActive() || this.rtree.getRoot().isEmpty()) {
                log.trace("not relaxing so getting from the graph");
                return this.visualizationModel.getGraph().edgeSet();
            }
            this.pickShapes.add(shape);
            Node root = this.rtree.getRoot().get();
            HashSet visibleElements = new HashSet();
            return root.getVisibleElements(visibleElements, shape);
        }

        @Override
        public void update(E element, Point location) {
            try {
                this.gridCache = null;
                if (this.isActive()) {
                    Object n1 = this.visualizationModel.getGraph().getEdgeSource(element);
                    Object n2 = this.visualizationModel.getGraph().getEdgeTarget(element);
                    if (n2 == null) {
                        n2 = n1;
                    }
                    if (n1 != null && n2 != null) {
                        Rectangle2D itsShape = this.boundingRectangleCollector.getForElement(element, (Point)this.layoutModel.apply(n1), (Point)this.layoutModel.apply(n2));
                        TreeNode containingLeaf = this.getContainingLeaf(element);
                        if (containingLeaf != null) {
                            if (((LeafNode)containingLeaf).getBounds().contains(itsShape)) {
                                ((LeafNode)containingLeaf).remove(element);
                                ((LeafNode)containingLeaf).add(this.splitterContext, element, itsShape);
                                log.trace("{} changed in place", element);
                            } else {
                                ((LeafNode)containingLeaf).remove(element);
                                if (log.isTraceEnabled()) {
                                    log.trace("rtree now size {}", (Object)this.rtree.count());
                                }
                                this.rtree = RTree.add(this.rtree, this.splitterContext, element, itsShape);
                                if (log.isTraceEnabled()) {
                                    log.trace("added back {} with {} into rtree size {}", new Object[]{element, itsShape, this.rtree.count()});
                                }
                            }
                        } else {
                            this.rtree = RTree.add(this.rtree, this.splitterContext, element, itsShape);
                        }
                    }
                }
            }
            catch (ConcurrentModificationException cme) {
                log.debug("ignoring CME");
            }
        }

        public void layoutVertexPositionChanged(LayoutVertexPositionChange.Event<V> evt) {
            Object vertex = evt.vertex;
            Point p = evt.location;
            if (this.visualizationModel.getGraph().vertexSet().contains(vertex)) {
                Set edges = this.visualizationModel.getGraph().edgesOf(vertex);
                for (Object edge : edges) {
                    this.update((E)edge, p);
                }
            }
        }

        public void layoutVertexPositionChanged(LayoutVertexPositionChange.GraphEvent<V> evt) {
            Object vertex = evt.vertex;
            Point p = evt.location;
            if (this.visualizationModel.getGraph().vertexSet().contains(vertex)) {
                Set edges = this.visualizationModel.getGraph().edgesOf(vertex);
                for (Object edge : edges) {
                    this.update((E)edge, p);
                }
            }
        }

        @Override
        public E getClosestElement(Point2D p) {
            return this.getClosestElement(p.getX(), p.getY());
        }

        @Override
        public E getClosestElement(double x, double y) {
            double diameter;
            Ellipse2D.Double searchArea;
            Set<E> edges;
            if (!this.isActive() || this.rtree.getRoot().isEmpty()) {
                return (E)this.graphElementAccessor.getEdge(this.layoutModel, x, y);
            }
            Node root = this.rtree.getRoot().get();
            double radius = this.layoutModel.getWidth() / 20;
            E closest = null;
            while (closest == null && (closest = (E)this.getClosestEdge(edges = this.getVisibleElements(searchArea = new Ellipse2D.Double(x - radius, y - radius, diameter = radius * 2.0, diameter)), x, y, radius)) == null && edges.size() < this.layoutModel.getGraph().edgeSet().size()) {
                radius *= 2.0;
            }
            return closest;
        }

        protected E getClosestEdge(Collection<E> edges, double x, double y, double radius) {
            double radiusSq = radius * radius;
            if (edges.size() > 0) {
                double closestSoFar = Double.MAX_VALUE;
                E winner = null;
                double winningDistance = -1.0;
                for (E edge : edges) {
                    Graph<V, E> graph = this.visualizationModel.getGraph();
                    Object u = graph.getEdgeSource(edge);
                    Object v = graph.getEdgeTarget(edge);
                    Point up = (Point)this.layoutModel.apply(u);
                    Point vp = (Point)this.layoutModel.apply(v);
                    Line2D.Double line = new Line2D.Double(up.x, up.y, vp.x, vp.y);
                    double dist = line.ptSegDist(x, y);
                    if (!(dist < radiusSq) || !(dist < closestSoFar)) continue;
                    closestSoFar = dist;
                    winner = edge;
                    winningDistance = dist;
                }
                if (log.isTraceEnabled()) {
                    log.trace("closest winner is {} at distance {}", winner, (Object)winningDistance);
                }
                return winner;
            }
            return null;
        }

        @Override
        protected List<Shape> collectGrids(List<Shape> list, RTree<E> tree) {
            if (tree.getRoot().isPresent()) {
                Node<E> root = tree.getRoot().get();
                root.collectGrids(list);
            }
            return list;
        }

        @Override
        public void recalculate() {
            this.gridCache = null;
            log.trace("called recalculate while active:{} layout model relaxing:{}", (Object)this.isActive(), (Object)this.layoutModel.isRelaxing());
            if (this.isActive()) {
                if (log.isTraceEnabled()) {
                    log.trace("recalculate for edges: {}", (Object)this.visualizationModel.getGraph().edgeSet());
                }
                this.recalculate(this.visualizationModel.getGraph().edgeSet());
            }
        }

        public static class Builder<E, V>
        extends org.jungrapht.visualization.spatial.SpatialRTree$Builder<E, V> {
            @Override
            public Builder<E, V> visualizationModel(VisualizationModel visualizationModel) {
                this.visualizationModel = visualizationModel;
                return this;
            }

            @Override
            public Edges<E, V> build() {
                return new Edges(this);
            }
        }
    }

    public static class Vertices<V>
    extends SpatialRTree<V, V>
    implements Spatial<V>,
    LayoutVertexPositionChange.Listener<V> {
        private static final Logger log = LoggerFactory.getLogger(Vertices.class);

        public static Builder builder() {
            return new Builder();
        }

        Vertices(Builder<V> builder) {
            this(builder.visualizationModel, builder.boundingRectangleCollector, builder.splitterContext, builder.reinsert);
        }

        Vertices(VisualizationModel visualizationModel, BoundingRectangleCollector<V> boundingRectangleCollector, SplitterContext<V> splitterContext, boolean reinsert) {
            super(visualizationModel.getLayoutModel(), splitterContext, reinsert);
            this.boundingRectangleCollector = boundingRectangleCollector;
            this.rtree = RTree.create();
        }

        @Override
        public Set<V> getVisibleElements(Shape shape) {
            if (!this.isActive() || this.rtree.getRoot().isEmpty()) {
                return this.layoutModel.getGraph().vertexSet();
            }
            this.pickShapes.add(shape);
            Node root = this.rtree.getRoot().get();
            if (log.isTraceEnabled()) {
                log.trace("out of nodes {}", (Object)this.layoutModel.getGraph().vertexSet());
            }
            HashSet visibleElements = new HashSet();
            return root.getVisibleElements(visibleElements, shape);
        }

        @Override
        public void update(V element, Point location) {
            try {
                this.gridCache = null;
                if (this.isActive() && this.rtree.getRoot().isPresent()) {
                    TreeNode containingLeaf = this.getContainingLeaf(element);
                    Rectangle2D itsShape = this.boundingRectangleCollector.getForElement(element, location);
                    if (containingLeaf != null) {
                        if (((LeafNode)containingLeaf).getBounds().contains(itsShape)) {
                            ((LeafNode)containingLeaf).remove(element);
                            ((LeafNode)containingLeaf).add(this.splitterContext, element, itsShape);
                        } else {
                            this.rtree = RTree.remove(this.rtree, element);
                            this.rtree = RTree.add(this.rtree, this.splitterContext, element, itsShape);
                        }
                    } else {
                        this.rtree = RTree.add(this.rtree, this.splitterContext, element, itsShape);
                    }
                }
            }
            catch (ConcurrentModificationException cme) {
                log.debug("ignoring CME");
            }
        }

        @Override
        public V getClosestElement(Point2D p) {
            return this.getClosestElement(p.getX(), p.getY());
        }

        @Override
        public V getClosestElement(double x, double y) {
            double diameter;
            Ellipse2D.Double searchArea;
            Set<V> nodes;
            if (!this.isActive() || this.rtree.getRoot().isEmpty()) {
                return (V)this.fallback.getVertex(this.layoutModel, x, y);
            }
            double radius = this.layoutModel.getWidth() / 20;
            V closest = null;
            while (closest == null && (closest = (V)this.getClosest(nodes = this.getVisibleElements(searchArea = new Ellipse2D.Double(x - radius, y - radius, diameter = radius * 2.0, diameter)), x, y, radius)) == null && nodes.size() < this.layoutModel.getGraph().vertexSet().size()) {
                radius *= 2.0;
            }
            return closest;
        }

        @Override
        protected List<Shape> collectGrids(List<Shape> list, RTree<V> tree) {
            if (tree.getRoot().isPresent()) {
                Node<V> root = tree.getRoot().get();
                root.collectGrids(list);
            }
            return list;
        }

        @Override
        public void recalculate() {
            try {
                this.gridCache = null;
                log.trace("called recalculate while active:{} layout model relaxing:{}", (Object)this.isActive(), (Object)this.layoutModel.isRelaxing());
                if (this.isActive()) {
                    if (log.isTraceEnabled()) {
                        log.trace("recalculate for nodes: {}", (Object)this.layoutModel.getGraph().vertexSet());
                    }
                    this.recalculate(this.layoutModel.getGraph().vertexSet());
                } else {
                    log.trace("no recalculate when active: {}", (Object)this.isActive());
                }
            }
            catch (ConcurrentModificationException ex) {
                this.recalculate();
            }
            log.trace("recalculate tries");
        }

        public void layoutVertexPositionChanged(LayoutVertexPositionChange.GraphEvent<V> evt) {
            this.update((V)evt.vertex, evt.location);
        }

        public void layoutVertexPositionChanged(LayoutVertexPositionChange.Event<V> evt) {
            this.update((V)evt.vertex, evt.location);
        }

        public static class Builder<V>
        extends org.jungrapht.visualization.spatial.SpatialRTree$Builder<V, V> {
            public Vertices<V> build() {
                return new Vertices(this);
            }
        }
    }

    public static abstract class Builder<T, NT> {
        protected VisualizationModel visualizationModel;
        protected LayoutModel<NT> layoutModel;
        protected BoundingRectangleCollector<T> boundingRectangleCollector;
        protected SplitterContext<T> splitterContext;
        protected boolean reinsert;

        public Builder<T, NT> boundingRectangleCollector(BoundingRectangleCollector<T> boundingRectangleCollector) {
            this.boundingRectangleCollector = boundingRectangleCollector;
            return this;
        }

        public Builder<T, NT> visualizationModel(VisualizationModel visualizationModel) {
            this.visualizationModel = visualizationModel;
            return this;
        }

        public Builder<T, NT> layoutModel(LayoutModel<NT> layoutModel) {
            this.layoutModel = layoutModel;
            return this;
        }

        public Builder<T, NT> splitterContext(SplitterContext<T> splitterContext) {
            this.splitterContext = splitterContext;
            return this;
        }

        public Builder<T, NT> reinsert(boolean reinsert) {
            this.reinsert = reinsert;
            return this;
        }

        public abstract SpatialRTree<T, NT> build();
    }
}

