/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.subLayout;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jgrapht.Graph;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.subLayout.GraphCollapser;
import org.jungrapht.visualization.subLayout.VisualGraphCollapser;

public interface Collapser<V, E> {
    public V collapse(Collection<V> var1);

    public void expand(Collection<V> var1);

    public void expand(V var1);

    public Function<V, Graph<V, E>> collapsedGraphFunction();

    public Map<V, Graph<V, E>> getCollapsedGraphMap();

    public V findOwnerOf(V var1);

    public static <V, E> Collapser<V, E> forGraph(Graph<V, E> graph, Supplier<V> vertexFactory) {
        return new GraphCollapser<V, E>(graph, vertexFactory);
    }

    public static <V, E> Collapser<V, E> forVisualization(VisualizationServer<V, E> vv, Supplier<V> vertexFactory) {
        return new VisualGraphCollapser<V, E>(vv, vertexFactory);
    }
}

