/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.subLayout;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jungrapht.visualization.util.TreeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeCollapser<V, E> {
    private static Logger log = LoggerFactory.getLogger(TreeCollapser.class);
    Graph<V, E> tree;
    Supplier<V> vertexFactory;
    protected final Map<V, Graph<V, E>> vertexToClusterMap = new HashMap<V, Graph<V, E>>();

    public Function<V, Graph<V, E>> collapsedGraphFunction() {
        return v -> this.vertexToClusterMap.get(v);
    }

    public TreeCollapser(Graph<V, E> graph, Supplier<V> vertexFactory) {
        this.tree = graph;
        this.vertexFactory = vertexFactory;
    }

    public Collection<V> collapse(Collection<V> roots) {
        Set set = roots.stream().filter(r -> this.tree.outDegreeOf(r) != 0).collect(Collectors.toSet());
        for (V v : roots) {
            set.add(this.collapse(v));
        }
        return set;
    }

    public V collapse(V subRoot) {
        if (this.tree.containsVertex(subRoot) && this.tree.outDegreeOf(subRoot) != 0) {
            Graph<V, E> subTree = TreeUtils.getSubTree(this.tree, subRoot);
            V collapseVertex = this.vertexFactory.get();
            this.vertexToClusterMap.put((Graph<V, E>)collapseVertex, (Graph<Graph<V, E>, E>)subTree);
            if (log.isTraceEnabled()) {
                log.trace("subTree of {} is {}", subRoot, subTree);
            }
            if (this.tree.incomingEdgesOf(subRoot).isEmpty()) {
                TreeUtils.removeTreeVertex(this.tree, subRoot);
                this.tree.addVertex(collapseVertex);
            } else {
                if (log.isTraceEnabled()) {
                    log.trace("collapse at subroot {}", subRoot);
                }
                for (Object parent : Graphs.predecessorListOf(this.tree, subRoot)) {
                    Object parentEdge = this.tree.incomingEdgesOf(subRoot).stream().findFirst().get();
                    TreeUtils.removeTreeVertex(this.tree, subRoot);
                    this.tree.addVertex(parent);
                    this.tree.addVertex(collapseVertex);
                    this.tree.addEdge(parent, collapseVertex, parentEdge);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("made this subtree {}", subTree);
            }
            return collapseVertex;
        }
        return null;
    }

    public void expand(Collection<V> collapsedRoots) {
        collapsedRoots.forEach(this::expand);
    }

    public void expand(V collapseVertex) {
        Graph<V, E> subTree = this.vertexToClusterMap.get(collapseVertex);
        if (subTree != null) {
            Set incomingEdges = this.tree.incomingEdgesOf(collapseVertex);
            if (log.isTraceEnabled()) {
                log.trace("incoming edges are {}", (Object)incomingEdges);
            }
            this.vertexToClusterMap.remove(collapseVertex);
            if (incomingEdges.isEmpty()) {
                Set<V> roots = TreeUtils.roots(subTree);
                for (V root : roots) {
                    TreeUtils.growSubTree(subTree, this.tree, root);
                }
                this.tree.removeVertex(collapseVertex);
                return;
            }
            if (TreeUtils.roots(subTree).isEmpty()) {
                return;
            }
            Object parentEdge = incomingEdges.stream().findFirst().get();
            Object parent = this.tree.getEdgeSource(parentEdge);
            if (log.isTraceEnabled()) {
                log.trace("parentEdge {}", parentEdge);
                log.trace("tree contains edge {} is {}", parentEdge, (Object)this.tree.containsEdge(parentEdge));
            }
            if (parent != null) {
                this.tree.removeVertex(collapseVertex);
                TreeUtils.addSubTree(this.tree, subTree, parent, parentEdge);
            } else {
                TreeUtils.growSubTree(subTree, this.tree, parent);
            }
            this.tree.removeVertex(collapseVertex);
        }
    }

    protected void setGraph(Graph<V, E> graph) {
        this.tree = graph;
    }
}

