/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.subLayout;

import java.util.Collection;
import java.util.HashSet;
import java.util.function.Supplier;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.subLayout.GraphCollapser;

public class VisualGraphCollapser<V, E>
extends GraphCollapser<V, E> {
    protected VisualizationServer<V, E> vv;

    public VisualGraphCollapser(VisualizationServer<V, E> vv, Supplier<V> vertexSupplier) {
        super(vv.getVisualizationModel().getGraph(), vertexSupplier);
        this.vv = vv;
    }

    @Override
    public V collapse(Collection<V> selected) {
        if (this.graph == null || this.vv.getVisualizationModel().getGraph() != this.graph) {
            this.setGraph(this.vv.getVisualizationModel().getGraph());
        }
        if ((selected = new HashSet<V>(selected)).size() > 1) {
            LayoutModel<V> layoutModel = this.vv.getVisualizationModel().getLayoutModel();
            V clusterVertex = super.collapse(selected);
            double sumx = 0.0;
            double sumy = 0.0;
            for (V v : selected) {
                Point p = (Point)layoutModel.apply(v);
                sumx += p.x;
                sumy += p.y;
            }
            Point cp = Point.of((double)(sumx / (double)selected.size()), (double)(sumy / (double)selected.size()));
            layoutModel.getLayoutStateChangeSupport().fireLayoutStateChanged(layoutModel, true);
            layoutModel.lock(false);
            layoutModel.set(clusterVertex, cp);
            layoutModel.lock(clusterVertex, true);
            this.vv.getRenderContext().getParallelEdgeIndexFunction().reset();
            layoutModel.accept(this.vv.getVisualizationModel().getLayoutAlgorithm());
            this.vv.repaint();
            return clusterVertex;
        }
        return null;
    }

    @Override
    public void expand(Collection<V> clusterVertices) {
        HashSet<V> picked = new HashSet<V>(clusterVertices);
        LayoutModel<V> layoutModel = this.vv.getVisualizationModel().getLayoutModel();
        super.expand(picked);
        layoutModel.lock(false);
        this.vv.getRenderContext().getParallelEdgeIndexFunction().reset();
        layoutModel.accept(this.vv.getVisualizationModel().getLayoutAlgorithm());
        this.vv.getSelectedVertexState().clear();
        this.vv.repaint();
    }
}

