/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.util;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BoundingRectangleCollector<T> {
    protected LayoutModel layoutModel;
    protected List<Rectangle2D> rectangles = new ArrayList<Rectangle2D>();

    public BoundingRectangleCollector(LayoutModel layoutModel) {
        this.layoutModel = layoutModel;
    }

    public abstract Rectangle2D getForElement(T var1);

    public abstract Rectangle2D getForElement(T var1, Point var2);

    public abstract Rectangle2D getForElement(T var1, Point var2, Point var3);

    public List<Rectangle2D> getRectangles() {
        return this.rectangles;
    }

    public void compute() {
        this.rectangles.clear();
    }

    public static final class Edges<V, E>
    extends BoundingRectangleCollector<E> {
        private static final double NON_EMPTY_DELTA = 0.001;
        protected Function<V, Shape> vertexShapeFunction;
        protected BiFunction<Graph<V, E>, E, Shape> edgeShapeFunction;

        public Edges(Function<V, Shape> vertexShapeFunction, BiFunction<Graph<V, E>, E, Shape> edgeShapeFunction, LayoutModel<V> layoutModel) {
            super(layoutModel);
            this.vertexShapeFunction = vertexShapeFunction;
            this.edgeShapeFunction = edgeShapeFunction;
            this.compute();
        }

        @Override
        public Rectangle2D getForElement(E edge) {
            Graph graph = this.layoutModel.getGraph();
            Object v1 = graph.getEdgeSource(edge);
            Object v2 = graph.getEdgeTarget(edge);
            Point p1 = (Point)this.layoutModel.apply(v1);
            Point p2 = (Point)this.layoutModel.apply(v2);
            float x1 = (float)p1.x;
            float y1 = (float)p1.y;
            float x2 = (float)p2.x;
            float y2 = (float)p2.y;
            boolean isLoop = v1.equals(v2);
            Shape s2 = this.vertexShapeFunction.apply(v2);
            Shape edgeShape = this.edgeShapeFunction.apply(this.layoutModel.getGraph(), edge);
            AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
            if (isLoop) {
                Rectangle2D s2Bounds = s2.getBounds2D();
                xform.scale(s2Bounds.getWidth(), s2Bounds.getHeight());
                xform.translate(0.0, -edgeShape.getBounds2D().getWidth() / 2.0);
            } else {
                float dx = x2 - x1;
                float dy = y2 - y1;
                float theta = (float)Math.atan2(dy, dx);
                xform.rotate(theta);
                float dist = (float)p1.distance(p2);
                if (edgeShape instanceof Path2D) {
                    xform.scale(dist, dist);
                } else {
                    xform.scale(dist, 1.0);
                }
            }
            edgeShape = xform.createTransformedShape(edgeShape);
            return this.nonEmpty(edgeShape.getBounds2D(), 0.001);
        }

        @Override
        public Rectangle2D getForElement(E element, Point p) {
            return this.getForElement(element, p, p);
        }

        @Override
        public Rectangle2D getForElement(E edge, Point p1, Point p2) {
            Graph graph = this.layoutModel.getGraph();
            Object v1 = graph.getEdgeSource(edge);
            Object v2 = graph.getEdgeTarget(edge);
            float x1 = (float)p1.x;
            float y1 = (float)p1.y;
            float x2 = (float)p2.x;
            float y2 = (float)p2.y;
            boolean isLoop = v1.equals(v2);
            Shape s2 = this.vertexShapeFunction.apply(v2);
            Shape edgeShape = this.edgeShapeFunction.apply(this.layoutModel.getGraph(), edge);
            AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
            if (isLoop) {
                Rectangle2D s2Bounds = s2.getBounds2D();
                xform.scale(s2Bounds.getWidth(), s2Bounds.getHeight());
                xform.translate(0.0, -edgeShape.getBounds2D().getWidth() / 2.0);
            } else {
                float dx = x2 - x1;
                float dy = y2 - y1;
                float theta = (float)Math.atan2(dy, dx);
                xform.rotate(theta);
                float dist = (float)p1.distance(p2);
                if (edgeShape instanceof Path2D) {
                    xform.scale(dist, dist);
                } else {
                    xform.scale(dist, 1.0);
                }
            }
            edgeShape = xform.createTransformedShape(edgeShape);
            return this.nonEmpty(edgeShape.getBounds2D(), 0.001);
        }

        @Override
        public void compute() {
            super.compute();
            Graph graph = this.layoutModel.getGraph();
            for (Object e : graph.edgeSet()) {
                Object v1 = graph.getEdgeSource(e);
                Object v2 = graph.getEdgeTarget(e);
                Point p1 = (Point)this.layoutModel.apply(v1);
                Point p2 = (Point)this.layoutModel.apply(v2);
                float x1 = (float)p1.x;
                float y1 = (float)p1.y;
                float x2 = (float)p2.x;
                float y2 = (float)p2.y;
                boolean isLoop = v1.equals(v2);
                Shape s2 = this.vertexShapeFunction.apply(v2);
                Shape edgeShape = this.edgeShapeFunction.apply(this.layoutModel.getGraph(), e);
                AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
                if (isLoop) {
                    Rectangle2D s2Bounds = s2.getBounds2D();
                    xform.scale(s2Bounds.getWidth(), s2Bounds.getHeight());
                    xform.translate(0.0, -edgeShape.getBounds2D().getWidth() / 2.0);
                } else {
                    float dx = x2 - x1;
                    float dy = y2 - y1;
                    float theta = (float)Math.atan2(dy, dx);
                    xform.rotate(theta);
                    float dist = (float)p1.distance(p2);
                    if (edgeShape instanceof Path2D) {
                        xform.scale(dist, dist);
                    } else {
                        xform.scale(dist, 1.0);
                    }
                }
                edgeShape = xform.createTransformedShape(edgeShape);
                this.rectangles.add(this.nonEmpty(edgeShape.getBounds2D(), 0.001));
            }
        }

        private Rectangle2D nonEmpty(Rectangle2D r, double delta) {
            if (r.getHeight() == 0.0) {
                r.setFrame(r.getX(), r.getY(), r.getWidth(), delta);
            }
            if (r.getWidth() == 0.0) {
                r.setFrame(r.getX(), r.getY(), delta, r.getHeight());
            }
            return r;
        }
    }

    public static final class Vertices<V>
    extends BoundingRectangleCollector<V> {
        private static final Logger log = LoggerFactory.getLogger(Vertices.class);
        protected Function<V, Shape> vertexShapeFunction;

        public Vertices(Function<V, Shape> vertexShapeFunction, LayoutModel layoutModel) {
            super(layoutModel);
            this.vertexShapeFunction = vertexShapeFunction;
            this.compute();
        }

        @Override
        public Rectangle2D getForElement(V vertex) {
            Shape shape = this.vertexShapeFunction.apply(vertex);
            Point p = (Point)this.layoutModel.apply(vertex);
            float x = (float)p.x;
            float y = (float)p.y;
            AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
            Rectangle2D xfs = xform.createTransformedShape(shape).getBounds2D();
            log.trace("vertex {} with shape bounds {} is at {}", new Object[]{vertex, xfs, p});
            return xfs;
        }

        @Override
        public Rectangle2D getForElement(V vertex, Point p1, Point p2) {
            return this.getForElement(vertex, p1);
        }

        @Override
        public Rectangle2D getForElement(V vertex, Point p) {
            Shape shape = this.vertexShapeFunction.apply(vertex);
            log.trace("vertex is at {}", (Object)p);
            float x = (float)p.x;
            float y = (float)p.y;
            AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
            return xform.createTransformedShape(shape).getBounds2D();
        }

        public void compute(Collection<V> vertices) {
            super.compute();
            for (V v : vertices) {
                Shape shape = this.vertexShapeFunction.apply(v);
                Point p = (Point)this.layoutModel.apply(v);
                float x = (float)p.x;
                float y = (float)p.y;
                AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
                shape = xform.createTransformedShape(shape);
                this.rectangles.add(shape.getBounds2D());
            }
        }

        @Override
        public void compute() {
            super.compute();
            for (Object v : this.layoutModel.getGraph().vertexSet()) {
                Shape shape = this.vertexShapeFunction.apply(v);
                Point p = (Point)this.layoutModel.apply(v);
                float x = (float)p.x;
                float y = (float)p.y;
                AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
                shape = xform.createTransformedShape(shape);
                this.rectangles.add(shape.getBounds2D());
            }
        }
    }

    public static final class Points<V>
    extends BoundingRectangleCollector<V> {
        private static final Logger log = LoggerFactory.getLogger(Points.class);
        protected Function<V, Shape> vertexShapeFunction;

        public Points(Function<V, Shape> vertexShapeFunction, LayoutModel layoutModel) {
            super(layoutModel);
            this.vertexShapeFunction = vertexShapeFunction;
            this.compute();
        }

        @Override
        public Rectangle2D getForElement(V vertex) {
            Rectangle2D.Double shape = new Rectangle2D.Double();
            Point p = (Point)this.layoutModel.apply(vertex);
            float x = (float)p.x;
            float y = (float)p.y;
            AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
            Rectangle2D xfs = xform.createTransformedShape(shape).getBounds2D();
            log.trace("vertex {} with shape bounds {} is at {}", new Object[]{vertex, xfs, p});
            return xfs;
        }

        @Override
        public Rectangle2D getForElement(V vertex, Point p1, Point p2) {
            return this.getForElement(vertex, p1);
        }

        @Override
        public Rectangle2D getForElement(V vertex, Point p) {
            Shape shape = this.vertexShapeFunction.apply(vertex);
            log.trace("vertex is at {}", (Object)p);
            float x = (float)p.x;
            float y = (float)p.y;
            AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
            return xform.createTransformedShape(shape).getBounds2D();
        }

        public void compute(Collection<V> vertices) {
            super.compute();
            for (V v : vertices) {
                Shape shape = this.vertexShapeFunction.apply(v);
                Point p = (Point)this.layoutModel.apply(v);
                float x = (float)p.x;
                float y = (float)p.y;
                AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
                shape = xform.createTransformedShape(shape);
                this.rectangles.add(shape.getBounds2D());
            }
        }

        @Override
        public void compute() {
            super.compute();
            Graph graph = this.layoutModel.getGraph();
            for (Object v : graph.vertexSet()) {
                Shape shape = this.vertexShapeFunction.apply(v);
                Point p = (Point)this.layoutModel.apply(v);
                float x = (float)p.x;
                float y = (float)p.y;
                AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
                shape = xform.createTransformedShape(shape);
                this.rectangles.add(shape.getBounds2D());
            }
        }
    }
}

