/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.util;

import java.util.concurrent.CompletableFuture;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.layout.algorithms.AbstractIterativeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.util.AnimationLayoutAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutAlgorithmThreadedTransition {
    private static Logger log = LoggerFactory.getLogger(LayoutAlgorithmThreadedTransition.class);

    public static <V, E> void animate(VisualizationServer<V, E> visualizationServer, LayoutAlgorithm<V> endLayoutAlgorithm) {
        LayoutAlgorithmThreadedTransition.animate(visualizationServer, endLayoutAlgorithm, () -> {});
    }

    public static <V, E> void animate(VisualizationServer<V, E> visualizationServer, LayoutAlgorithm<V> endLayoutAlgorithm, Runnable after) {
        LayoutAlgorithmThreadedTransition.fireLayoutStateChanged(visualizationServer.getVisualizationModel().getLayoutModel(), true);
        endLayoutAlgorithm.setAfter(after);
        AbstractIterativeLayoutAlgorithm transitionLayoutAlgorithm = ((AnimationLayoutAlgorithm.Builder)((AnimationLayoutAlgorithm.Builder)((Object)((AnimationLayoutAlgorithm.Builder)((Object)AnimationLayoutAlgorithm.builder().after(after))).visualizationServer(visualizationServer))).endLayoutAlgorithm(endLayoutAlgorithm).prerelax(false)).build();
        CompletableFuture.runAsync(() -> LayoutAlgorithmThreadedTransition.lambda$animate$1(visualizationServer, (LayoutAlgorithm)transitionLayoutAlgorithm));
    }

    public static <V, E> void apply(VisualizationServer<V, E> visualizationServer, LayoutAlgorithm<V> endLayoutAlgorithm, Runnable after) {
        endLayoutAlgorithm.setAfter(after);
        CompletableFuture.runAsync(() -> visualizationServer.getVisualizationModel().setLayoutAlgorithm(endLayoutAlgorithm));
    }

    public static <V, E> void apply(VisualizationServer<V, E> visualizationServer, LayoutAlgorithm<V> endLayoutAlgorithm) {
        LayoutAlgorithmThreadedTransition.apply(visualizationServer, endLayoutAlgorithm, () -> {});
    }

    private static void fireLayoutStateChanged(LayoutModel layoutModel, boolean state) {
        log.trace("fireLayoutStateChanged to {}", (Object)state);
        layoutModel.getLayoutStateChangeSupport().fireLayoutStateChanged(layoutModel, state);
    }

    private static /* synthetic */ void lambda$animate$1(VisualizationServer visualizationServer, LayoutAlgorithm transitionLayoutAlgorithm) {
        visualizationServer.getVisualizationModel().setLayoutAlgorithm(transitionLayoutAlgorithm);
    }
}

